/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.toolbar;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import jd.controlling.proxy.ProxyController;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.translate._JDT;

public class SetProxySetupAction
extends CustomizableAppAction
implements ActionContext {
    private String path = null;

    public SetProxySetupAction() {
        this.addContextSetup(this);
        this.setName(_GUI.T.SetProxySetupAction_SetProxySetupAction_());
        this.setIconKey("proxy");
    }

    public static String getTranslationForPath() {
        return _JDT.T.SetProxySetupAction_getTranslationForPath();
    }

    @Customizer(link="#getTranslationForPath")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setEnabled(this.isValidPath(path));
        this.updateIcon(path);
    }

    public void updateIcon(String path) {
        if (StringUtils.equals((String)ProxyController.getInstance().getLatestProfilePath(), (String)path) && StringUtils.isNotEmpty((String)path)) {
            this.setIconKey("proxy_rotate");
        } else {
            this.setIconKey("proxy");
        }
    }

    public boolean isValidPath(String path) {
        return new File(path).exists() && path.endsWith(".jdproxies");
    }

    public void actionPerformed(ActionEvent e) {
        try {
            ProxyController.getInstance().importFrom(new File(this.getPath()));
        }
        catch (IOException e1) {
            Dialog.getInstance().showExceptionDialog(_GUI.T.lit_error_occured(), e1.getMessage(), (Throwable)e1);
        }
        finally {
            this.updateIcon(this.getPath());
        }
    }
}

