/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.appwork.swing.components.CheckBoxIcon;

public class ExtRealCheckBoxMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -2308936338542479539L;
    private boolean hideOnClick = true;
    protected Icon selIcon;
    protected Icon unselIcon;

    public ExtRealCheckBoxMenuItem(AbstractAction action) {
        super(action);
        this.selIcon = CheckBoxIcon.TRUE;
        this.unselIcon = CheckBoxIcon.FALSE;
        this.setIcon(this.unselIcon);
        this.setSelected(action.getValue("SwingSelectedKey") == Boolean.TRUE);
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        this.updateIcon();
        if (this.getAction() != null) {
            this.getAction().putValue("SwingSelectedKey", b);
        }
    }

    protected void updateIcon() {
        if (this.isSelected()) {
            this.setIcon(this.selIcon);
        } else {
            this.setIcon(this.unselIcon);
        }
    }

    public ExtRealCheckBoxMenuItem(String name) {
        super(name);
    }

    public boolean isHideOnClick() {
        return this.hideOnClick;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (!this.hideOnClick && e.getID() == 502) {
            this.setSelected(!this.isSelected());
            for (ActionListener al : this.getActionListeners()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                al.actionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        } else {
            super.processMouseEvent(e);
        }
    }

    public void setHideOnClick(boolean hideOnClick) {
        this.hideOnClick = hideOnClick;
    }
}

