/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.UrlDisplayType;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class LinkTreeUtils {
    public static <T extends AbstractNode> List<T> getPackages(AbstractNode contextObject, List<AbstractNode> selection, List<T> container) {
        HashSet<AbstractNode> ret = new HashSet<AbstractNode>();
        if (contextObject != null) {
            if (contextObject instanceof AbstractPackageNode) {
                ret.add(contextObject);
            } else {
                ret.add((AbstractNode)((AbstractPackageChildrenNode)contextObject).getParentNode());
            }
        }
        if (selection != null) {
            for (AbstractNode a : selection) {
                if (a instanceof AbstractPackageNode) {
                    ret.add(a);
                    continue;
                }
                ret.add((AbstractNode)((AbstractPackageChildrenNode)a).getParentNode());
            }
        }
        container.addAll(ret);
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends AbstractNode> List<T> getSelectedChildren(List<AbstractNode> selection2, List<T> container) {
        HashSet<AbstractNode> has = new HashSet<AbstractNode>(selection2);
        HashSet<AbstractNode> ret = new HashSet<AbstractNode>();
        for (AbstractNode node : selection2) {
            if (node instanceof AbstractPackageChildrenNode) {
                ret.add(node);
                continue;
            }
            boolean readL = ((AbstractPackageNode)node).getModifyLock().readLock();
            try {
                List childs;
                if (!((AbstractPackageNode)node).isExpanded()) {
                    childs = ((AbstractPackageNode)node).getChildren();
                    ret.addAll(childs);
                    continue;
                }
                childs = ((AbstractPackageNode)node).getChildren();
                boolean containsNone = true;
                boolean containsAll = true;
                for (AbstractNode l : childs) {
                    if (has.contains(l)) {
                        containsNone = false;
                        continue;
                    }
                    containsAll = false;
                }
                if (!containsAll && !containsNone) continue;
                ret.addAll(childs);
            }
            finally {
                ((AbstractPackageNode)node).getModifyLock().readUnlock(readL);
            }
        }
        container.addAll(ret);
        return container;
    }

    public static File getDownloadDirectory(AbstractNode node) {
        String directory = null;
        if (node instanceof DownloadLink) {
            FilePackage parent = ((DownloadLink)node).getFilePackage();
            if (parent != null) {
                directory = parent.getView().getDownloadDirectory();
            }
            return LinkTreeUtils.getDownloadDirectory(directory, parent == null ? null : parent.getName(), node);
        }
        if (node instanceof FilePackage) {
            directory = ((FilePackage)node).getView().getDownloadDirectory();
            return LinkTreeUtils.getDownloadDirectory(directory, ((FilePackage)node).getName(), node);
        }
        if (node instanceof CrawledLink) {
            CrawledPackage parent = ((CrawledLink)node).getParentNode();
            if (parent != null) {
                directory = parent.getDownloadFolder();
            }
            return LinkTreeUtils.getDownloadDirectory(directory, parent == null ? null : parent.getName(), node);
        }
        if (node instanceof CrawledPackage) {
            directory = ((CrawledPackage)node).getDownloadFolder();
            return LinkTreeUtils.getDownloadDirectory(directory, ((CrawledPackage)node).getName(), node);
        }
        throw new WTFException("Unknown Type: " + node.getClass());
    }

    public static File getRawDownloadDirectory(AbstractNode node) {
        String directory = null;
        if (node != null) {
            if (node instanceof DownloadLink) {
                FilePackage parent = ((DownloadLink)node).getFilePackage();
                if (parent != null) {
                    directory = parent.getView().getDownloadDirectory();
                }
            } else if (node instanceof FilePackage) {
                directory = ((FilePackage)node).getView().getDownloadDirectory();
            } else if (node instanceof CrawledLink) {
                CrawledPackage parent = ((CrawledLink)node).getParentNode();
                if (parent != null) {
                    directory = parent.getRawDownloadFolder();
                }
            } else if (node instanceof CrawledPackage) {
                directory = ((CrawledPackage)node).getRawDownloadFolder();
            } else {
                throw new WTFException("Unknown Type: " + node.getClass());
            }
        }
        return LinkTreeUtils.getRawDownloadDirectory(directory);
    }

    private static File getRawDownloadDirectory(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return new File(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue());
        }
        if (CrossSystem.isAbsolutePath((String)path)) {
            return new File(path);
        }
        return new File(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue(), path);
    }

    public static File getDownloadDirectory(String path, String packagename, AbstractNode node) {
        if (StringUtils.isEmpty((String)path)) {
            return new File(PackagizerController.replaceDynamicTags(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue(), packagename, node));
        }
        if (CrossSystem.isAbsolutePath((String)(path = PackagizerController.replaceDynamicTags(path, packagename, node)))) {
            return new File(path);
        }
        return new File(PackagizerController.replaceDynamicTags(CFG_GENERAL.DEFAULT_DOWNLOAD_FOLDER.getValue(), packagename, node), path);
    }

    public static String getUrlByType(UrlDisplayType dt, AbstractNode node) {
        DownloadLink link;
        if (node instanceof DownloadLink) {
            link = (DownloadLink)node;
        } else if (node instanceof CrawledLink) {
            link = ((CrawledLink)node).getDownloadLink();
        } else {
            return null;
        }
        switch (dt) {
            case CUSTOM: {
                return link.getCustomUrl();
            }
            case REFERRER: {
                return link.getReferrerUrl();
            }
            case CONTAINER: {
                return link.getContainerUrl();
            }
            case ORIGIN: {
                return link.getOriginUrl();
            }
            case CONTENT: {
                switch (link.getUrlProtection()) {
                    case UNSET: {
                        String contentURL = link.getContentUrl();
                        if (contentURL != null) {
                            return contentURL;
                        }
                        return link.getPluginPatternMatcher();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public static Set<String> getURLs(SelectionInfo<? extends AbstractPackageNode, ? extends AbstractPackageChildrenNode> selectionInfo, boolean openInBrowser) {
        return LinkTreeUtils.getURLs(selectionInfo, openInBrowser, ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isCopySingleRealURL());
    }

    public static Set<String> getURLs(SelectionInfo<? extends AbstractPackageNode, ? extends AbstractPackageChildrenNode> selectionInfo, boolean openInBrowser, boolean copySingleRealURL) {
        LinkedHashSet<String> urls = new LinkedHashSet<String>();
        if (selectionInfo == null || selectionInfo.isEmpty()) {
            return urls;
        }
        String rawURL = null;
        List<? extends AbstractPackageChildrenNode> children = selectionInfo.getChildren();
        for (AbstractPackageChildrenNode abstractPackageChildrenNode : children) {
            String url;
            DownloadLink link;
            if (abstractPackageChildrenNode instanceof DownloadLink) {
                link = (DownloadLink)abstractPackageChildrenNode;
            } else {
                if (!(abstractPackageChildrenNode instanceof CrawledLink)) continue;
                link = ((CrawledLink)abstractPackageChildrenNode).getDownloadLink();
            }
            if (link == null) continue;
            rawURL = link.getCustomUrl();
            if (rawURL == null) {
                rawURL = link.getContentUrlOrPatternMatcher();
            }
            if ((url = link.getView().getDisplayUrl()) == null) continue;
            urls.add(url);
        }
        if (!openInBrowser && (children.size() != 1 || rawURL == null || rawURL.matches("((?-i)ftp|https?)://.+") || !copySingleRealURL) && children.size() == 1 && rawURL != null && copySingleRealURL) {
            urls.clear();
            urls.add(rawURL);
        }
        return urls;
    }
}

