/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerQueue;
import jd.gui.swing.jdgui.BasicJDTable;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtComponentRowHighlighter;
import org.appwork.swing.exttable.ExtOverlayRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.EmptySelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelSelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelSelectionOnlySelectionInfo;
import org.jdownloader.gui.views.components.packagetable.actions.SortPackagesDownloadOrdnerOnColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class PackageControllerTable<ParentType extends AbstractPackageNode<ChildrenType, ParentType>, ChildrenType extends AbstractPackageChildrenNode<ParentType>>
extends BasicJDTable<AbstractNode> {
    public static final KeyStroke KEY_STROKE_ALT_END = KeyStroke.getKeyStroke(35, 8);
    public static final KeyStroke KEY_STROKE_ALT_HOME = KeyStroke.getKeyStroke(36, 8);
    public static final KeyStroke KEY_STROKE_ALT_DOWN = KeyStroke.getKeyStroke(40, 8);
    public static final KeyStroke KEY_STROKE_ALT_UP = KeyStroke.getKeyStroke(38, 8);
    public static final KeyStroke KEY_STROKE_RIGHT = KeyStroke.getKeyStroke(39, 0);
    public static final KeyStroke KEY_STROKE_KP_RIGHT = KeyStroke.getKeyStroke(227, 0);
    public static final KeyStroke KEY_STROKE_LEFT = KeyStroke.getKeyStroke(37, 0);
    public static final KeyStroke KEY_STROKE_KP_LEFT = KeyStroke.getKeyStroke(226, 0);
    private static final long serialVersionUID = 3880570615872972276L;
    private PackageControllerTableModel<ParentType, ChildrenType> tableModel = null;
    private Color sortNotifyColor;
    private Color filterNotifyColor;
    private AppAction moveTopAction = null;
    private AppAction moveUpAction = null;
    private AppAction moveDownAction = null;
    private AppAction moveBottomAction = null;
    private final AtomicLong selectionVersion = new AtomicLong(0L);
    private final DelayedRunnable selectionDelayedUpdate;
    private final boolean wrapAroundEnabled;
    protected volatile WeakReference<AbstractNode> contextMenuTrigger = new WeakReference<Object>(null);
    protected volatile SelectionInfoCache selectionOnly_TableData = null;
    protected volatile SelectionInfoCache selectionOnly_ControllerData = null;
    protected volatile SelectionInfoCache all_TableData = null;
    private final AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);

    public ExtColumn<AbstractNode> getMouseOverColumn() {
        Point mp = ToolTipController.getMouseLocation();
        if (mp == null) {
            return null;
        }
        SwingUtilities.convertPointFromScreen(mp, (Component)((Object)this));
        return this.getExtColumnAtPoint(mp);
    }

    protected boolean isWrapAroundEnabled() {
        return this.wrapAroundEnabled;
    }

    public boolean isColumnLockingFeatureEnabled() {
        return this.getAutoResizeMode() != 0;
    }

    public void setAutoResizeMode(int mode) {
        super.setAutoResizeMode(mode);
    }

    protected void initAlternateRowHighlighter() {
        super.initAlternateRowHighlighter();
        if (CFG_GUI.PACKAGES_BACKGROUND_HIGHLIGHT_ENABLED.isEnabled()) {
            Color tableFG = LAFOptions.getInstance().getColorForTablePackageRowForeground();
            Color tableBG = LAFOptions.getInstance().getColorForTablePackageRowBackground();
            this.getModel().addExtComponentRowHighlighter((ExtComponentRowHighlighter)new ExtComponentRowHighlighter<AbstractNode>(tableFG, tableBG, null){

                public int getPriority() {
                    return 0;
                }

                public boolean accept(ExtColumn<AbstractNode> column, AbstractNode value, boolean selected, boolean focus, int row) {
                    return value instanceof AbstractPackageNode;
                }
            });
        }
    }

    public PackageControllerTable(PackageControllerTableModel<ParentType, ChildrenType> pctm) {
        super(pctm);
        this.tableModel = pctm;
        this.setShowVerticalLines(false);
        this.setSelectionMode(2);
        this.sortNotifyColor = CFG_GUI.SORT_COLUMN_HIGHLIGHT_ENABLED.isEnabled() ? LAFOptions.getInstance().getColorForTableSortedColumnView() : null;
        this.filterNotifyColor = CFG_GUI.CFG.isFilterHighlightEnabled() ? LAFOptions.getInstance().getColorForTableFilteredView() : null;
        this.wrapAroundEnabled = CFG_GUI.CFG.isTableWrapAroundEnabled();
        this.initAppActions();
        this.selectionDelayedUpdate = new DelayedRunnable(500L, 5000L){

            public void delayedrun() {
                PackageControllerTable.this.updateMoveActions();
            }
        };
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e == null || e.getValueIsAdjusting() || PackageControllerTable.this.tableModel.isTableSelectionClearing()) {
                    return;
                }
                PackageControllerTable.this.selectionVersion.incrementAndGet();
                AbstractNode node = (AbstractNode)PackageControllerTable.this.getModel().getObjectbyRow(PackageControllerTable.this.getSelectionModel().getLeadSelectionIndex());
                WeakReference<AbstractNode> lContextMenuTrigger = PackageControllerTable.this.contextMenuTrigger;
                if (lContextMenuTrigger == null || lContextMenuTrigger.get() != node) {
                    PackageControllerTable.this.contextMenuTrigger = new WeakReference<AbstractNode>(node);
                }
            }
        });
        final int horizontalLineWeight = LAFOptions.getInstance().getCfg().getLinkTableHorizontalRowLineWeight();
        if (horizontalLineWeight > 0) {
            this.setRowMargin(horizontalLineWeight);
            final Color color = LAFOptions.getInstance().getColorForTableRowGap();
            if (color != null) {
                this.addRowHighlighter(new ExtOverlayRowHighlighter(null, null){
                    private BasicStroke stroke;
                    {
                        super(x0, x1);
                        this.stroke = new BasicStroke(horizontalLineWeight);
                    }

                    public void paint(Graphics2D g, int x, int y, int width, int height) {
                        g.setColor(color);
                        g.setStroke(this.stroke);
                        g.drawLine(x, y + height, x + width, y + height);
                    }

                    public boolean doHighlight(ExtTable<?> extTable, int row) {
                        return true;
                    }
                });
            }
        }
    }

    public void getSelectionInfo(SelectionInfoCallback<ParentType, ChildrenType> callback, SelectionType selectionType) {
        boolean[] selectionInfoParam = new boolean[2];
        switch (selectionType) {
            case UNSELECTED: 
            case SELECTED: {
                selectionInfoParam[0] = true;
                selectionInfoParam[1] = true;
                break;
            }
            case ALL: {
                selectionInfoParam[0] = false;
                selectionInfoParam[1] = true;
                break;
            }
            case BACKEND: {
                selectionInfoParam[0] = false;
                selectionInfoParam[1] = false;
                break;
            }
            default: {
                EmptySelectionInfo<ParentType, ChildrenType> selectionInfo = new EmptySelectionInfo<ParentType, ChildrenType>(this.getController());
                if (!callback.isCancelled()) {
                    callback.onSelectionInfo(selectionInfo);
                }
                return;
            }
        }
        this.getSelectionInfo(callback, selectionInfoParam[0], selectionInfoParam[1]);
    }

    protected boolean isExpandToggleEvent(MouseEvent e) {
        ExtColumn column = this.getExtColumnAtPoint(e.getPoint());
        if (column == this.getExpandCollapseColumn()) {
            Rectangle bounds = column.getBounds();
            if (e.getPoint().x - bounds.x < 39) {
                int row = this.rowAtPoint(e.getPoint());
                AbstractNode node = (AbstractNode)this.getModel().getObjectbyRow(row);
                if (node instanceof AbstractPackageNode) {
                    return e.getID() != 502 || e.getPoint().x - bounds.x <= 18 || !CrossSystem.isContextMenuTrigger((MouseEvent)e);
                }
            }
        }
        return false;
    }

    protected void processMouseEvent(MouseEvent e) {
        boolean isPressed;
        boolean bl = isPressed = e.getID() == 501;
        if (isPressed) {
            int row = this.rowAtPoint(e.getPoint());
            AbstractNode node = (AbstractNode)this.getModel().getObjectbyRow(row);
            WeakReference<AbstractNode> lContextMenuTrigger = this.contextMenuTrigger;
            if (lContextMenuTrigger == null || lContextMenuTrigger.get() != node) {
                this.contextMenuTrigger = new WeakReference<AbstractNode>(node);
            }
        }
        if ((isPressed || e.getID() == 502) && this.isExpandToggleEvent(e)) {
            return;
        }
        super.processMouseEvent(e);
    }

    protected AbstractNode getContextMenuTrigger() {
        WeakReference<AbstractNode> lContextMenuTrigger = this.contextMenuTrigger;
        if (lContextMenuTrigger != null) {
            return (AbstractNode)lContextMenuTrigger.get();
        }
        return null;
    }

    protected void onSelectionInfoCallback(final SelectionInfoCallback<ParentType, ChildrenType> callback, final SelectionInfo<ParentType, ChildrenType> selectionInfo) {
        if (callback instanceof QueueSelectionInfoCallback) {
            QueueSelectionInfoCallback qcallback = (QueueSelectionInfoCallback)callback;
            Queue queue = qcallback.getQueue();
            if (queue == null) {
                queue = this.getModel().getController().getQueue();
            }
            if (Thread.currentThread() != queue.getQueueThread()) {
                queue.add((QueueAction)new PackageControllerQueue.ReadOnlyQueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

                    protected Void run() throws RuntimeException {
                        callback.onSelectionInfo(selectionInfo);
                        return null;
                    }
                });
                return;
            }
        }
        if (callback instanceof EDTSelectionInfoCallback && !SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    callback.onSelectionInfo(selectionInfo);
                }
            });
            return;
        }
        callback.onSelectionInfo(selectionInfo);
    }

    public void getSelectionInfo(final SelectionInfoCallback<ParentType, ChildrenType> callback, boolean selectionOnly, final boolean useTableModelData) {
        boolean invokeLater;
        boolean bl = invokeLater = SwingUtilities.isEventDispatchThread() && !(callback instanceof LegacyBlockingSelectionInfoCallback);
        if (selectionOnly) {
            new EDTHelper<Void>(){

                public Void edtRun() {
                    if (callback.isCancelled()) {
                        return null;
                    }
                    long currentSelectionVersion = PackageControllerTable.this.selectionVersion.get();
                    if (useTableModelData) {
                        SelectionInfoCache lselectionOnly_TableData = PackageControllerTable.this.selectionOnly_TableData;
                        long dataVersion = PackageControllerTable.this.tableModel.getTableDataVersion();
                        AbstractNode contextMenuTrigger = PackageControllerTable.this.getContextMenuTrigger();
                        if (lselectionOnly_TableData != null && lselectionOnly_TableData.getSelectionVersion() == currentSelectionVersion && lselectionOnly_TableData.getDataVersion() == dataVersion) {
                            SelectionInfo ret = lselectionOnly_TableData.getSelectionInfo();
                            if (ret.getRawContext() == contextMenuTrigger) {
                                PackageControllerTable.this.onSelectionInfoCallback(callback, ret);
                                return null;
                            }
                            if (ret instanceof PackageControllerTableModelSelectionOnlySelectionInfo) {
                                ret = new PackageControllerTableModelSelectionOnlySelectionInfo(contextMenuTrigger, (PackageControllerTableModelSelectionOnlySelectionInfo)ret);
                                PackageControllerTable.this.selectionOnly_TableData = new SelectionInfoCache(currentSelectionVersion, dataVersion, ret);
                                PackageControllerTable.this.onSelectionInfoCallback(callback, ret);
                                return null;
                            }
                        }
                        SelectionInfo selectionInfo = PackageControllerTable.this.getSelectionModel().isSelectionEmpty() ? new EmptySelectionInfo(PackageControllerTable.this.getController()) : new PackageControllerTableModelSelectionOnlySelectionInfo(contextMenuTrigger, PackageControllerTable.this.getModel());
                        PackageControllerTable.this.selectionOnly_TableData = lselectionOnly_TableData = new SelectionInfoCache(currentSelectionVersion, dataVersion, selectionInfo);
                        PackageControllerTable.this.onSelectionInfoCallback(callback, selectionInfo);
                    } else {
                        SelectionInfoCache lselectionOnly_ControllerData = PackageControllerTable.this.selectionOnly_ControllerData;
                        if (lselectionOnly_ControllerData != null && lselectionOnly_ControllerData.getSelectionVersion() == currentSelectionVersion) {
                            PackageControllerTable.this.onSelectionInfoCallback(callback, PackageControllerTable.this.selectionOnly_ControllerData.getSelectionInfo());
                        } else if (PackageControllerTable.this.getSelectionModel().isSelectionEmpty()) {
                            EmptySelectionInfo selectionInfo = new EmptySelectionInfo(PackageControllerTable.this.getController());
                            PackageControllerTable.this.selectionOnly_ControllerData = lselectionOnly_ControllerData = new SelectionInfoCache(currentSelectionVersion, -1L, selectionInfo);
                            PackageControllerTable.this.onSelectionInfoCallback(callback, selectionInfo);
                        } else {
                            throw new WTFException("You really want an unfiltered filtered view?!");
                        }
                    }
                    return null;
                }
            }.start(invokeLater);
        } else if (useTableModelData) {
            new EDTHelper<Void>(){

                public Void edtRun() {
                    if (callback.isCancelled()) {
                        return null;
                    }
                    long dataVersion = PackageControllerTable.this.tableModel.getTableDataVersion();
                    SelectionInfoCache lall_TableData = PackageControllerTable.this.all_TableData;
                    if (lall_TableData != null && lall_TableData.getDataVersion() == dataVersion) {
                        PackageControllerTable.this.onSelectionInfoCallback(callback, lall_TableData.getSelectionInfo());
                    } else {
                        PackageControllerTableModelSelectionInfo selectionInfo = new PackageControllerTableModelSelectionInfo(null, PackageControllerTable.this.getModel());
                        PackageControllerTable.this.all_TableData = lall_TableData = new SelectionInfoCache(-1L, dataVersion, selectionInfo);
                        PackageControllerTable.this.onSelectionInfoCallback(callback, selectionInfo);
                    }
                    return null;
                }
            }.start(invokeLater);
        } else {
            this.getModel().getController().getQueue().add(new PackageControllerQueue.ReadOnlyQueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

                protected Void run() throws RuntimeException {
                    if (callback.isCancelled()) {
                        return null;
                    }
                    SelectionInfo selectionInfo = PackageControllerTable.this.getModel().getController().getSelectionInfo();
                    PackageControllerTable.this.onSelectionInfoCallback(callback, selectionInfo);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SelectionInfo<ParentType, ChildrenType> getSelectionInfo(boolean selectionOnly, boolean useTableModelData) {
        Object selection;
        final AtomicReference ret = new AtomicReference();
        ret.set(ret);
        LegacyBlockingSelectionInfoCallback callback = new LegacyBlockingSelectionInfoCallback<ParentType, ChildrenType>(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSelectionInfo(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                AtomicReference atomicReference = ret;
                synchronized (atomicReference) {
                    ret.set(selectionInfo);
                    ret.notifyAll();
                }
            }
        };
        this.getSelectionInfo(callback, selectionOnly, useTableModelData);
        while (true) {
            selection = null;
            Object v = ret.get();
            selection = v;
            if (v != ret) break;
            try {
                AtomicReference atomicReference = ret;
                synchronized (atomicReference) {
                    Object v2 = ret.get();
                    selection = v2;
                    if (v2 == ret) {
                        ret.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                LogController.CL().log((Throwable)e);
                return null;
            }
        }
        return selection;
    }

    public PackageControllerTableModel<ParentType, ChildrenType> getModel() {
        return (PackageControllerTableModel)super.getModel();
    }

    protected void doSortOnColumn(ExtColumn<AbstractNode> column, MouseEvent e) {
        if (CrossSystem.isMac()) {
            if (e.isMetaDown()) {
                new SortPackagesDownloadOrdnerOnColumn(column).actionPerformed(new ActionEvent(e.getSource(), e.getID(), "sort", System.currentTimeMillis(), e.getModifiers()));
                return;
            }
        } else if (e.isControlDown()) {
            new SortPackagesDownloadOrdnerOnColumn(column).actionPerformed(new ActionEvent(e.getSource(), e.getID(), "sort", System.currentTimeMillis(), e.getModifiers()));
            return;
        }
        column.doSort();
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof PackageControllerTableModel)) {
            throw new WTFException("The Model is not instanceof PackageControllerTableModel!");
        }
        super.setModel(dataModel);
    }

    public PackageController<ParentType, ChildrenType> getController() {
        return this.tableModel.getController();
    }

    protected void onSelectionChanged() {
        super.onSelectionChanged();
        if (!this.tableModel.hasSelectedObjects() || !this.updateMoveButtonEnabledStatus()) {
            this.moveDownAction.setEnabled(false);
            this.moveBottomAction.setEnabled(false);
            this.moveTopAction.setEnabled(false);
            this.moveUpAction.setEnabled(false);
        } else {
            this.selectionDelayedUpdate.run();
        }
    }

    protected void updateMoveActions() {
        this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

            @Override
            public void onSelectionInfo(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                final boolean moveUpPossible = PackageControllerTable.this.moveUpPossible(selectionInfo);
                final boolean moveDownPossible = PackageControllerTable.this.moveDownPossible(selectionInfo);
                new EDTRunner(){

                    protected void runInEDT() {
                        PackageControllerTable.this.moveTopAction.setEnabled(moveUpPossible);
                        PackageControllerTable.this.moveUpAction.setEnabled(moveUpPossible);
                        PackageControllerTable.this.moveDownAction.setEnabled(moveDownPossible);
                        PackageControllerTable.this.moveBottomAction.setEnabled(moveDownPossible);
                    }
                };
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }, SelectionType.SELECTED);
    }

    public void onShortcutSelectAll() {
        if (!CFG_GUI.CFG.isTwoStepCtrlASelectionEnabled()) {
            this.superOnShortcutSelectAll();
        } else {
            this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

                @Override
                public void onSelectionInfo(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                    boolean selectall;
                    ArrayList<Object> toSelect = new ArrayList<Object>();
                    List tableData = PackageControllerTable.this.tableModel.getTableData();
                    for (SelectionInfo.PackageView packageView : selectionInfo.getPackageViews()) {
                        List visibleChildren = null;
                        if (packageView.isExpanded()) {
                            visibleChildren = ((PackageControllerTableModelSelectionOnlySelectionInfo.SelectionOnlyPackageView)packageView).getVisibleChildren();
                        }
                        if (!((PackageControllerTableModelData)tableData).isHideSingleChildPackages() || visibleChildren != null && (visibleChildren.size() > 1 || visibleChildren.size() == 1 && !((PackageControllerTableModelData)tableData).isHiddenPackageSingleChildIndex(((PackageControllerTableModelData)tableData).getRowforObject((AbstractNode)packageView.getPackage(), PackageControllerTable.this.tableModel.getController())))) {
                            toSelect.add(packageView.getPackage());
                        }
                        if (visibleChildren == null) continue;
                        toSelect.addAll(visibleChildren);
                    }
                    boolean bl = selectall = selectionInfo.getRawSelection().size() == toSelect.size();
                    if (selectall) {
                        PackageControllerTable.this.superOnShortcutSelectAll();
                    } else {
                        PackageControllerTable.this.getModel().setSelectedObjects(toSelect);
                    }
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }
            }, SelectionType.SELECTED);
        }
    }

    protected void superOnShortcutSelectAll() {
        super.onShortcutSelectAll();
    }

    protected boolean updateMoveButtonEnabledStatus() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean moveUpPossible(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
        if (selectionInfo.isEmpty()) {
            return false;
        }
        List tableData = this.tableModel.getTableData();
        if (selectionInfo.getPackageViews().size() > 1) {
            int index = 0;
            boolean ret = false;
            for (SelectionInfo.PackageView<ParentType, ChildrenType> packageView : selectionInfo.getPackageViews()) {
                if (packageView.getSelectedChildren().size() > 0 && packageView.isExpanded()) {
                    return false;
                }
                int pcIndex = ((PackageControllerTableModelData)tableData).indexOf(packageView.getPackage());
                if (pcIndex < 0) {
                    return false;
                }
                if (pcIndex == index++) continue;
                ret = true;
            }
            return ret;
        }
        if (selectionInfo.getPackageViews().size() == 1) {
            SelectionInfo.PackageView<ParentType, ChildrenType> packageView = selectionInfo.getPackageViews().get(0);
            List<ChildrenType> children = packageView.getSelectedChildren();
            if (!packageView.isExpanded() || children.size() == 0) {
                return ((PackageControllerTableModelData)tableData).indexOf(packageView.getPackage()) != 0;
            }
            ParentType pkg = packageView.getPackage();
            boolean readL = pkg.getModifyLock().readLock();
            try {
                List<Object> children2 = packageView instanceof PackageControllerTableModelSelectionOnlySelectionInfo.SelectionOnlyPackageView ? ((PackageControllerTableModelSelectionOnlySelectionInfo.SelectionOnlyPackageView)packageView).getVisibleChildren() : pkg.getChildren();
                int index = 0;
                for (AbstractPackageChildrenNode child : children) {
                    int cIndex = children2.indexOf(child);
                    if (cIndex < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    if (cIndex == index++) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean moveDownPossible(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
        if (selectionInfo.isEmpty()) {
            return false;
        }
        List tableData = this.tableModel.getTableData();
        if (selectionInfo.getPackageViews().size() > 1) {
            boolean ret = false;
            int index = ((PackageControllerTableModelData)tableData).getModelDataPackages().size() - 1;
            for (int i = selectionInfo.getPackageViews().size() - 1; i >= 0; --i) {
                SelectionInfo.PackageView<ParentType, ChildrenType> packageView = selectionInfo.getPackageViews().get(i);
                if (packageView.getSelectedChildren().size() > 0 && packageView.isExpanded()) {
                    return false;
                }
                int pcIndex = ((PackageControllerTableModelData)tableData).lastIndexOf(packageView.getPackage());
                if (pcIndex < 0) {
                    return false;
                }
                if (pcIndex == index--) continue;
                ret = true;
            }
            return ret;
        }
        if (selectionInfo.getPackageViews().size() == 1) {
            SelectionInfo.PackageView<ParentType, ChildrenType> packageView = selectionInfo.getPackageViews().get(0);
            List<ChildrenType> children = packageView.getSelectedChildren();
            if (!packageView.isExpanded() || children.size() == 0) {
                return ((PackageControllerTableModelData)tableData).lastIndexOf(packageView.getPackage()) != ((PackageControllerTableModelData)tableData).getModelDataPackages().size() - 1;
            }
            ParentType pkg = packageView.getPackage();
            boolean readL = pkg.getModifyLock().readLock();
            try {
                List<Object> children2 = packageView instanceof PackageControllerTableModelSelectionOnlySelectionInfo.SelectionOnlyPackageView ? ((PackageControllerTableModelSelectionOnlySelectionInfo.SelectionOnlyPackageView)packageView).getVisibleChildren() : pkg.getChildren();
                int index = children2.size() - 1;
                for (int i = children.size() - 1; i >= 0; --i) {
                    AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)children.get(i);
                    int cIndex = children2.lastIndexOf(child);
                    if (cIndex < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    if (cIndex == index--) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        }
        return false;
    }

    protected void initAppActions() {
        this.moveTopAction = new AppAction(){
            private static final long serialVersionUID = 1L;
            {
                this.setTooltipText(_GUI.T.BottomBar_BottomBar_totop_tooltip());
                this.setSmallIcon(new AbstractIcon("go-top", 20));
            }

            public void actionPerformed(ActionEvent e) {
                PackageControllerTable.this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

                    @Override
                    public void onSelectionInfo(final SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                        PackageControllerTable.this.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            protected Void run() throws RuntimeException {
                                boolean moveUpPossible = PackageControllerTable.this.moveUpPossible(selectionInfo);
                                if (moveUpPossible) {
                                    PackageController pc = PackageControllerTable.this.getController();
                                    ArrayList selectedPackages = new ArrayList();
                                    for (SelectionInfo.PackageView packageView : selectionInfo.getPackageViews()) {
                                        if (!packageView.isPackageSelected()) continue;
                                        selectedPackages.add(packageView.getPackage());
                                    }
                                    if (selectedPackages.size() > 0) {
                                        pc.move(selectedPackages, null);
                                    } else if (selectionInfo.getPackageViews().size() > 0) {
                                        SelectionInfo.PackageView packageView = selectionInfo.getPackageViews().get(0);
                                        pc.move(selectionInfo.getChildren(), packageView.getPackage(), null);
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                }, SelectionType.SELECTED);
            }
        };
        this.moveUpAction = new AppAction(){
            private static final long serialVersionUID = 1L;
            {
                this.setTooltipText(_GUI.T.BottomBar_BottomBar_moveup_tooltip());
                this.setSmallIcon(new AbstractIcon("go-up", 20));
            }

            public void actionPerformed(ActionEvent e) {
                PackageControllerTable.this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

                    @Override
                    public void onSelectionInfo(final SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                        PackageControllerTable.this.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Void run() throws RuntimeException {
                                boolean moveUpPossible = PackageControllerTable.this.moveUpPossible(selectionInfo);
                                if (moveUpPossible) {
                                    PackageController pc = PackageControllerTable.this.getController();
                                    ArrayList selectedPackages = new ArrayList();
                                    for (SelectionInfo.PackageView packageView : selectionInfo.getPackageViews()) {
                                        if (!packageView.isPackageSelected()) continue;
                                        selectedPackages.add(packageView.getPackage());
                                    }
                                    if (selectedPackages.size() > 0) {
                                        AbstractPackageNode after = null;
                                        boolean readL = pc.readLock();
                                        try {
                                            try {
                                                AbstractPackageNode pkg = (AbstractPackageNode)selectedPackages.get(0);
                                                int index = pc.indexOf(pkg) - 2;
                                                if (index >= 0) {
                                                    after = (AbstractPackageNode)pc.getPackages().get(index);
                                                }
                                            }
                                            catch (Throwable e) {
                                                LogController.CL().log(e);
                                            }
                                        }
                                        finally {
                                            pc.readUnlock(readL);
                                        }
                                        pc.move(selectedPackages, after);
                                    } else if (selectionInfo.getPackageViews().size() > 0) {
                                        SelectionInfo.PackageView packageView = selectionInfo.getPackageViews().get(0);
                                        AbstractPackageChildrenNode after = null;
                                        Object pkg = packageView.getPackage();
                                        boolean readL = pkg.getModifyLock().readLock();
                                        try {
                                            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)packageView.getChildren().get(0);
                                            int index = pkg.indexOf((AbstractPackageChildrenNode)child) - 2;
                                            if (index >= 0) {
                                                after = (AbstractPackageChildrenNode)pkg.getChildren().get(index);
                                            }
                                        }
                                        catch (Throwable e) {
                                            LogController.CL().log(e);
                                        }
                                        finally {
                                            pkg.getModifyLock().readUnlock(readL);
                                        }
                                        pc.move(selectionInfo.getChildren(), pkg, after);
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                }, SelectionType.SELECTED);
            }
        };
        this.moveDownAction = new AppAction(){
            private static final long serialVersionUID = 1L;
            {
                this.setTooltipText(_GUI.T.BottomBar_BottomBar_movedown_tooltip());
                this.setSmallIcon(new AbstractIcon("go-down", 20));
            }

            public void actionPerformed(ActionEvent e) {
                PackageControllerTable.this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

                    @Override
                    public void onSelectionInfo(final SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                        PackageControllerTable.this.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Void run() throws RuntimeException {
                                boolean moveDownPossible = PackageControllerTable.this.moveDownPossible(selectionInfo);
                                if (moveDownPossible) {
                                    PackageController pc = PackageControllerTable.this.getController();
                                    ArrayList selectedPackages = new ArrayList();
                                    for (SelectionInfo.PackageView packageView : selectionInfo.getPackageViews()) {
                                        if (!packageView.isPackageSelected()) continue;
                                        selectedPackages.add(packageView.getPackage());
                                    }
                                    if (selectedPackages.size() > 0) {
                                        AbstractPackageNode after = null;
                                        boolean readL = pc.readLock();
                                        try {
                                            try {
                                                AbstractPackageNode pkg = (AbstractPackageNode)selectedPackages.get(selectedPackages.size() - 1);
                                                int index = Math.min(pc.getPackages().size() - 1, pc.indexOf(pkg) + 1);
                                                after = (AbstractPackageNode)pc.getPackages().get(index);
                                            }
                                            catch (Throwable e) {
                                                LogController.CL().log(e);
                                            }
                                        }
                                        finally {
                                            pc.readUnlock(readL);
                                        }
                                        pc.move(selectedPackages, after);
                                    } else if (selectionInfo.getPackageViews().size() > 0) {
                                        SelectionInfo.PackageView packageView = selectionInfo.getPackageViews().get(0);
                                        AbstractPackageChildrenNode after = null;
                                        Object pkg = packageView.getPackage();
                                        boolean readL = pkg.getModifyLock().readLock();
                                        try {
                                            AbstractPackageChildrenNode child = (AbstractPackageChildrenNode)selectionInfo.getChildren().get(selectionInfo.getChildren().size() - 1);
                                            int index = Math.min(pkg.getChildren().size() - 1, pkg.indexOf((AbstractPackageChildrenNode)child) + 1);
                                            after = (AbstractPackageChildrenNode)pkg.getChildren().get(index);
                                        }
                                        catch (Throwable e) {
                                            LogController.CL().log(e);
                                        }
                                        finally {
                                            pkg.getModifyLock().readUnlock(readL);
                                        }
                                        pc.move(packageView.getChildren(), pkg, after);
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                }, SelectionType.SELECTED);
            }
        };
        this.moveBottomAction = new AppAction(){
            private static final long serialVersionUID = 1L;
            {
                this.setTooltipText(_GUI.T.BottomBar_BottomBar_tobottom_tooltip());
                this.setSmallIcon(new AbstractIcon("go-bottom", 20));
            }

            public void actionPerformed(ActionEvent e) {
                PackageControllerTable.this.getSelectionInfo(new SelectionInfoCallback<ParentType, ChildrenType>(){

                    @Override
                    public void onSelectionInfo(final SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                        PackageControllerTable.this.getController().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            protected Void run() throws RuntimeException {
                                if (PackageControllerTable.this.moveDownPossible(selectionInfo)) {
                                    PackageController pc = PackageControllerTable.this.getController();
                                    ArrayList selectedPackages = new ArrayList();
                                    for (SelectionInfo.PackageView packageView : selectionInfo.getPackageViews()) {
                                        if (!packageView.isPackageSelected()) continue;
                                        selectedPackages.add(packageView.getPackage());
                                    }
                                    if (selectedPackages.size() > 0) {
                                        AbstractPackageNode after = null;
                                        boolean readL = pc.readLock();
                                        try {
                                            try {
                                                after = (AbstractPackageNode)pc.getPackages().get(pc.getPackages().size() - 1);
                                            }
                                            catch (Throwable e) {
                                                LogController.CL().log(e);
                                            }
                                        }
                                        finally {
                                            pc.readUnlock(readL);
                                        }
                                        pc.move(selectedPackages, after);
                                    } else if (selectionInfo.getPackageViews().size() > 0) {
                                        SelectionInfo.PackageView packageView = selectionInfo.getPackageViews().get(0);
                                        AbstractPackageChildrenNode after = null;
                                        Object pkg = packageView.getPackage();
                                        boolean readL = pkg.getModifyLock().readLock();
                                        try {
                                            after = (AbstractPackageChildrenNode)pkg.getChildren().get(pkg.getChildren().size() - 1);
                                        }
                                        catch (Throwable e) {
                                            LogController.CL().log(e);
                                        }
                                        finally {
                                            pkg.getModifyLock().readUnlock(readL);
                                        }
                                        pc.move(packageView.getChildren(), pkg, after);
                                    }
                                }
                                return null;
                            }
                        });
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                }, SelectionType.SELECTED);
            }
        };
        this.moveDownAction.setEnabled(false);
        this.moveBottomAction.setEnabled(false);
        this.moveTopAction.setEnabled(false);
        this.moveUpAction.setEnabled(false);
    }

    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        AbstractNode element;
        if (!pressed) {
            return super.processKeyBinding(stroke, evt, condition, pressed);
        }
        if ((stroke.equals(KEY_STROKE_KP_LEFT) || stroke.equals(KEY_STROKE_LEFT)) && (element = (AbstractNode)this.getModel().getElementAt(this.getSelectedRow())) != null) {
            if (element instanceof AbstractPackageNode) {
                this.tableModel.setFilePackageExpand(false, (AbstractPackageNode)element);
                return true;
            }
            for (int i = this.getSelectedRow() - 1; i >= 0; --i) {
                if (!(this.getModel().getElementAt(i) instanceof AbstractPackageNode)) continue;
                this.changeSelection(i, 0, false, false);
                return true;
            }
        }
        if ((stroke.equals(KEY_STROKE_KP_RIGHT) || stroke.equals(KEY_STROKE_RIGHT)) && (element = (AbstractNode)this.getModel().getElementAt(this.getSelectedRow())) != null && element instanceof AbstractPackageNode) {
            this.tableModel.setFilePackageExpand(true, (AbstractPackageNode)element);
            return true;
        }
        if (stroke.equals(KEY_STROKE_ALT_UP)) {
            this.moveUpAction.actionPerformed(null);
            return true;
        }
        if (stroke.equals(KEY_STROKE_ALT_DOWN)) {
            this.moveDownAction.actionPerformed(null);
            return true;
        }
        if (stroke.equals(KEY_STROKE_ALT_HOME)) {
            this.moveTopAction.actionPerformed(null);
            return true;
        }
        if (stroke.equals(KEY_STROKE_ALT_END)) {
            this.moveBottomAction.actionPerformed(null);
            return true;
        }
        return super.processKeyBinding(stroke, evt, condition, pressed);
    }

    public AppAction getMoveDownAction() {
        return this.moveDownAction;
    }

    public AppAction getMoveTopAction() {
        return this.moveTopAction;
    }

    public AppAction getMoveToBottomAction() {
        return this.moveBottomAction;
    }

    public AppAction getMoveUpAction() {
        return this.moveUpAction;
    }

    public abstract ExtColumn<AbstractNode> getExpandCollapseColumn();

    protected boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        if (obj instanceof AbstractPackageNode && this.isExpandToggleEvent(e)) {
            if (e.isControlDown() && !e.isShiftDown()) {
                this.tableModel.toggleFilePackageExpand((AbstractPackageNode)obj, PackageControllerTableModel.TOGGLEMODE.BOTTOM);
            } else if (e.isControlDown() && e.isShiftDown()) {
                this.tableModel.toggleFilePackageExpand((AbstractPackageNode)obj, PackageControllerTableModel.TOGGLEMODE.TOP);
            } else {
                this.tableModel.toggleFilePackageExpand((AbstractPackageNode)obj, PackageControllerTableModel.TOGGLEMODE.CURRENT);
            }
            return true;
        }
        return super.onSingleClick(e, (Object)obj);
    }

    public boolean isOriginalOrder() {
        return this.getModel().getSortColumn() == null;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        boolean filteredView = this.filterNotifyColor != null && this.tableModel.isFilteredView();
        ExtColumn sortColumn = this.getModel().getSortColumn();
        int filteredColumn = -1;
        if (this.sortNotifyColor != null && sortColumn != null) {
            filteredColumn = sortColumn.getIndex();
        }
        if (!filteredView && filteredColumn < 0) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Composite comp = g2.getComposite();
        Rectangle visibleRect = this.getVisibleRect();
        g2.setComposite(this.alpha);
        if (filteredView) {
            g2.setColor(this.filterNotifyColor);
            g2.fillRect(visibleRect.x, visibleRect.y, visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height);
        }
        if (filteredColumn >= 0 && this.tableModel.isTristateSorterEnabled()) {
            Rectangle first = this.getCellRect(0, filteredColumn, true);
            int w = this.getModel().getSortColumn().getWidth() - Math.max(0, visibleRect.x - first.x);
            if (w > 0) {
                g2.setColor(this.sortNotifyColor);
                g2.fillRect(Math.max(first.x, visibleRect.x), visibleRect.y, w, visibleRect.height);
            }
        }
        g2.setComposite(comp);
    }

    private static interface LegacyBlockingSelectionInfoCallback<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
    extends SelectionInfoCallback<PackageType, ChildrenType> {
    }

    public static interface QueueSelectionInfoCallback<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
    extends SelectionInfoCallback<PackageType, ChildrenType> {
        public Queue getQueue();
    }

    public static interface EDTSelectionInfoCallback<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
    extends SelectionInfoCallback<PackageType, ChildrenType> {
    }

    public static interface SelectionInfoCallback<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>> {
        public void onSelectionInfo(SelectionInfo<PackageType, ChildrenType> var1);

        public boolean isCancelled();
    }

    public static enum SelectionType {
        SELECTED,
        UNSELECTED,
        ALL,
        BACKEND,
        NONE;

    }

    protected class SelectionInfoCache {
        private final SelectionInfo<ParentType, ChildrenType> selectionInfo;
        private final long selectionVersion;
        private final long dataVersion;

        public final long getSelectionVersion() {
            return this.selectionVersion;
        }

        public final long getDataVersion() {
            return this.dataVersion;
        }

        public final SelectionInfo<ParentType, ChildrenType> getSelectionInfo() {
            return this.selectionInfo;
        }

        protected SelectionInfoCache(long selectionVersion, long dataVersion, SelectionInfo<ParentType, ChildrenType> selectionInfo) {
            this.selectionVersion = selectionVersion;
            this.dataVersion = dataVersion;
            this.selectionInfo = selectionInfo;
        }
    }
}

