/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.ChildrenView;
import jd.controlling.packagecontroller.PackageController;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelCustomizer;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.gui.views.linkgrabber.quickfilter.FilterTable;

public class PackageControllerTableModelData<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends ArrayList<AbstractNode> {
    private static final AtomicLong VERSION = new AtomicLong(-1L);
    private List<PackageControllerTableModelFilter<PackageType, ChildrenType>> packageFilters = null;
    private List<PackageControllerTableModelFilter<PackageType, ChildrenType>> childrenFilters = null;
    private List<PackageControllerTableModelCustomizer> tableModelCustomizer = null;
    private final long version = VERSION.incrementAndGet();
    private boolean filtered = false;
    private final List<PackageControllerTableModelDataPackage<PackageType, ChildrenType>> modelDataPackages = new ArrayList<PackageControllerTableModelDataPackage<PackageType, ChildrenType>>();
    private final List<ChildrenType> filteredChildren = new ArrayList<ChildrenType>();
    private final List<ChildrenType> hiddenChildren = new ArrayList<ChildrenType>();
    private final BitSet hiddenPackagesSingleChildIndices = new BitSet();
    private final List<PackageControllerTableModelDataPackage<PackageType, ChildrenType>> invisibleModelDataPackages = new ArrayList<PackageControllerTableModelDataPackage<PackageType, ChildrenType>>();
    private final List<ChildrenType> invisibleChildren = new ArrayList<ChildrenType>();

    public List<ChildrenType> getInvisibleChildren() {
        return this.invisibleChildren;
    }

    protected List<ChildrenType> getHiddenChildren() {
        return this.hiddenChildren;
    }

    public List<ChildrenType> getFilteredChildren() {
        return this.filteredChildren;
    }

    protected int getRowforObject(AbstractNode node, PackageController<PackageType, ChildrenType> controller) {
        if (node instanceof AbstractPackageNode) {
            AbstractPackageNode pkg = (AbstractPackageNode)node;
            if (pkg.getControlledBy() == controller) {
                for (PackageControllerTableModelDataPackage<PackageType, ChildrenType> dataPackage : this.getModelDataPackages()) {
                    if (dataPackage.getPackage() != pkg) continue;
                    return dataPackage.getPackageIndex();
                }
            }
            return -1;
        }
        if (node instanceof AbstractPackageChildrenNode) {
            AbstractPackageNode pkg;
            Object parent = ((AbstractPackageChildrenNode)node).getParentNode();
            if (parent != null && (pkg = (AbstractPackageNode)parent).getControlledBy() == controller) {
                for (PackageControllerTableModelDataPackage<PackageType, ChildrenType> dataPackage : this.getModelDataPackages()) {
                    if (dataPackage.getPackage() != pkg) continue;
                    int packageIndex = dataPackage.getPackageIndex();
                    List<ChildrenType> children = dataPackage.getVisibleChildren();
                    int childIndex = children.indexOf(node);
                    if (childIndex >= 0) {
                        if (this.isHiddenPackageSingleChildIndex(packageIndex)) {
                            return packageIndex;
                        }
                        return packageIndex + childIndex + 1;
                    }
                    return -1;
                }
            }
            return -1;
        }
        return -1;
    }

    protected int addHiddenPackageSingleChild(ChildrenType childNode) {
        int index = this.size();
        this.hiddenPackagesSingleChildIndices.set(index);
        super.add(childNode);
        return index;
    }

    protected int addPackageNode(PackageType pkgNode) {
        int index = this.size();
        super.add(pkgNode);
        return index;
    }

    public boolean isHiddenPackageSingleChildIndex(int index) {
        return this.hiddenPackagesSingleChildIndices.get(index);
    }

    protected void add(PackageControllerTableModelDataPackage<PackageType, ChildrenType> tableModelDataPackage) {
        if (tableModelDataPackage.getPackageIndex() == -1) {
            this.invisibleModelDataPackages.add(tableModelDataPackage);
        } else {
            ChildrenView view = ((AbstractPackageNode)tableModelDataPackage.getPackage()).getView();
            if (view != null) {
                view.setTableModelDataPackage(tableModelDataPackage);
            }
            this.modelDataPackages.add(tableModelDataPackage);
        }
    }

    public List<PackageControllerTableModelDataPackage<PackageType, ChildrenType>> getInvisibleModelDataPackages() {
        return this.invisibleModelDataPackages;
    }

    public List<PackageControllerTableModelDataPackage<PackageType, ChildrenType>> getModelDataPackages() {
        return this.modelDataPackages;
    }

    @Override
    public int indexOf(PackageType pkgNode) {
        int index = 0;
        for (PackageControllerTableModelDataPackage<PackageType, ChildrenType> modelDataPackage : this.getModelDataPackages()) {
            if (modelDataPackage.getPackage() == pkgNode) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(PackageType pkgNode) {
        for (int index = this.getModelDataPackages().size() - 1; index >= 0; --index) {
            PackageControllerTableModelDataPackage<PackageType, ChildrenType> modelDataPackage = this.getModelDataPackages().get(index);
            if (modelDataPackage.getPackage() != pkgNode) continue;
            return index;
        }
        return -1;
    }

    public long getVersion() {
        return this.version;
    }

    public Iterator<ChildrenType> getVisibleChildrenIterator() {
        final Iterator<PackageControllerTableModelDataPackage<PackageType, ChildrenType>> it = this.getModelDataPackages().iterator();
        return new Iterator<ChildrenType>(){
            ChildrenType ret = null;
            Iterator<ChildrenType> it2 = null;

            @Override
            public boolean hasNext() {
                if (this.ret != null) {
                    return true;
                }
                if (this.it2 != null) {
                    if (this.it2.hasNext()) {
                        this.ret = (AbstractPackageChildrenNode)this.it2.next();
                        return true;
                    }
                    this.it2 = null;
                }
                while (it.hasNext()) {
                    PackageControllerTableModelDataPackage next = (PackageControllerTableModelDataPackage)it.next();
                    if (next.getVisibleChildren() == null || next.getVisibleChildren().size() <= 0) continue;
                    this.it2 = next.getVisibleChildren().iterator();
                    this.ret = (AbstractPackageChildrenNode)this.it2.next();
                    return true;
                }
                return false;
            }

            @Override
            public ChildrenType next() {
                if (this.hasNext()) {
                    Object ret = this.ret;
                    this.ret = null;
                    return ret;
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    public List<PackageControllerTableModelCustomizer> getTableModelCustomizer() {
        return this.tableModelCustomizer;
    }

    public void setTableModelCustomizer(List<PackageControllerTableModelCustomizer> tableModelCustomizer) {
        if (tableModelCustomizer == null || tableModelCustomizer.size() == 0) {
            tableModelCustomizer = null;
        }
        this.tableModelCustomizer = tableModelCustomizer;
    }

    public List<PackageControllerTableModelFilter<PackageType, ChildrenType>> getPackageFilters() {
        return this.packageFilters;
    }

    protected void setPackageFilters(List<PackageControllerTableModelFilter<PackageType, ChildrenType>> packageFilters) {
        if (packageFilters != null && packageFilters.size() == 0) {
            packageFilters = null;
        }
        this.packageFilters = packageFilters;
        this.updateFilteredState();
    }

    public List<PackageControllerTableModelFilter<PackageType, ChildrenType>> getChildrenFilters() {
        return this.childrenFilters;
    }

    protected void setChildrenFilters(List<PackageControllerTableModelFilter<PackageType, ChildrenType>> childrenFilters) {
        if (childrenFilters != null && childrenFilters.size() == 0) {
            childrenFilters = null;
        }
        this.childrenFilters = childrenFilters;
        this.updateFilteredState();
    }

    private void updateFilteredState() {
        List<PackageControllerTableModelFilter<PackageType, ChildrenType>> lpackageFilters;
        List<PackageControllerTableModelFilter<PackageType, ChildrenType>> lchildrenFilters = this.childrenFilters;
        if (lchildrenFilters != null) {
            for (PackageControllerTableModelFilter<PackageType, ChildrenType> filter : lchildrenFilters) {
                if (filter instanceof FilterTable) continue;
                this.filtered = true;
                return;
            }
        }
        if ((lpackageFilters = this.packageFilters) != null) {
            for (PackageControllerTableModelFilter<PackageType, ChildrenType> filter : lpackageFilters) {
                if (filter instanceof FilterTable) continue;
                this.filtered = true;
                return;
            }
        }
        this.filtered = false;
    }

    public PackageControllerTableModelData(Collection<? extends AbstractNode> c) {
        super(c);
    }

    public PackageControllerTableModelData() {
    }

    public PackageControllerTableModelData(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isHideSingleChildPackages() {
        return !this.hiddenPackagesSingleChildIndices.isEmpty();
    }

    public static interface PackageControllerTableModelDataPackage<PackageType, ChildrenType> {
        public PackageType getPackage();

        public boolean isExpanded();

        public List<ChildrenType> getVisibleChildren();

        public int getVisibleChildrenSize();

        public List<ChildrenType> getInvisibleChildren();

        public int getInvisibleChildrenSize();

        public int getPackageIndex();
    }
}

