/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthPainter;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.filter.LinkgrabberFilterRuleWrapper;
import org.jdownloader.controlling.filter.RuleWrapper;
import org.jdownloader.gui.views.components.SearchCatInterface;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.updatev2.gui.LAFOptions;

public class SearchField<SearchCat extends SearchCatInterface, PackageType extends AbstractPackageNode<ChildType, PackageType>, ChildType extends AbstractPackageChildrenNode<PackageType>>
extends ExtTextField
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -8079363840549073686L;
    private static final int SIZE = 20;
    private Image img;
    private DelayedRunnable delayedFilter;
    private PackageControllerTable<PackageType, ChildType> table2Filter;
    private volatile JLabel label;
    private int labelWidth;
    private Color bgColor;
    private volatile SearchCat[] searchCategories;
    private Image popIcon;
    private int iconGap = 38;
    private Border orgBorder;
    private Image close;
    private int closeXPos = -1;
    private boolean mouseoverClose = false;
    private volatile boolean closeEnabled = false;
    private NullsafeAtomicReference<PackageControllerTableModelFilter<PackageType, ChildType>> appliedFilter = new NullsafeAtomicReference(null);
    private AppAction focusAction;
    private JButton button;
    private boolean synthButtonUIAccessable = Application.getJavaVersion() >= Application.JAVA17;
    private Method synthLookAndFeelUpdateMethod = null;
    private static final String REGEX_FILTER = "regex:";
    protected final AtomicReference<SearchCat> selectedCategory = new AtomicReference<Object>(null);

    public boolean isEmpty() {
        return this.appliedFilter.get() == null;
    }

    public SearchField(final PackageControllerTable<PackageType, ChildType> table2Filter, SearchCat defCategory) {
        this.button = new JButton();
        this.table2Filter = table2Filter;
        this.img = NewTheme.I().getImage("search", 20);
        this.close = NewTheme.I().getImage("close", -1);
        LAFOptions lafo = LAFOptions.getInstance();
        this.bgColor = lafo.getColorForPanelHeaderBackground();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.popIcon = NewTheme.I().getImage("popUpSmall", -1);
        this.delayedFilter = new DelayedRunnable(150L, 2000L){

            public String getID() {
                return "SearchField" + table2Filter.getModel().getModelID();
            }

            public void delayedrun() {
                SearchField.this.updateFilter();
            }
        };
        this.orgBorder = this.getBorder();
        this.setBorder(BorderFactory.createCompoundBorder(this.orgBorder, BorderFactory.createEmptyBorder(0, 28, 0, 18)));
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.focusAction = new AppAction(){

            public void actionPerformed(ActionEvent e) {
                SearchField.this.requestFocus();
                SearchField.this.selectAll();
            }
        };
    }

    public AppAction getFocusAction() {
        return this.focusAction;
    }

    public Image getPopIcon() {
        return this.popIcon;
    }

    public void setPopIcon(Image popIcon) {
        this.popIcon = popIcon;
    }

    public void onChanged() {
        String text = this.getText();
        this.closeEnabled = text != null && text.length() > 0;
        this.delayedFilter.run();
    }

    protected final boolean isSynthButtonUIAvailable(ButtonUI buttonUI) {
        if (this.synthButtonUIAccessable) {
            return buttonUI instanceof SynthButtonUI;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Composite comp = g2.getComposite();
        super.paintComponent(g);
        if (this.label != null) {
            if (this.isSynthButtonUIAvailable(this.button.getUI())) {
                try {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                    this.button.setOpaque(false);
                    this.button.setBackground(null);
                    this.button.setSize(this.labelWidth + 5 + this.iconGap + 8 - 1, this.getHeight());
                    SynthContext context = ((SynthButtonUI)this.button.getUI()).getContext(this.button);
                    if (this.synthLookAndFeelUpdateMethod == null) {
                        this.synthLookAndFeelUpdateMethod = SynthLookAndFeel.class.getDeclaredMethod("update", SynthContext.class, Graphics.class);
                        this.synthLookAndFeelUpdateMethod.setAccessible(true);
                    }
                    this.synthLookAndFeelUpdateMethod.invoke(null, context, g2);
                    SynthPainter painter = context.getStyle().getPainter(context);
                    g2.setClip(0, 0, this.labelWidth + 5 + this.iconGap + 8 + 1, this.getHeight());
                    painter.paintButtonBackground(context, g2, 0, 0, this.labelWidth + 5 + this.iconGap + 8 - 1 + 4, this.getHeight());
                    g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                    g2.setClip(null);
                    g2.setColor(this.getBackground().darker().darker());
                    g2.drawLine(this.labelWidth + 5 + this.iconGap + 8, 1, this.labelWidth + this.iconGap + 5 + 8, this.getHeight() - 2);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.synthButtonUIAccessable = false;
                }
                finally {
                    g2.setComposite(comp);
                }
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g2.setColor(this.bgColor);
                g2.fillRect(1, 1, this.labelWidth + 5 + this.iconGap + 8 - 1, this.getHeight() - 1);
                g2.setColor(this.getBackground().darker());
                g2.drawLine(this.labelWidth + 5 + this.iconGap + 8, 1, this.labelWidth + this.iconGap + 5 + 8, this.getHeight() - 1);
                g2.setComposite(comp);
            }
            SearchCat cat = this.getSelectedCategory();
            if (cat != null) {
                cat.getIcon().paintIcon((Component)((Object)this), g2, this.iconGap - 24, 3);
            }
            g2.translate(this.iconGap + 1, 0);
            this.label.getUI().paint(g2, this.label);
            g2.drawImage(this.popIcon, this.labelWidth + 3, (this.getHeight() - this.popIcon.getHeight(null)) / 2, null);
            g2.translate(-this.iconGap - 1, 0);
        } else {
            if (this.isSynthButtonUIAvailable(this.button.getUI())) {
                try {
                    g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
                    this.button.setOpaque(false);
                    this.button.setBackground(null);
                    this.button.setSize(this.labelWidth + 5 + this.iconGap + 8 - 1, this.getHeight());
                    SynthContext context = ((SynthButtonUI)this.button.getUI()).getContext(this.button);
                    if (this.synthLookAndFeelUpdateMethod == null) {
                        this.synthLookAndFeelUpdateMethod = SynthLookAndFeel.class.getDeclaredMethod("update", SynthContext.class, Graphics.class);
                        this.synthLookAndFeelUpdateMethod.setAccessible(true);
                    }
                    this.synthLookAndFeelUpdateMethod.invoke(null, context, g2);
                    SynthPainter painter = context.getStyle().getPainter(context);
                    g2.setClip(0, 0, 26, this.getHeight());
                    painter.paintButtonBackground(context, g2, 0, 0, 29, this.getHeight());
                    g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
                    g2.setClip(null);
                    g2.setColor(this.getBackground().darker().darker());
                    g2.drawLine(26, 1, 26, this.getHeight() - 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.synthButtonUIAccessable = false;
                }
                finally {
                    g2.setComposite(comp);
                }
            } else {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g2.setColor(this.bgColor);
                g2.fillRect(0, 0, 26, this.getHeight());
                g2.setColor(this.getBackground().darker());
                g2.drawLine(26, 1, 26, this.getHeight() - 1);
                g2.setComposite(comp);
            }
            g2.drawImage(this.img, 3, 3, 23, 23, 0, 0, 20, 20, null);
        }
        if (this.closeEnabled) {
            this.closeXPos = this.getWidth() - this.close.getWidth(null) - (this.getHeight() - this.close.getHeight(null)) / 2;
            g2.drawImage(this.close, this.closeXPos, (this.getHeight() - this.close.getHeight(null)) / 2, this.close.getWidth(null), this.close.getHeight(null), null);
        }
    }

    protected final boolean isMatching(List<Pattern> pattern, String string) {
        if (string != null) {
            for (Pattern filterPattern : pattern) {
                if (!filterPattern.matcher(string).find()) continue;
                return true;
            }
        }
        return false;
    }

    private void updateFilter() {
        PackageControllerTableModelFilter oldFilter;
        PackageControllerTableModelFilter<PackageType, ChildType> newFilter;
        block9: {
            String filterRegex = this.getText();
            boolean enabled = filterRegex != null && filterRegex.length() > 0;
            newFilter = null;
            if (enabled) {
                ArrayList<Pattern> list = new ArrayList<Pattern>();
                try {
                    if (((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isFilterRegex() || filterRegex.startsWith(REGEX_FILTER)) {
                        if (filterRegex.startsWith(REGEX_FILTER)) {
                            filterRegex = filterRegex.substring(REGEX_FILTER.length());
                        }
                        list.add(LinkgrabberFilterRuleWrapper.createPattern(filterRegex, true, null));
                    } else {
                        String[] filters;
                        for (String filter : filters = filterRegex.split("\\|")) {
                            list.add(LinkgrabberFilterRuleWrapper.createPattern(filter, false, RuleWrapper.AUTO_PATTERN_MODE.WILDCARD));
                        }
                    }
                    newFilter = this.getFilter(list, this.getSelectedCategory());
                }
                catch (Throwable e) {
                    if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) break block9;
                    e.printStackTrace();
                }
            }
        }
        if ((oldFilter = (PackageControllerTableModelFilter)this.appliedFilter.getAndSet(newFilter)) != null) {
            this.table2Filter.getModel().removeFilter(oldFilter);
        }
        if (newFilter != null) {
            this.table2Filter.getModel().addFilter(newFilter);
        }
        this.table2Filter.getModel().recreateModel(true);
    }

    protected PackageControllerTableModelFilter<PackageType, ChildType> getFilter(List<Pattern> pattern, SearchCat searchCat) {
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateCursor(e);
    }

    private void updateCursor(MouseEvent e) {
        if (!this.hasFocus()) {
            return;
        }
        if (this.label != null && e.getX() < this.labelWidth + 5 + this.iconGap + 8) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setCaretColor(this.getBackground());
            this.focusLost(null);
            this.mouseoverClose = false;
        } else if (this.closeXPos > 0 && e.getX() > this.closeXPos) {
            this.mouseoverClose = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setCaretColor(this.getBackground());
            this.focusLost(null);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(2));
            this.setCaretColor(null);
            this.focusGained(null);
            this.mouseoverClose = false;
        }
    }

    public void focusGained(FocusEvent arg0) {
        if (arg0 != null && arg0.getOppositeComponent() instanceof JRootPane) {
            return;
        }
        super.focusGained(arg0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.mouseoverClose && this.closeEnabled) {
            this.onResetPerformed();
        } else if (this.label != null && e.getX() < this.labelWidth + 5 + this.iconGap + 8) {
            this.onCategoryPopup();
        }
    }

    private void onResetPerformed() {
        this.setText(null);
        this.onChanged();
    }

    private void onCategoryPopup() {
        JPopupMenu popup = new JPopupMenu();
        SearchCat selectedCat = this.getSelectedCategory();
        for (SearchCat sc : this.searchCategories) {
            popup.add((Action)((Object)new AppAction((SearchCatInterface)sc, (SearchCatInterface)selectedCat){
                private final SearchCat category;
                final /* synthetic */ SearchCatInterface val$sc;
                final /* synthetic */ SearchCatInterface val$selectedCat;
                {
                    this.val$sc = searchCatInterface;
                    this.val$selectedCat = searchCatInterface2;
                    this.category = this.val$sc;
                    this.setName(this.val$sc.getLabel());
                    this.setSmallIcon(this.val$sc.getIcon());
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.category != this.val$selectedCat) {
                        SearchField.this.setSelectedCategory(this.category);
                        SearchField.this.focusLost(null);
                    }
                }
            }));
        }
        Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
        Dimension pref = popup.getPreferredSize();
        popup.setPreferredSize(new Dimension(this.labelWidth + 5 + this.iconGap + 8 + insets.left + insets.left + insets.right, (int)pref.getHeight()));
        popup.show((Component)((Object)this), -insets.left, -popup.getPreferredSize().height + insets.bottom);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.updateCursor(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseoverClose = false;
    }

    public SearchCat getSelectedCategory() {
        return (SearchCat)((SearchCatInterface)this.selectedCategory.get());
    }

    public void setSelectedCategory(SearchCat selectedCategory) {
        SearchCatInterface old;
        if (selectedCategory == null) {
            LoggerFactory.getDefaultLogger().log((Throwable)new NullPointerException("selectedCategory null"));
        }
        if ((old = (SearchCatInterface)this.selectedCategory.getAndSet(selectedCategory)) != selectedCategory) {
            this.onChanged();
        }
        if (this.label != null) {
            this.label.setText(selectedCategory.getLabel());
            this.setHelpText(selectedCategory.getHelpText());
        }
    }

    public void setCategories(SearchCat[] searchCategories) {
        SearchCatInterface old;
        this.searchCategories = searchCategories;
        this.label = new JLabel(){

            @Override
            public boolean isShowing() {
                return true;
            }

            @Override
            public boolean isVisible() {
                return true;
            }
        };
        SearchCat preSel = this.getSelectedCategory();
        boolean found = false;
        for (SearchCat sc : searchCategories) {
            if (sc == preSel) {
                found = true;
            }
            this.label.setText(sc.getLabel());
            this.labelWidth = Math.max(this.label.getPreferredSize().width, this.labelWidth);
        }
        if (!found && (old = (SearchCatInterface)this.selectedCategory.getAndSet(searchCategories[0])) != searchCategories[0]) {
            this.onChanged();
        }
        this.label.setSize(this.labelWidth, 24);
        this.setBorder(BorderFactory.createCompoundBorder(this.orgBorder, BorderFactory.createEmptyBorder(0, this.labelWidth + 14 + this.iconGap, 0, 18)));
        SearchCat sel = this.getSelectedCategory();
        this.label.setText(sel.getLabel());
        this.setHelpText(sel.getHelpText());
    }
}

