/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.actions;

import java.awt.event.ActionEvent;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.SearchDialog;
import org.appwork.utils.locale._AWU;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.toolbar.action.AbstractToolBarAction;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;

public class SearchToolbarAction
extends AbstractToolBarAction
implements ExtTableListener {
    private static final long serialVersionUID = 1L;
    private static final String NAME = _AWU.T.EXTTABLE_SEARCH_DIALOG_TITLE();

    public SearchToolbarAction() {
        this.setIconKey("search");
        this.setName(NAME);
        GUIEventSender.getInstance().addListener(this, true);
        this.onGuiMainTabSwitch(null, MainTabbedPane.getInstance().getSelectedView());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            PackageControllerTable table;
            View view = MainTabbedPane.getInstance().getSelectedView();
            if (view instanceof DownloadsView) {
                table = DownloadsTable.getInstance();
            } else if (view instanceof LinkGrabberView) {
                table = LinkGrabberTable.getInstance();
            } else {
                return;
            }
            new SearchDialog(0, (ExtTable)table){
                private static final long serialVersionUID = 2652101312418765845L;

                public void actionPerformed(ActionEvent e) {
                    String ret = this.getReturnID();
                    if (ret != null) {
                        int[] sel = table.getSelectedRows();
                        int startRow = -1;
                        if (sel != null & sel.length > 0) {
                            startRow = sel[sel.length - 1];
                        }
                        AbstractNode found = (AbstractNode)table.getModel().searchNextObject(startRow + 1, ret, this.isCaseSensitive(), this.isRegex());
                        table.getModel().setSelectedObject((Object)found);
                        table.scrollToSelection(-1);
                    }
                }
            };
        }
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
        if (newView instanceof DownloadsView) {
            this.setEnabled(true);
        } else if (newView instanceof LinkGrabberView) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected String createTooltip() {
        return NAME;
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
    }
}

