/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.columns;

import java.awt.event.ActionListener;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.HashInfo;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;

public class ChecksumColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;

    public ChecksumColumn() {
        super(_GUI.T.checksumcolumnmd5());
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        this.editorField.removeActionListener((ActionListener)((Object)this));
        String str = this.getEditorStringValue(value);
        if (str == null) {
            str = "";
        }
        this.editorField.setText(str);
        this.editorField.addActionListener((ActionListener)((Object)this));
        this.editorIconLabel.setIcon(this.getIcon(value));
    }

    private String getEditorStringValue(AbstractNode value) {
        HashInfo hashInfo;
        DownloadLink dl;
        if (value instanceof CrawledLink) {
            dl = ((CrawledLink)value).getDownloadLink();
        } else if (value instanceof DownloadLink) {
            dl = (DownloadLink)value;
        } else {
            return null;
        }
        if (dl != null && (hashInfo = dl.getHashInfo()) != null) {
            return hashInfo.getHash();
        }
        return null;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return this.isEditable(obj);
    }

    public boolean isEditable(AbstractNode obj) {
        if (obj instanceof CrawledLink) {
            return true;
        }
        return obj instanceof DownloadLink;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    protected void setStringValue(String value, AbstractNode object) {
        DownloadLink dl;
        if (object instanceof CrawledLink) {
            dl = ((CrawledLink)object).getDownloadLink();
        } else if (object instanceof DownloadLink) {
            dl = (DownloadLink)object;
        } else {
            return;
        }
        if (dl != null) {
            HashInfo hashInfo = StringUtils.isEmpty((String)(value = value.trim())) ? new HashInfo("", HashInfo.TYPE.NONE, true, true) : HashInfo.parse(value, true, true);
            dl.setHashInfo(hashInfo);
        }
    }

    public String getStringValue(AbstractNode value) {
        HashInfo hashInfo;
        DownloadLink dl;
        if (value instanceof CrawledLink) {
            dl = ((CrawledLink)value).getDownloadLink();
        } else if (value instanceof DownloadLink) {
            dl = (DownloadLink)value;
        } else {
            return null;
        }
        if (dl != null && (hashInfo = dl.getHashInfo()) != null) {
            return "[" + hashInfo.getType().name() + "] " + hashInfo.getHash();
        }
        return null;
    }
}

