/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.columns;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.controlling.AccountController;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.columns.ExtIconColumn;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.NewTheme;

public class HasCaptchaColumn
extends ExtIconColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private final Icon iconNo;
    private final Icon iconYes = CheckBoxIcon.TRUE;

    public HasCaptchaColumn() {
        super(_GUI.T.HasCaptchaColumn_HasCaptchaColumn_());
        this.iconNo = CheckBoxIcon.FALSE;
    }

    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
            private static final long serialVersionUID = 3938290423337000265L;
            final Icon ocr;
            {
                this.ocr = NewTheme.I().getIcon("ocr", 14);
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(this.ocr);
                this.setHorizontalAlignment(0);
                this.setText(null);
                this.setToolTipText(_GUI.T.HasCaptchaColumn_HasCaptchaColumn_());
                return this;
            }
        };
        return ret;
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public boolean isDefaultVisible() {
        return false;
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return false;
    }

    public int getMaxWidth() {
        return 100;
    }

    public int getMinWidth() {
        return 12;
    }

    public int getDefaultWidth() {
        return 22;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return true;
    }

    private boolean hasCaptcha(DownloadLink dlink) {
        PluginForHost plg = dlink.getDefaultPlugin();
        boolean hasCaptcha = true;
        if (plg != null) {
            List<Account> accs;
            hasCaptcha = Boolean.TRUE.equals(plg.expectCaptcha(dlink, null));
            if (hasCaptcha && (accs = AccountController.getInstance().getMultiHostAccounts(plg.getHost())) != null) {
                for (Account acc : accs) {
                    if (acc.getPlugin() != null && acc.isValid() && !acc.isTempDisabled() && acc.isEnabled()) {
                        hasCaptcha = Boolean.TRUE.equals(acc.getPlugin().expectCaptcha(dlink, acc));
                    }
                    if (hasCaptcha) continue;
                    break;
                }
            }
            if (hasCaptcha && (accs = AccountController.getInstance().list(plg.getHost())) != null) {
                for (Account acc : accs) {
                    if (acc.getPlugin() != null && acc.isValid() && !acc.isTempDisabled() && acc.isEnabled()) {
                        hasCaptcha = Boolean.TRUE.equals(acc.getPlugin().expectCaptcha(dlink, acc));
                    }
                    if (hasCaptcha) continue;
                    break;
                }
            }
        }
        return hasCaptcha;
    }

    protected Icon getIcon(AbstractNode value) {
        if (value instanceof DownloadLink) {
            DownloadLink dlink = (DownloadLink)value;
            if (this.hasCaptcha(dlink)) {
                return this.iconYes;
            }
            return this.iconNo;
        }
        if (value instanceof CrawledLink) {
            DownloadLink dlink = ((CrawledLink)value).getDownloadLink();
            if (this.hasCaptcha(dlink)) {
                return this.iconYes;
            }
            return this.iconNo;
        }
        return null;
    }

    protected String getTooltipText(AbstractNode value) {
        if (value instanceof DownloadLink) {
            DownloadLink dlink = (DownloadLink)value;
            if (this.hasCaptcha(dlink)) {
                return _GUI.T.HasCaptchaColumn_getTooltipText_yes();
            }
            return _GUI.T.HasCaptchaColumn_getTooltipText_no();
        }
        if (value instanceof CrawledLink) {
            DownloadLink dlink = ((CrawledLink)value).getDownloadLink();
            if (this.hasCaptcha(dlink)) {
                return _GUI.T.HasCaptchaColumn_getTooltipText_yes();
            }
            return _GUI.T.HasCaptchaColumn_getTooltipText_no();
        }
        return null;
    }
}

