/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.interfaces.View;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.translate._JDT;

public abstract class AbstractPriorityActionEntry<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType>
implements GUIListener,
ActionContext {
    private static final long serialVersionUID = 1L;
    private final Priority priority;
    private volatile boolean metaCtrl = false;
    private boolean forceMode = false;

    public AbstractPriorityActionEntry(Priority priority) {
        this.priority = priority;
        GUIEventSender.getInstance().addListener(this, true);
        this.metaCtrl = KeyObserver.getInstance().isMetaDown(true) || KeyObserver.getInstance().isControlDown(true);
        this.updateStateAndLabelAndIcon();
        this.setSmallIcon(priority.loadIcon(18));
    }

    @Override
    public void onKeyModifier(int parameter) {
        boolean before = this.metaCtrl;
        this.metaCtrl = KeyObserver.getInstance().isControlDown(false) || KeyObserver.getInstance().isMetaDown(false);
        if (before != this.metaCtrl) {
            this.updateStateAndLabelAndIcon();
        }
    }

    private void updateStateAndLabelAndIcon() {
        if (this.isForceMode() && !this.metaCtrl || this.metaCtrl) {
            this.setName(this.priority.T() + " " + _GUI.T.system_download_triggerfileexists_overwrite());
        } else {
            this.setName(this.priority.T());
        }
    }

    public static String getTranslationForForceMode() {
        return _JDT.T.PriorityAction_getTranslationForForceMode();
    }

    @Customizer(link="#getTranslationForForceMode")
    public boolean isForceMode() {
        return this.forceMode;
    }

    public void setForceMode(boolean forceMode) {
        this.forceMode = forceMode;
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, View newView) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final SelectionInfo selection = this.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final boolean finalMetaCtrl = this.forceMode ? !this.metaCtrl : this.metaCtrl;
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void run() throws RuntimeException {
                boolean linkGrabber = false;
                boolean downloadList = false;
                ArrayList<AbstractPackageNode> forcePriority = new ArrayList<AbstractPackageNode>();
                for (AbstractNode abstractNode : selection.getRawSelection()) {
                    if (abstractNode instanceof CrawledLink) {
                        linkGrabber = true;
                        ((CrawledLink)abstractNode).setPriority(AbstractPriorityActionEntry.this.priority);
                        continue;
                    }
                    if (abstractNode instanceof DownloadLink) {
                        downloadList = true;
                        ((DownloadLink)abstractNode).setPriorityEnum(AbstractPriorityActionEntry.this.priority);
                        continue;
                    }
                    if (abstractNode instanceof CrawledPackage) {
                        linkGrabber = true;
                        if (finalMetaCtrl) {
                            forcePriority.add((AbstractPackageNode)abstractNode);
                        }
                        ((CrawledPackage)abstractNode).setPriorityEnum(AbstractPriorityActionEntry.this.priority);
                        continue;
                    }
                    if (!(abstractNode instanceof FilePackage)) continue;
                    downloadList = true;
                    if (finalMetaCtrl) {
                        forcePriority.add((AbstractPackageNode)abstractNode);
                    }
                    ((FilePackage)abstractNode).setPriorityEnum(AbstractPriorityActionEntry.this.priority);
                }
                for (AbstractPackageNode abstractPackageNode : forcePriority) {
                    boolean readL = abstractPackageNode.getModifyLock().readLock();
                    try {
                        for (Object child : abstractPackageNode.getChildren()) {
                            if (child instanceof CrawledLink) {
                                ((CrawledLink)child).setPriority(AbstractPriorityActionEntry.this.priority);
                                continue;
                            }
                            if (!(child instanceof DownloadLink)) continue;
                            ((DownloadLink)child).setPriorityEnum(AbstractPriorityActionEntry.this.priority);
                        }
                    }
                    finally {
                        abstractPackageNode.getModifyLock().readUnlock(readL);
                    }
                }
                if (linkGrabber) {
                    LinkGrabberTableModel.getInstance().setPriorityColumnVisible(true);
                }
                if (downloadList) {
                    DownloadsTableModel.getInstance().setPriorityColumnVisible(true);
                }
                return null;
            }
        });
    }
}

