/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.context.rename.RenameDialog;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.translate._JDT;

public class RenameAction
extends CustomizableTableContextAppAction
implements ActionContext {
    private boolean simpleMode = false;

    public RenameAction() {
        this.setName(_GUI.T.RenameAction_RenameAction());
        this.setTooltipText(_GUI.T.RenameAction_RenameAction_tt());
        this.setIconKey("edit");
        this.setAccelerator(KeyStroke.getKeyStroke("F2"));
    }

    public static String getTranslationForSimpleMode() {
        return _JDT.T.RenameAction_getTranslationForSimpleMode();
    }

    @Customizer(link="#getTranslationForSimpleMode")
    public boolean isSimpleMode() {
        return this.simpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.simpleMode = simpleMode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectionInfo selection = this.getSelection();
        if (this.isSimpleMode() || selection.getRawSelection().size() == 1 && (!(e.getSource() instanceof JMenuItem) || selection.isPackageContext())) {
            try {
                PackageControllerTable table;
                PackageController controller = selection.getController();
                if (DownloadController.getInstance() == controller) {
                    table = DownloadsTable.getInstance();
                } else if (LinkCollector.getInstance() == controller) {
                    table = LinkGrabberTable.getInstance();
                } else {
                    return;
                }
                ExtColumn col = table.getModel().getColumnByClass(FileColumn.class);
                col.startEditing((Object)selection.getRawContext());
            }
            catch (Exception controller) {}
        } else if (this.hasSelection(selection)) {
            RenameDialog d = new RenameDialog(selection);
            try {
                Dialog.getInstance().showDialog((AbstractDialog)d);
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
                // empty catch block
            }
        }
    }
}

