/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.event.ActionEvent;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.InputDialog;
import org.appwork.utils.swing.dialog.dimensor.DialogDimensor;
import org.appwork.utils.swing.dialog.dimensor.RememberLastDialogDimension;
import org.appwork.utils.swing.dialog.locator.DialogLocator;
import org.appwork.utils.swing.dialog.locator.RememberAbsoluteDialogLocator;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;

public class SetCommentAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType> {
    public SetCommentAction() {
        this.setName(_GUI.T.SetCommentAction_SetCommentAction_object_());
        this.setIconKey("list");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String def = null;
        final SelectionInfo selection = this.getSelection();
        for (AbstractNode n : selection.getRawSelection()) {
            if (n instanceof DownloadLink) {
                def = ((DownloadLink)n).getComment();
            } else if (n instanceof CrawledLink) {
                def = ((CrawledLink)n).getDownloadLink().getComment();
            } else if (n instanceof FilePackage) {
                def = ((FilePackage)n).getComment();
            } else if (n instanceof CrawledPackage) {
                def = ((CrawledPackage)n).getComment();
            }
            if (StringUtils.isEmpty((String)def)) continue;
            break;
        }
        try {
            InputDialog dialog = new InputDialog(320, _GUI.T.SetCommentAction_actionPerformed_dialog_title_(), "", def, null, null, null);
            dialog.setLocator((DialogLocator)new RememberAbsoluteDialogLocator("SetCommentAction"));
            dialog.setDimensor((DialogDimensor)new RememberLastDialogDimension("SetCommentAction"));
            InputDialogInterface d = (InputDialogInterface)UIOManager.I().show(InputDialogInterface.class, (UserIODefinition)dialog);
            d.throwCloseExceptions();
            final String comment = d.getText();
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    for (AbstractNode n : selection.getRawSelection()) {
                        if (n instanceof DownloadLink) {
                            ((DownloadLink)n).setComment(comment);
                            continue;
                        }
                        if (n instanceof CrawledLink) {
                            ((CrawledLink)n).getDownloadLink().setComment(comment);
                            continue;
                        }
                        if (n instanceof FilePackage) {
                            ((FilePackage)n).setComment(comment);
                            continue;
                        }
                        if (!(n instanceof CrawledPackage)) continue;
                        ((CrawledPackage)n).setComment(comment);
                    }
                    return null;
                }
            });
        }
        catch (DialogClosedException dialogClosedException) {
        }
        catch (DialogCanceledException dialogCanceledException) {
            // empty catch block
        }
    }
}

