/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.context;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.translate._JDT;

public abstract class SetDownloadFolderAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType>
implements ActionContext {
    private File path;
    private boolean simpleDialog = false;

    public SetDownloadFolderAction() {
        this.setName(_GUI.T.SetDownloadFolderAction_SetDownloadFolderAction_());
        this.setIconKey("save");
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        SelectionInfo lselection = this.getSelection();
        if (this.hasSelection(lselection)) {
            Object cp = lselection.getFirstPackage();
            this.path = LinkTreeUtils.getRawDownloadDirectory(cp);
            if (this.path.getName().equals(cp.getName())) {
                this.path = new File(this.path.getParentFile(), "<jd:packagename>");
            }
        }
    }

    public static boolean isDownloadFolderValid(File file) {
        if (file == null || file.isFile()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        File parent = file.getParentFile();
        return parent != null && parent.isDirectory() && parent.exists();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            final File file = this.dialog(this.path);
            if (file == null) {
                return;
            }
            final String dontShowAgainKey = this.getClass().getName();
            final SelectionInfo lselection = this.getSelection();
            final ArrayList incompletePackageViews = new ArrayList(0);
            this.getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(){

                protected Object run() {
                    for (SelectionInfo.PackageView packageView : lselection.getPackageViews()) {
                        if (lselection.isPackageSelectionComplete(packageView.getPackage())) {
                            SetDownloadFolderAction.this.set(packageView.getPackage(), file.getAbsolutePath());
                            continue;
                        }
                        incompletePackageViews.add(packageView);
                    }
                    new EDTRunner(){

                        protected void runInEDT() {
                            for (final SelectionInfo.PackageView packageView : incompletePackageViews) {
                                final Object entry = packageView.getPackage();
                                try {
                                    File oldPath = LinkTreeUtils.getDownloadDirectory(entry);
                                    File newPath = file;
                                    if (oldPath.equals(newPath)) continue;
                                    Dialog.getInstance().showConfirmDialog(4128, _JDT.T.SetDownloadFolderAction_actionPerformed_(entry.getName()), _JDT.T.SetDownloadFolderAction_msg(entry.getName(), packageView.getChildren().size()), null, _JDT.T.SetDownloadFolderAction_yes(), _JDT.T.SetDownloadFolderAction_no(), dontShowAgainKey);
                                    this.getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(){

                                        protected Object run() {
                                            SetDownloadFolderAction.this.set(entry, file.getAbsolutePath());
                                            return null;
                                        }
                                    });
                                }
                                catch (DialogClosedException e1) {
                                    return;
                                }
                                catch (DialogCanceledException dialogCanceledException) {
                                    this.getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(){

                                        protected Object run() {
                                            final AbstractPackageNode pkg = SetDownloadFolderAction.this.createNewByPrototype(lselection, entry);
                                            SetDownloadFolderAction.this.set(pkg, file.getAbsolutePath());
                                            this.getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(){

                                                protected Object run() {
                                                    SetDownloadFolderAction.this.move(pkg, packageView.getChildren());
                                                    return null;
                                                }
                                            });
                                            return null;
                                        }
                                    });
                                }
                            }
                        }
                    };
                    return null;
                }
            });
        }
        catch (DialogNoAnswerException dialogNoAnswerException) {
            // empty catch block
        }
    }

    protected abstract Queue getQueue();

    @Customizer(link="#getTranslationForSimpleInputDialog")
    public boolean isSimpleInputDialog() {
        return this.simpleDialog;
    }

    public void setSimpleInputDialog(boolean simpleDialog) {
        this.simpleDialog = simpleDialog;
    }

    public static String getTranslationForSimpleInputDialog() {
        return _JDT.T.SetDownloadFolder_getTranslationForSimpleMode();
    }

    protected File dialog(File path) throws DialogClosedException, DialogCanceledException {
        if (!this.isSimpleInputDialog()) {
            return DownloadFolderChooserDialog.open(path, true, _GUI.T.OpenDownloadFolderAction_actionPerformed_object_(this.getSelection().getFirstPackage().getName()));
        }
        return new File(Dialog.getInstance().showInputDialog(0, _GUI.T.OpenDownloadFolderAction_actionPerformed_object_(this.getSelection().getFirstPackage().getName()), _GUI.T.jd_gui_userio_defaulttitle_input(), path.getAbsolutePath(), (Icon)new AbstractIcon("password", 32), null, null));
    }

    protected abstract void move(PackageType var1, List<ChildrenType> var2);

    protected abstract PackageType createNewByPrototype(SelectionInfo<PackageType, ChildrenType> var1, PackageType var2);

    protected abstract void set(PackageType var1, String var2);
}

