/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.components.packagetable.dragdrop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.utils.ClipboardUtils;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;

public class PackageControllerTableTransferable<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
implements Transferable {
    public static final DataFlavor FLAVOR = new DataFlavor((Class)PackageControllerTableTransferable.class, PackageControllerTableTransferable.class.getName()){

        @Override
        public boolean isFlavorSerializedObjectType() {
            return false;
        }
    };
    protected final SelectionInfo<PackageType, ChildrenType> selectionInfo;
    protected DataFlavor[] flavors;
    protected final PackageControllerTable<PackageType, ChildrenType> table;
    protected String stringContent = null;

    public SelectionInfo<PackageType, ChildrenType> getSelectionInfo() {
        return this.selectionInfo;
    }

    public PackageControllerTable<PackageType, ChildrenType> getTable() {
        return this.table;
    }

    public PackageControllerTableTransferable(SelectionInfo<PackageType, ChildrenType> selectionInfo, PackageControllerTable<PackageType, ChildrenType> table, String stringContent) {
        this.selectionInfo = selectionInfo;
        this.table = table;
        ArrayList<DataFlavor> availableFlavors = new ArrayList<DataFlavor>();
        availableFlavors.add(FLAVOR);
        if (stringContent != null) {
            availableFlavors.add(ClipboardUtils.stringFlavor);
            this.stringContent = stringContent;
        }
        this.flavors = availableFlavors.toArray(new DataFlavor[0]);
    }

    public PackageControllerTableTransferable(SelectionInfo<PackageType, ChildrenType> selectionInfo, PackageControllerTable<PackageType, ChildrenType> table) {
        this(selectionInfo, table, null);
    }

    protected PackageControllerTableTransferable(PackageControllerTableTransferable<PackageType, ChildrenType> transferable) {
        this.selectionInfo = transferable.getSelectionInfo();
        this.table = transferable.getTable();
        this.stringContent = transferable.stringContent;
        this.flavors = transferable.getTransferDataFlavors();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    protected boolean isEmpty() {
        SelectionInfo<PackageType, ChildrenType> selectionInfo = this.getSelectionInfo();
        return selectionInfo == null || selectionInfo.isEmpty();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        if (flavor.equals(FLAVOR)) {
            return this.getSelectionInfo();
        }
        if (flavor.equals(ClipboardUtils.stringFlavor)) {
            return this.stringContent;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected Set<String> getURLs() {
        return LinkTreeUtils.getURLs(this.getSelectionInfo(), false);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor wished) {
        if (wished != null && !this.isEmpty()) {
            for (DataFlavor exist : this.getTransferDataFlavors()) {
                if (!exist.equals(wished)) continue;
                return true;
            }
        }
        return false;
    }
}

