/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jd.controlling.packagecontroller.AbstractNode;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.components.OverviewHeaderScrollPane;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.WidgetContainer;
import org.jdownloader.gui.views.downloads.bottombar.CustomizeableActionBar;
import org.jdownloader.gui.views.downloads.overviewpanel.DownloadOverViewHeader;
import org.jdownloader.gui.views.downloads.overviewpanel.DownloadOverview;
import org.jdownloader.gui.views.downloads.properties.DownloadPropertiesBasePanel;
import org.jdownloader.gui.views.downloads.properties.DownloadPropertiesHeader;
import org.jdownloader.gui.views.downloads.properties.DownloadsPropertiesScrollPane;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class DownloadsPanelWidgetContainer
extends WidgetContainer
implements GenericConfigEventListener<Boolean> {
    private static final long serialVersionUID = 1L;
    private final DownloadsTable table;
    private DownloadsPropertiesScrollPane propertiesPanelScrollPane;
    private boolean propertiesPanelVisible = false;
    private OverviewHeaderScrollPane overviewScrollPane = null;
    private final CustomizeableActionBar bottomBar;

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(final KeyHandler<Boolean> keyHandler, final Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                if (newValue.booleanValue() && keyHandler == CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE) {
                    DownloadsPanelWidgetContainer.this.setPropertiesPanelVisible(true);
                }
                DownloadsPanelWidgetContainer.this.relayout();
            }
        };
    }

    @Override
    protected void setPropertiesPanelVisible(boolean propertiesPanelVisible) {
        this.propertiesPanelVisible = propertiesPanelVisible;
    }

    @Override
    public void relayout() {
        Container p;
        boolean showProperties;
        if (this.propertiesPanelScrollPane != null) {
            this.propertiesPanelScrollPane.save();
        }
        this.removeAll();
        this.setVisible(true);
        AbstractNode selectedObject = this.getTable().getModel().hasSelectedObjects() ? (AbstractNode)this.getTable().getModel().getObjectbyRow(this.getTable().getSelectionModel().getLeadSelectionIndex()) : null;
        boolean bl = showProperties = CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() && this.propertiesPanelVisible && selectedObject != null;
        if (CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE.isEnabled()) {
            if (showProperties) {
                this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[]" + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap() + "[]"));
                this.add(this.wrap(this.createPropertiesPanel()), "");
                this.add(this.wrap(this.getOverView()), "");
                this.createPropertiesPanel().update(selectedObject);
            } else {
                this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[]"));
                this.add(this.wrap(this.getOverView()), "");
            }
        } else if (showProperties) {
            this.setLayout((LayoutManager)new MigLayout("ins 0, wrap 1", "[grow,fill]", "[]"));
            this.add(this.wrap(this.createPropertiesPanel()), "");
            this.createPropertiesPanel().update(selectedObject);
        } else {
            this.setVisible(false);
        }
        if (!showProperties) {
            this.createPropertiesPanel().update((AbstractNode)null);
        }
        if ((p = this.getParent()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DownloadsPanelWidgetContainer.this.revalidate();
                    if (Application.getJavaVersion() >= Application.JAVA17) {
                        p.revalidate();
                    } else {
                        p.invalidate();
                        p.validate();
                    }
                    DownloadsPanelWidgetContainer.this.doLayout();
                    p.doLayout();
                }
            });
        }
    }

    @Override
    public void refreshAfterTabSwitch() {
        new EDTRunner(){

            protected void runInEDT() {
                if (DownloadsPanelWidgetContainer.this.propertiesPanelScrollPane != null) {
                    DownloadsPanelWidgetContainer.this.propertiesPanelScrollPane.refreshAfterTabSwitch();
                }
            }
        };
    }

    private OverviewHeaderScrollPane getOverView() {
        if (this.overviewScrollPane != null) {
            return this.overviewScrollPane;
        }
        DownloadOverview overView = new DownloadOverview(this.table);
        final OverviewHeaderScrollPane ret = new OverviewHeaderScrollPane((JComponent)((Object)overView));
        LAFOptions.getInstance().applyPanelBackground((JComponent)ret);
        ret.setColumnHeaderView((Component)((Object)new DownloadOverViewHeader(overView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onCloseAction() {
                if (DownloadsPanelWidgetContainer.this.overviewScrollPane == ret) {
                    DownloadsPanelWidgetContainer.this.overviewScrollPane = null;
                }
                CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE.setValue((Object)false);
                CustomizeableActionBar iconComp = DownloadsPanelWidgetContainer.this.bottomBar;
                Point loc = DownloadsPanelWidgetContainer.this.bottomBar.getLocationOnScreen();
                if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                    HelpDialog.show(false, false, new Point(loc.x + iconComp.getWidth() - iconComp.getHeight() / 2, loc.y + iconComp.getHeight() / 2), "overviewclosed", 32, _GUI.T.DownloadsPanel_onCloseAction(), _GUI.T.DownloadsPanel_onCloseAction_help(), new AbstractIcon("bottombar", 32));
                }
            }
        }));
        this.overviewScrollPane = ret;
        return ret;
    }

    public DownloadsPanelWidgetContainer(DownloadsTable table, CustomizeableActionBar bottomBar) {
        super(table, CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE);
        this.table = table;
        this.bottomBar = bottomBar;
        CFG_GUI.DOWNLOAD_TAB_OVERVIEW_VISIBLE.getEventSender().addListener((EventListener)((Object)this));
        CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.getEventSender().addListener((EventListener)((Object)this));
    }

    @Override
    protected DownloadsPropertiesScrollPane createPropertiesPanel() {
        if (this.propertiesPanelScrollPane != null) {
            return this.propertiesPanelScrollPane;
        }
        DownloadPropertiesBasePanel propertiesContentPanel = new DownloadPropertiesBasePanel(this.table);
        DownloadsPropertiesScrollPane propertiesScrollPane = new DownloadsPropertiesScrollPane(propertiesContentPanel, this.table);
        LAFOptions.getInstance().applyPanelBackground((JComponent)propertiesScrollPane);
        propertiesScrollPane.setColumnHeaderView(new DownloadPropertiesHeader(propertiesContentPanel){

            @Override
            protected void onCloseAction() {
                CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)false);
                CustomizeableActionBar iconComp = DownloadsPanelWidgetContainer.this.bottomBar;
                Point loc = iconComp.getLocationOnScreen();
                if (CFG_GUI.HELP_DIALOGS_ENABLED.isEnabled()) {
                    HelpDialog.show(false, false, new Point(loc.x + iconComp.getWidth() - iconComp.getHeight() / 2, loc.y + iconComp.getHeight() / 2), "propertiesclosed", 32, _GUI.T.DownloadsPanel_onCloseAction(), _GUI.T.Linkgrabber_properties_onCloseAction_help(), new AbstractIcon("bottombar", 32));
                }
            }
        });
        this.propertiesPanelScrollPane = propertiesScrollPane;
        return propertiesScrollPane;
    }
}

