/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.plugins.download.HashInfo;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;

public class ConfirmHashValuesLinkgrabberAction
extends CustomizableTableContextAppAction<CrawledPackage, CrawledLink>
implements ActionContext,
ExtTableListener,
ExtTableModelListener {
    private IncludedSelectionSetup includedSelection;

    public ConfirmHashValuesLinkgrabberAction() {
        super(true, true);
        this.setIconKey("hashsum");
        this.setName(_GUI.T.ConfirmHashValuesAction());
        this.includedSelection = new IncludedSelectionSetup(LinkGrabberTable.getInstance(), this, this);
        this.addContextSetup(this.includedSelection);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final PackageControllerTable.SelectionType selectionType = this.includedSelection.getSelectionType();
        LinkGrabberTable.getInstance().getSelectionInfo(new PackageControllerTable.SelectionInfoCallback<CrawledPackage, CrawledLink>(){

            @Override
            public void onSelectionInfo(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                List<CrawledLink> links;
                switch (selectionType) {
                    case UNSELECTED: {
                        if (selectionInfo.getUnselectedChildren() != null) {
                            links = selectionInfo.getUnselectedChildren();
                            break;
                        }
                        links = null;
                        break;
                    }
                    default: {
                        links = selectionInfo.getChildren();
                    }
                }
                if (links == null || links.size() == 0) {
                    return;
                }
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        ArrayList<CrawledLink> list;
                        HashMap<String, ArrayList<CrawledLink>> map = new HashMap<String, ArrayList<CrawledLink>>();
                        for (CrawledLink crawledLink : links) {
                            list = (ArrayList<CrawledLink>)map.get(crawledLink.getName());
                            if (list == null) {
                                list = new ArrayList<CrawledLink>();
                                map.put(crawledLink.getName(), list);
                            }
                            list.add(crawledLink);
                        }
                        block1: for (Map.Entry entry : map.entrySet()) {
                            list = (List)entry.getValue();
                            HashMap<HashInfo.TYPE, HashInfo> knownHashInfos = new HashMap<HashInfo.TYPE, HashInfo>();
                            for (CrawledLink cl : list) {
                                HashInfo hashInfo;
                                if (cl.getDownloadLink() == null || (hashInfo = cl.getDownloadLink().getHashInfo()) == null) continue;
                                HashInfo existing = (HashInfo)knownHashInfos.get((Object)hashInfo.getType());
                                if (existing == null) {
                                    knownHashInfos.put(hashInfo.getType(), hashInfo);
                                    continue;
                                }
                                if (existing.equals(hashInfo)) continue;
                                continue block1;
                            }
                            if (knownHashInfos.size() <= 0) continue;
                            for (HashInfo.TYPE type : HashInfo.TYPE.values()) {
                                HashInfo existing = (HashInfo)knownHashInfos.get((Object)type);
                                if (existing == null) continue;
                                HashInfo newHashInfo = HashInfo.newInstanceSafe(existing.getHash(), existing.getType(), existing.isTrustworthy(), true);
                                for (CrawledLink cl : list) {
                                    if (cl.getDownloadLink() == null) continue;
                                    cl.getDownloadLink().setHashInfo(newHashInfo);
                                }
                                continue block1;
                            }
                        }
                        return null;
                    }
                });
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        }, selectionType);
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper event) {
    }
}

