/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.KeyStroke;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.KeyObserver;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.action.ByPassDialogSetup;
import org.jdownloader.gui.views.downloads.action.DownloadTabActionUtils;
import org.jdownloader.gui.views.downloads.action.Modifier;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.linkgrabber.bottombar.IncludedSelectionSetup;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.translate._JDT;

public class GenericDeleteFromDownloadlistAction
extends CustomizableAppAction
implements ExtTableListener,
ActionContext,
DownloadControllerListener,
ExtTableModelListener {
    public static final String DELETE_ALL = "deleteAll";
    public static final String DELETE_DISABLED = "deleteDisabled";
    public static final String DELETE_FAILED = "deleteFailed";
    public static final String DELETE_FINISHED = "deleteFinished";
    public static final String DELETE_OFFLINE = "deleteOffline";
    public static final String DELETE_MODE = "deleteMode";
    private static final long serialVersionUID = 1L;
    private final DelayedRunnable delayer;
    private boolean deleteAll = false;
    private boolean deleteDisabled = false;
    private boolean deleteFailed = false;
    private boolean deleteFinished = false;
    private boolean deleteOffline = false;
    private boolean ignoreFiltered = true;
    protected volatile WeakReference<DownloadLink> lastLink = new WeakReference<Object>(null);
    private Modifier deleteFilesToggleModifier = null;
    private GraphicalUserInterfaceSettings.DeleteFileOptions deleteMode;
    private ByPassDialogSetup byPassDialog;
    protected IncludedSelectionSetup includedSelection;
    private boolean deleteFinishedPackage;
    protected volatile WeakReference<PackageControllerTable.SelectionInfoCallback> lastCallBack = new WeakReference<Object>(null);

    public static String getTranslationForDeleteFilesToggleModifier() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteFilesToggleModifier();
    }

    @Customizer(link="#getTranslationForDeleteFilesToggleModifier")
    public Modifier getDeleteFilesToggleModifier() {
        return this.deleteFilesToggleModifier;
    }

    public void setDeleteFilesToggleModifier(Modifier deleteFilesToggleModifier) {
        this.deleteFilesToggleModifier = deleteFilesToggleModifier;
    }

    @Override
    public void initContextDefaults() {
        super.initContextDefaults();
        this.includedSelection.setIncludeSelectedLinks(true);
        this.includedSelection.setIncludeUnselectedLinks(true);
    }

    public static String getTranslationForDeleteMode() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteMode();
    }

    @Customizer(link="#getTranslationForDeleteMode")
    public GraphicalUserInterfaceSettings.DeleteFileOptions getDeleteMode() {
        Modifier deletToggle = this.getDeleteFilesToggleModifier();
        if (this.deleteMode == null) {
            this.deleteMode = GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_ONLY;
        }
        if (deletToggle != null && KeyObserver.getInstance().isModifierPressed(deletToggle.getModifier(), false)) {
            switch (this.deleteMode) {
                case REMOVE_LINKS_ONLY: {
                    return GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_AND_RECYCLE_FILES;
                }
                case REMOVE_LINKS_AND_DELETE_FILES: 
                case REMOVE_LINKS_AND_RECYCLE_FILES: {
                    return GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_ONLY;
                }
            }
        }
        return this.deleteMode;
    }

    public void setDeleteMode(GraphicalUserInterfaceSettings.DeleteFileOptions deleteMode) {
        this.deleteMode = deleteMode;
    }

    @Override
    public void loadContextSetups() {
        super.loadContextSetups();
        new EDTRunner(){

            protected void runInEDT() {
                GenericDeleteFromDownloadlistAction.this.setName(GenericDeleteFromDownloadlistAction.this.createName());
            }
        }.getReturnValue();
    }

    public GenericDeleteFromDownloadlistAction() {
        this.byPassDialog = new ByPassDialogSetup();
        this.addContextSetup(this.byPassDialog);
        this.delayer = new DelayedRunnable(TaskQueue.TIMINGQUEUE, 500L, 1500L){

            public void delayedrun() {
                GenericDeleteFromDownloadlistAction.this.update();
            }
        };
        this.initIncludedSelectionSupport();
        this.setIconKey("delete");
    }

    protected void initIncludedSelectionSupport() {
        this.includedSelection = new IncludedSelectionSetup(DownloadsTable.getInstance(), this, this){

            @Override
            public PackageControllerTable.SelectionType getSelectionType() {
                PackageControllerTable.SelectionType ret = super.getSelectionType();
                if (PackageControllerTable.SelectionType.ALL.equals((Object)ret) && !GenericDeleteFromDownloadlistAction.this.isIgnoreFiltered()) {
                    return PackageControllerTable.SelectionType.BACKEND;
                }
                return ret;
            }

            @Override
            public void updateListeners() {
                super.updateListeners();
                switch (this.getSelectionType()) {
                    case ALL: 
                    case BACKEND: {
                        DownloadController.getInstance().getEventSender().addListener((EventListener)GenericDeleteFromDownloadlistAction.this, true);
                        break;
                    }
                    case SELECTED: 
                    case UNSELECTED: {
                        DownloadController.getInstance().getEventSender().removeListener((EventListener)GenericDeleteFromDownloadlistAction.this);
                        break;
                    }
                    case NONE: {
                        DownloadController.getInstance().getEventSender().removeListener((EventListener)GenericDeleteFromDownloadlistAction.this);
                    }
                }
            }
        };
        this.addContextSetup(this.includedSelection);
    }

    @Override
    public List<KeyStroke> getAdditionalShortcuts(KeyStroke keystroke) {
        Modifier mod2;
        if (keystroke == null) {
            return null;
        }
        ArrayList<KeyStroke> ret = new ArrayList<KeyStroke>();
        Modifier mod1 = this.byPassDialog.getByPassDialogToggleModifier();
        if (mod1 != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod1.getModifier()));
        }
        if ((mod2 = this.getDeleteFilesToggleModifier()) != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod2.getModifier()));
        }
        if (mod2 != null && mod1 != null) {
            ret.add(KeyStroke.getKeyStroke(keystroke.getKeyCode(), keystroke.getModifiers() | mod2.getModifier() | mod1.getModifier()));
        }
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        final PackageControllerTable.SelectionType selectionType = this.includedSelection.getSelectionType();
        DownloadsTable table = DownloadsTable.getInstance();
        table.getSelectionInfo(new PackageControllerTable.QueueSelectionInfoCallback<FilePackage, DownloadLink>(){

            @Override
            public void onSelectionInfo(SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                ArrayList<DownloadLink> nodesToDelete = new ArrayList<DownloadLink>();
                boolean createNewSelectionInfo = false;
                switch (selectionType) {
                    case NONE: {
                        return;
                    }
                    case UNSELECTED: {
                        createNewSelectionInfo = true;
                        for (DownloadLink child : selectionInfo.getUnselectedChildren()) {
                            if (!GenericDeleteFromDownloadlistAction.this.checkLink(child)) continue;
                            nodesToDelete.add(child);
                        }
                        break;
                    }
                    default: {
                        for (DownloadLink dl : selectionInfo.getChildren()) {
                            if (GenericDeleteFromDownloadlistAction.this.checkLink(dl)) {
                                nodesToDelete.add(dl);
                                continue;
                            }
                            createNewSelectionInfo = true;
                        }
                    }
                }
                if (nodesToDelete.size() == 0) {
                    new EDTHelper<Void>(){

                        public Void edtRun() {
                            Toolkit.getDefaultToolkit().beep();
                            Dialog.getInstance().showErrorDialog(_GUI.T.GenericDeleteSelectedToolbarAction_actionPerformed_nothing_to_delete_());
                            return null;
                        }
                    }.start(true);
                    return;
                }
                SelectionInfo<FilePackage, DownloadLink> si = createNewSelectionInfo ? new SelectionInfo(null, nodesToDelete) : selectionInfo;
                if (si.getChildren().size() > 0) {
                    DownloadTabActionUtils.deleteLinksRequest(si, _GUI.T.GenericDeleteFromDownloadlistAction_actionPerformed_ask_(GenericDeleteFromDownloadlistAction.this.createName()), GenericDeleteFromDownloadlistAction.this.getDeleteMode(), GenericDeleteFromDownloadlistAction.this.byPassDialog.isBypassDialog());
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public Queue getQueue() {
                return TaskQueue.getQueue();
            }
        }, selectionType);
    }

    public boolean checkLink(DownloadLink link) {
        if (this.isDeleteAll()) {
            return true;
        }
        if (this.isDeleteDisabled() && !link.isEnabled()) {
            return true;
        }
        if (this.isDeleteFailed() && FinalLinkState.CheckFailed(link.getFinalLinkState())) {
            return true;
        }
        if (this.isDeleteFinished() && FinalLinkState.CheckFinished(link.getFinalLinkState())) {
            return true;
        }
        if (this.isDeleteFinishedPackage() && link.getFilePackage().getView().isFinished()) {
            return true;
        }
        return this.isDeleteOffline() && (FinalLinkState.OFFLINE.equals((Object)link.getFinalLinkState()) || DownloadLink.AvailableStatus.FALSE.equals((Object)link.getAvailableStatus()));
    }

    private String createName() {
        StringBuilder sb = new StringBuilder();
        if (this.isDeleteAll()) {
            switch (this.includedSelection.getSelectionType()) {
                case SELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected_all().trim());
                    break;
                }
                case UNSELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_keep_selected().trim());
                    break;
                }
                default: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_all().trim());
                    break;
                }
            }
        } else {
            switch (this.includedSelection.getSelectionType()) {
                case SELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected().trim());
                    break;
                }
                case UNSELECTED: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_keep_unselected().trim());
                    break;
                }
                default: {
                    sb.append(_GUI.T.GenericDeleteSelectedToolbarAction_updateName_object().trim());
                }
            }
            boolean first = true;
            if (this.isDeleteDisabled()) {
                if (!first) {
                    this.appendMissingSpace(sb);
                    sb.append("&");
                }
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.lit_disabled().trim());
                first = false;
            }
            if (this.isDeleteFailed()) {
                if (!first) {
                    this.appendMissingSpace(sb);
                    sb.append("&");
                }
                first = false;
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.lit_failed().trim());
            }
            if (this.isDeleteFinished()) {
                if (!first) {
                    this.appendMissingSpace(sb);
                    sb.append("&");
                }
                first = false;
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.lit_finished().trim());
            }
            if (this.isDeleteFinishedPackage()) {
                if (!first) {
                    this.appendMissingSpace(sb);
                    sb.append("&");
                }
                first = false;
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.lit_finished_package().trim());
            }
            if (this.isDeleteOffline()) {
                if (!first) {
                    this.appendMissingSpace(sb);
                    sb.append("&");
                }
                first = false;
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.lit_offline().trim());
            }
        }
        switch (this.getDeleteMode()) {
            case REMOVE_LINKS_AND_DELETE_FILES: {
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.deleteaction_and_delete_files().trim());
                break;
            }
            case REMOVE_LINKS_AND_RECYCLE_FILES: {
                this.appendMissingSpace(sb);
                sb.append(_GUI.T.deleteaction_and_recycle_files().trim());
                break;
            }
        }
        return sb.toString();
    }

    private void appendMissingSpace(StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) != ' ') {
            sb.append(" ");
        }
    }

    protected DownloadsTable getTable() {
        return (DownloadsTable)DownloadsTableModel.getInstance().getTable();
    }

    public static String getTranslationForDeleteAll() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteAll();
    }

    @Customizer(link="#getTranslationForDeleteAll")
    public boolean isDeleteAll() {
        return this.deleteAll;
    }

    public static String getTranslationForDeleteDisabled() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteDisabled();
    }

    @Customizer(link="#getTranslationForDeleteDisabled")
    public boolean isDeleteDisabled() {
        return this.deleteDisabled;
    }

    public static String getTranslationForDeleteFailed() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteFailed();
    }

    @Customizer(link="#getTranslationForDeleteFailed")
    public boolean isDeleteFailed() {
        return this.deleteFailed;
    }

    public static String getTranslationForDeleteFinishedPackage() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteFinishedPackage();
    }

    public static String getTranslationForDeleteFinished() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteFinished();
    }

    @Customizer(link="#getTranslationForDeleteFinishedPackage")
    public boolean isDeleteFinishedPackage() {
        return this.deleteFinishedPackage;
    }

    public void setDeleteFinishedPackage(boolean deleteFinished) {
        this.deleteFinishedPackage = deleteFinished;
    }

    @Customizer(link="#getTranslationForDeleteFinished")
    public boolean isDeleteFinished() {
        return this.deleteFinished;
    }

    public static String getTranslationForDeleteOffline() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForDeleteOffline();
    }

    @Customizer(link="#getTranslationForDeleteOffline")
    public boolean isDeleteOffline() {
        return this.deleteOffline;
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public static String getTranslationForIgnoreFiltered() {
        return _JDT.T.GenericDeleteFromDownloadlistAction_getTranslationForIgnoreFiltered();
    }

    @Customizer(link="#getTranslationForIgnoreFiltered")
    public boolean isIgnoreFiltered() {
        return this.ignoreFiltered;
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        this.delayer.resetAndStart();
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
        if (event.getType() == ExtTableEvent.Types.SELECTION_CHANGED) {
            this.update();
        }
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.update();
    }

    public void setDeleteAll(boolean deleteIdle) {
        this.deleteAll = deleteIdle;
    }

    public void setDeleteDisabled(boolean deleteDisabled) {
        this.deleteDisabled = deleteDisabled;
    }

    public void setDeleteFailed(boolean deleteFailed) {
        this.deleteFailed = deleteFailed;
    }

    public void setDeleteFinished(boolean deleteFinished) {
        this.deleteFinished = deleteFinished;
    }

    public void setDeleteOffline(boolean deleteOffline) {
        this.deleteOffline = deleteOffline;
    }

    public void setIgnoreFiltered(boolean ignoreFiltered) {
        this.ignoreFiltered = ignoreFiltered;
    }

    protected void update() {
        if (this.lastLink != null) {
            final PackageControllerTable.SelectionType selectionType = this.includedSelection.getSelectionType();
            DownloadsTable table = DownloadsTable.getInstance();
            table.getSelectionInfo(new PackageControllerTable.EDTSelectionInfoCallback<FilePackage, DownloadLink>(){
                {
                    GenericDeleteFromDownloadlistAction.this.lastCallBack = new WeakReference<5>(this);
                }

                @Override
                public boolean isCancelled() {
                    WeakReference<PackageControllerTable.SelectionInfoCallback> lastCallBack = GenericDeleteFromDownloadlistAction.this.lastCallBack;
                    return lastCallBack.get() != this;
                }

                @Override
                public void onSelectionInfo(SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
                    GenericDeleteFromDownloadlistAction.this.onUpdate(selectionType, selectionInfo);
                }
            }, selectionType);
        }
    }

    protected void onUpdate(PackageControllerTable.SelectionType selectionType, SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
        switch (selectionType) {
            case UNSELECTED: {
                DownloadLink lastDownloadLink = (DownloadLink)this.lastLink.get();
                if (lastDownloadLink != null && !selectionInfo.contains(lastDownloadLink) && this.checkLink(lastDownloadLink)) {
                    this.setEnabled(true);
                    return;
                }
                if (selectionInfo.getUnselectedChildren() != null) {
                    for (DownloadLink child : selectionInfo.getUnselectedChildren()) {
                        if (!this.checkLink(child)) continue;
                        this.setEnabled(true);
                        this.lastLink = new WeakReference<DownloadLink>(child);
                        return;
                    }
                }
                this.setEnabled(false);
                return;
            }
        }
        if (this.isDeleteAll() && !selectionInfo.isEmpty()) {
            this.setEnabled(true);
            return;
        }
        DownloadLink lastDownloadLink = (DownloadLink)this.lastLink.get();
        if (lastDownloadLink != null && !selectionInfo.contains(lastDownloadLink) && this.checkLink(lastDownloadLink)) {
            this.setEnabled(true);
            return;
        }
        for (DownloadLink child : selectionInfo.getChildren()) {
            if (!this.checkLink(child)) continue;
            this.lastLink = new WeakReference<DownloadLink>(child);
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper event) {
        this.delayer.resetAndStart();
    }
}

