/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.io.File;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;

public class OpenDirectoryAction
extends CustomizableTableContextAppAction<FilePackage, DownloadLink> {
    private static final long serialVersionUID = 3656369075540437063L;
    private volatile File directory = null;
    private volatile File file = null;
    private static final String NAME = _GUI.T.gui_table_contextmenu_downloaddir();

    public OpenDirectoryAction() {
        this.setIconKey("package_open");
        this.setName(NAME);
        this.setTooltipText("Open the current downloaddir in explorer");
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.file = null;
        this.directory = null;
        SelectionInfo selection = this.getSelection();
        if (this.hasSelection(selection)) {
            this.directory = new File(((FilePackage)selection.getFirstPackage()).getView().getDownloadDirectory());
            if (selection.isLinkContext()) {
                this.file = new File(((DownloadLink)selection.getContextLink()).getFileOutput());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            if (this.file != null) {
                CrossSystem.showInExplorer((File)this.file);
            } else {
                CrossSystem.openFile((File)this.getDirectory(this.directory));
            }
        }
    }

    private File getDirectory(File directory) {
        if (directory != null) {
            if (directory.exists()) {
                return directory;
            }
            if ((directory = directory.getParentFile()) != null && directory.exists()) {
                return directory;
            }
        }
        return null;
    }

    public boolean isEnabled() {
        if (CrossSystem.isOpenFileSupported()) {
            File lFile = this.file;
            if (lFile != null && lFile.exists()) {
                return true;
            }
            this.file = null;
            File lDirectory = this.getDirectory(this.directory);
            if (lDirectory != null && lDirectory.exists()) {
                this.directory = lDirectory;
                return true;
            }
            this.directory = null;
        }
        return false;
    }
}

