/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.io.File;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;

public class OpenFileAction
extends CustomizableTableContextAppAction<FilePackage, DownloadLink> {
    private static final long serialVersionUID = 1901008532686173167L;
    private File file = null;
    private static final String NAME = _GUI.T.gui_table_contextmenu_openfile();

    public OpenFileAction() {
        this.setIconKey("file");
        this.setName(NAME);
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        SelectionInfo selection = this.getSelection();
        this.file = null;
        if (this.hasSelection(selection)) {
            if (selection.isLinkContext()) {
                this.file = new File(((DownloadLink)selection.getContextLink()).getFileOutput());
            } else {
                this.file = new File(((FilePackage)selection.getFirstPackage()).getView().getDownloadDirectory());
                this.setVisible(false);
            }
        }
    }

    public OpenFileAction(File file) {
        this.file = file;
        this.setIconKey("file");
        this.setName(NAME);
    }

    public boolean isEnabled() {
        File lFile = this.file;
        return CrossSystem.isOpenFileSupported() && lFile != null && lFile.exists();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEnabled()) {
            File lFile = this.file;
            while (!lFile.exists()) {
                File p = lFile.getParentFile();
                if (p == null || p.equals(lFile)) {
                    return;
                }
                lFile = p;
            }
            CrossSystem.openFile((File)lFile);
        }
    }
}

