/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.util.List;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.context.SetDownloadFolderAction;

public class SetDownloadFolderInDownloadTableAction
extends SetDownloadFolderAction<FilePackage, DownloadLink> {
    private final SelectionInfo<FilePackage, DownloadLink> selection;

    public SetDownloadFolderInDownloadTableAction() {
        this(null);
    }

    public SetDownloadFolderInDownloadTableAction(SelectionInfo<FilePackage, DownloadLink> selectionInfo) {
        this.selection = selectionInfo;
        this.requestUpdate(this);
    }

    @Override
    protected SelectionInfo<FilePackage, DownloadLink> getSelection() {
        if (this.selection == null) {
            return super.getSelection();
        }
        return this.selection;
    }

    @Override
    protected void move(final FilePackage pkg, final List<DownloadLink> selectedLinksByPackage) {
        final FilePackage source = this.getSelection().getPackageViews().get(0).getPackage();
        DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                int index = DownloadController.getInstance().indexOf(source);
                DownloadController.getInstance().moveOrAddAt(pkg, (List<DownloadLink>)selectedLinksByPackage, -1, index);
                return null;
            }
        });
    }

    @Override
    protected FilePackage createNewByPrototype(SelectionInfo<FilePackage, DownloadLink> si, FilePackage entry) {
        FilePackage pkg = FilePackage.getInstance();
        pkg.setExpanded(true);
        pkg.setCreated(System.currentTimeMillis());
        pkg.setName(entry.getName());
        pkg.setComment(entry.getComment());
        pkg.setProperties(entry.getProperties());
        return pkg;
    }

    @Override
    protected void set(FilePackage pkg, String absolutePath) {
        DownloadWatchDog.getInstance().setDownloadDirectory(pkg, PackagizerController.replaceDynamicTags(absolutePath, pkg.getName(), pkg));
    }

    @Override
    protected Queue getQueue() {
        return DownloadController.getInstance().getQueue();
    }
}

