/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.Icon;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.download.DownloadInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.SizeFormatter;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.SkipReason;

public class SkipAction
extends CustomizableTableContextAppAction<FilePackage, DownloadLink> {
    private State state = State.MIXED;
    private SelectionInfo<FilePackage, DownloadLink> selection = null;
    private static final long serialVersionUID = 7107840091963427544L;
    private static final String NAME_UNSKIP = _GUI.T.ForceDownloadAction_UnskipDownloadAction();
    private static final String NAME_SKIP = _GUI.T.ForceDownloadAction_SkipDownloadAction();
    private static final Icon TRUE_TRUE = SkipAction.getCheckBoxedIcon("skipped", true, true);
    private static final Icon FALSE_TRUE = SkipAction.getCheckBoxedIcon("skipped", false, true);

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.selection = this.getSelection();
        if (this.hasSelection(this.selection)) {
            this.state = this.getState();
            switch (this.state) {
                case MIXED: {
                    this.setSmallIcon(TRUE_TRUE);
                    this.setName(NAME_UNSKIP);
                    break;
                }
                case ALL_UNSKIPPED: {
                    this.setSmallIcon(FALSE_TRUE);
                    this.setName(NAME_SKIP);
                    break;
                }
                case ALL_SKIPPED: {
                    this.setSmallIcon(TRUE_TRUE);
                    this.setName(NAME_UNSKIP);
                }
            }
        } else {
            this.setSmallIcon(FALSE_TRUE);
            this.setName(NAME_SKIP);
        }
    }

    public SkipAction() {
        this.setSmallIcon(TRUE_TRUE);
        this.setName(NAME_UNSKIP);
    }

    private State getState() {
        if (!this.hasSelection(this.selection)) {
            return State.ALL_UNSKIPPED;
        }
        Boolean first = null;
        for (DownloadLink a : this.selection.getChildren()) {
            if (first == null) {
                first = a.isSkipped();
            }
            if (a.isSkipped() == first.booleanValue()) continue;
            return State.MIXED;
        }
        return first != false ? State.ALL_SKIPPED : State.ALL_UNSKIPPED;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        final SelectionInfo lSelection = this.getSelection();
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (SkipAction.this.isEnabled()) {
                    boolean enable = SkipAction.this.state.equals((Object)State.ALL_UNSKIPPED);
                    if (enable) {
                        WarnLevel level;
                        int nonResumableDownloads = 0;
                        long estimatedLostDownloadedBytes = 0L;
                        if (DownloadWatchDog.getInstance().isRunning()) {
                            for (DownloadLink downloadLink : lSelection.getChildren()) {
                                DownloadInterface dl;
                                SingleDownloadController con = downloadLink.getDownloadLinkController();
                                if (con == null || (dl = con.getDownloadInstance()) == null || con.getDownloadLink().isResumeable()) continue;
                                ++nonResumableDownloads;
                                estimatedLostDownloadedBytes += Math.max(0L, con.getDownloadLink().getView().getBytesLoaded());
                            }
                        }
                        if (nonResumableDownloads > 0 && JDGui.bugme((WarnLevel)(level = estimatedLostDownloadedBytes > 0L ? WarnLevel.SEVERE : WarnLevel.LOW)) && !UIOManager.I().showConfirmDialog(32, _GUI.T.lit_are_you_sure(), _GUI.T.SkipAction_run_msg_(SizeFormatter.formatBytes((long)estimatedLostDownloadedBytes), nonResumableDownloads), (Icon)new AbstractIcon("skipped", 32), _GUI.T.lit_yes(), _GUI.T.lit_no(), "org.jdownloader.gui.views.downloads.action.SkipAction")) {
                            return null;
                        }
                    }
                    ArrayList<DownloadLink> unSkip = new ArrayList<DownloadLink>();
                    for (DownloadLink a : lSelection.getChildren()) {
                        if (enable) {
                            if (a.isSkipped()) continue;
                            a.setSkipReason(SkipReason.MANUAL);
                            continue;
                        }
                        unSkip.add(a);
                    }
                    DownloadWatchDog.getInstance().unSkip(unSkip);
                }
                return null;
            }
        });
    }

    public boolean isEnabled() {
        return super.isEnabled() && DownloadWatchDog.getInstance().isRunning();
    }

    static enum State {
        ALL_SKIPPED,
        ALL_UNSKIPPED,
        MIXED;

    }
}

