/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.bottombar;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jd.SecondLevelLaunch;
import jd.gui.swing.components.SetIconInterface;
import jd.gui.swing.components.SetLabelInterface;
import jd.gui.swing.jdgui.JDGui;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtJToggleButton;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.views.downloads.bottombar.AbstractBottomBarMenuManager;
import org.jdownloader.gui.views.downloads.bottombar.SelfComponentFactoryInterface;
import org.jdownloader.gui.views.downloads.bottombar.SelfLayoutInterface;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class CustomizeableActionBar
extends MigPanel {
    private final AbstractBottomBarMenuManager manager;

    public CustomizeableActionBar(AbstractBottomBarMenuManager bottomBarMenuManager) {
        super("ins 0 0 0 0,gap " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap(), "[]", "[]");
        this.setOpaque(false);
        this.manager = bottomBarMenuManager;
        this.manager.addLink(this);
        SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        CustomizeableActionBar.this.updateGui();
                    }
                };
            }
        });
    }

    public void updateGui() {
        if (!SecondLevelLaunch.EXTENSIONS_LOADED.isReached()) {
            return;
        }
        this.removeAll();
        MenuContainerRoot items = this.prepare(this.manager.getMenuData());
        this.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0, gap " + LAFOptions.getInstance().getExtension().customizeLayoutGetDefaultGap(), "[]", "[]"));
        MenuItemData last = null;
        for (MenuItemData menudata : items.getItems()) {
            try {
                if (!menudata.isVisible()) continue;
                if (menudata instanceof SeparatorData) {
                    if (last != null && last instanceof SeparatorData) continue;
                    this.add(new JSeparator(1), "gapleft 10,gapright 10,width 2!,pushy,growy");
                    last = menudata;
                    continue;
                }
                if (menudata._getValidateException() != null) continue;
                if (menudata.getType() == MenuItemData.Type.CONTAINER) {
                    this.addContainer(menudata);
                    continue;
                }
                if (menudata instanceof MenuLink) {
                    this.addLink(menudata);
                    continue;
                }
                if (menudata.getActionData() == null || !menudata.getActionData()._isValidDataForCreatingAnAction()) continue;
                this.addAction(menudata);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected MenuContainerRoot prepare(MenuContainerRoot menuData) {
        return menuData;
    }

    protected boolean isValid(MenuItemData menudata) {
        return true;
    }

    private void addLink(MenuItemData menudata) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException, ExtensionNotLoadedException {
        JComponent item = menudata.createItem(null);
        if (StringUtils.isNotEmpty((String)menudata.getIconKey()) && item instanceof SetIconInterface) {
            ((SetIconInterface)item).setIcon(NewTheme.I().getIcon(this.validateIconKey(menudata.getIconKey()), 20));
        }
        if (StringUtils.isNotEmpty((String)menudata.getName()) && item instanceof SetLabelInterface) {
            ((SetLabelInterface)item).setText(menudata.getName());
        }
        if (menudata instanceof SelfLayoutInterface) {
            this.add(item, ((SelfLayoutInterface)((Object)menudata)).createConstraints());
        } else {
            this.add(item, "height 24!");
        }
    }

    private void addAction(MenuItemData menudata) throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExtensionNotLoadedException {
        JComponent bt;
        CustomizableAppAction action = menudata.createAction();
        if (!action.isVisible()) {
            return;
        }
        if (StringUtils.isNotEmpty((String)menudata.getShortcut())) {
            action.setAccelerator(KeyStroke.getKeyStroke(menudata.getShortcut()));
        } else if (MenuItemData.isEmptyValue(menudata.getShortcut())) {
            action.setAccelerator(null);
        }
        if (action instanceof SelfComponentFactoryInterface) {
            action.requestUpdate((Object)this);
            bt = ((SelfComponentFactoryInterface)((Object)action)).createComponent();
        } else if (action.isToggle()) {
            action.requestUpdate((Object)this);
            bt = new ExtJToggleButton((AbstractAction)((Object)action));
        } else {
            action.requestUpdate((Object)this);
            bt = new ExtButton((AbstractAction)((Object)action));
        }
        action.addVisibilityPropertyChangeListener(bt);
        bt.setEnabled(action.isEnabled());
        if (action instanceof SelfLayoutInterface) {
            this.add(bt, ((SelfLayoutInterface)((Object)action)).createConstraints());
        } else if (menudata instanceof SelfLayoutInterface) {
            this.add(bt, ((SelfLayoutInterface)((Object)menudata)).createConstraints());
        } else if (StringUtils.isEmpty((String)action.getName())) {
            this.add(bt, "height 24!,width 24!,aligny top");
        } else {
            this.add(bt, "height 24!,aligny top");
        }
    }

    private void addContainer(MenuItemData menudata) {
        if (StringUtils.isEmpty((String)menudata.getName()) && StringUtils.isEmpty((String)this.validateIconKey(menudata.getIconKey()))) {
            ExtButton bt = new ExtButton((AbstractAction)((Object)this.createPopupAction(menudata, this.getComponentCount() > 0 ? this.getComponent(this.getComponentCount() - 1) : null))){
                private static final long serialVersionUID = 1L;

                public void setBounds(int x, int y, int width, int height) {
                    Rectangle bounds = new Rectangle(x, y, width, height);
                    LAFOptions.getInstance().getExtension().customizeBoundsForBottombarPopupButton(bounds);
                    super.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                }
            };
            this.add((Component)bt, "height 24!,width 12!,aligny top");
        } else {
            AppAction action = this.createPopupAction(menudata, null);
            ExtButton bt = new ExtButton((AbstractAction)((Object)action));
            if (StringUtils.isEmpty((String)menudata.getName())) {
                this.add((Component)bt, "height 24!,width " + Math.max(24, action.getSmallIcon().getIconWidth() + 6) + "!,aligny top");
            } else {
                this.add((Component)bt, "height 24!,aligny top");
            }
        }
    }

    private String validateIconKey(String iconKey) {
        if (MenuItemData.isEmptyValue(iconKey)) {
            return "";
        }
        if (StringUtils.isEmpty((String)iconKey)) {
            return "";
        }
        return iconKey;
    }

    protected ImageIcon createDropdownImage(boolean b, Image back) {
        Image front = NewTheme.I().getImage(b ? "popUpSmall" : "popDownSmall", -1);
        int w = back.getWidth(null);
        int h = back.getHeight(null);
        int xoffsetBack = 0;
        int yoffsetBack = 0;
        int xoffsetFront = back.getWidth(null) + front.getWidth(null) + 1;
        int yoffsetFront = (back.getHeight(null) - front.getHeight(null)) / 2;
        int width = Math.max(xoffsetBack + back.getWidth(null), xoffsetFront + front.getWidth(null));
        int height = Math.max(yoffsetBack + back.getHeight(null), yoffsetFront + front.getHeight(null));
        BufferedImage dest = IconIO.createEmptyImage((int)(width + 2), (int)height);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(back, xoffsetBack, yoffsetBack, null);
        g2.drawImage(front, xoffsetFront, yoffsetFront, null);
        g2.setStroke(new BasicStroke(1.0f, 1, 1));
        g2.setColor(new Color(0, 0, 0, 50));
        g2.drawLine(w + 1, 0, w + 1, h);
        g2.setColor(new Color(255, 255, 255, 50));
        g2.drawLine(w + 2, 0, w + 2, h);
        g2.dispose();
        return new ImageIcon(dest);
    }

    private AppAction createPopupAction(final MenuItemData menudata, final Component reference) {
        return new AppAction(){
            private Component positionComp;
            private ExtPopupMenu popup;
            private long lastHide = 0L;
            {
                this.updateIcon(true);
                this.setName(menudata.getName());
                this.setTooltipText(menudata.getName());
                this.positionComp = reference;
            }

            public void actionPerformed(ActionEvent e) {
                long timeSinceLastHide = System.currentTimeMillis() - this.lastHide;
                if (timeSinceLastHide < 250L) {
                    return;
                }
                this.popup = new ExtPopupMenu(){

                    @Override
                    public void setVisible(boolean b) {
                        super.setVisible(b);
                        if (!b) {
                            lastHide = System.currentTimeMillis();
                            this.updateIcon(true);
                        } else {
                            this.updateIcon(false);
                        }
                    }
                };
                new MenuBuilder(CustomizeableActionBar.this.manager, this.popup, (MenuContainer)menudata){

                    @Override
                    protected void addAction(JComponent root, MenuItemData inst, int index, int size) throws InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, ExtensionNotLoadedException {
                        super.addAction(root, inst, index, size);
                    }
                }.run();
                Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
                Dimension pref = this.popup.getPreferredSize();
                this.popup.setPreferredSize(pref);
                Component refComponent = this.positionComp == null ? (Component)e.getSource() : this.positionComp;
                Point loc = refComponent.getLocation();
                Point converted = SwingUtilities.convertPoint(refComponent, loc, (Component)JDGui.getInstance().getMainFrame());
                if (converted.x > JDGui.getInstance().getMainFrame().getWidth() / 2) {
                    this.popup.show((Component)e.getSource(), -this.popup.getPreferredSize().width + insets.right + ((Component)e.getSource()).getWidth() + 1, -this.popup.getPreferredSize().height + insets.bottom);
                } else {
                    this.popup.show(refComponent, -insets.left - 1, -this.popup.getPreferredSize().height + insets.bottom);
                }
            }

            private void updateIcon(boolean b) {
                if (StringUtils.isEmpty((String)CustomizeableActionBar.this.validateIconKey(menudata.getIconKey()))) {
                    this.setSmallIcon(NewTheme.I().getIcon(b ? "popUpSmall" : "popDownSmall", -1));
                } else {
                    this.setSmallIcon(CustomizeableActionBar.this.createDropdownImage(b, NewTheme.I().getImage(CustomizeableActionBar.this.validateIconKey(menudata.getIconKey()), 18)));
                }
            }
        };
    }
}

