/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.bottombar;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginProgress;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.DomainInfo;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.LinktablesSearchCategory;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.gui.views.components.packagetable.SearchField;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public final class DownloadsTableSearchField
extends SearchField<LinktablesSearchCategory, FilePackage, DownloadLink> {
    protected static DownloadsTableSearchField INSTANCE;

    public DownloadsTableSearchField(PackageControllerTable<FilePackage, DownloadLink> table2Filter, LinktablesSearchCategory defCategory) {
        super(table2Filter, defCategory);
        this.setCategories(new LinktablesSearchCategory[]{LinktablesSearchCategory.FILENAME, LinktablesSearchCategory.FILEPATH, LinktablesSearchCategory.HOSTER, LinktablesSearchCategory.PACKAGE, LinktablesSearchCategory.COMMENT, LinktablesSearchCategory.COMMENT_PACKAGE, LinktablesSearchCategory.STATUS});
        this.setSelectedCategory(((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getSelectedDownloadSearchCategory());
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DownloadsTableSearchField.this.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    @Override
    public void setSelectedCategory(LinktablesSearchCategory selectedCategory) {
        super.setSelectedCategory(selectedCategory);
        ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setSelectedDownloadSearchCategory(selectedCategory);
    }

    @Override
    protected PackageControllerTableModelFilter<FilePackage, DownloadLink> getFilter(final List<Pattern> pattern, LinktablesSearchCategory searchCat) {
        if (searchCat == null || pattern == null || pattern.size() == 0) {
            return null;
        }
        switch (searchCat) {
            case PACKAGE: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return true;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(DownloadLink v) {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(FilePackage e) {
                        String name = e.getName();
                        return !DownloadsTableSearchField.this.isMatching(pattern, name);
                    }

                    @Override
                    public int getComplexity() {
                        return 0;
                    }
                };
            }
            case FILENAME: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return true;
                    }

                    @Override
                    public boolean isFiltered(DownloadLink v) {
                        String name = v.getView().getDisplayName();
                        return !DownloadsTableSearchField.this.isMatching(pattern, name);
                    }

                    @Override
                    public boolean isFiltered(FilePackage e) {
                        return false;
                    }

                    @Override
                    public int getComplexity() {
                        return 0;
                    }
                };
            }
            case FILEPATH: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return true;
                    }

                    @Override
                    public boolean isFiltered(DownloadLink v) {
                        File directory = LinkTreeUtils.getDownloadDirectory(v);
                        return directory == null || !DownloadsTableSearchField.this.isMatching(pattern, new File(directory, v.getName()).toString());
                    }

                    @Override
                    public boolean isFiltered(FilePackage e) {
                        return false;
                    }

                    @Override
                    public int getComplexity() {
                        return 0;
                    }
                };
            }
            case COMMENT: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return true;
                    }

                    @Override
                    public boolean isFiltered(DownloadLink v) {
                        String comment = v.getComment();
                        if (comment == null) {
                            comment = "";
                        }
                        return !DownloadsTableSearchField.this.isMatching(pattern, comment);
                    }

                    @Override
                    public boolean isFiltered(FilePackage fp) {
                        return false;
                    }

                    @Override
                    public int getComplexity() {
                        return 1;
                    }
                };
            }
            case COMMENT_PACKAGE: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return true;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(DownloadLink v) {
                        return false;
                    }

                    @Override
                    public boolean isFiltered(FilePackage fp) {
                        String comment = fp.getComment();
                        if (comment == null) {
                            comment = "";
                        }
                        return !DownloadsTableSearchField.this.isMatching(pattern, comment);
                    }

                    @Override
                    public int getComplexity() {
                        return 1;
                    }
                };
            }
            case HOSTER: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){
                    private final WeakHashMap<DomainInfo, Boolean> fastCheck = new WeakHashMap();

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return true;
                    }

                    @Override
                    public synchronized boolean isFiltered(DownloadLink v) {
                        DomainInfo domainInfo = v.getDomainInfo();
                        String host = domainInfo.getDomain();
                        Boolean ret = this.fastCheck.get(host);
                        if (ret != null) {
                            return ret;
                        }
                        if (DownloadsTableSearchField.this.isMatching(pattern, host)) {
                            this.fastCheck.put(domainInfo, Boolean.FALSE);
                            return false;
                        }
                        this.fastCheck.put(domainInfo, Boolean.TRUE);
                        return true;
                    }

                    @Override
                    public boolean isFiltered(FilePackage e) {
                        return false;
                    }

                    @Override
                    public int getComplexity() {
                        return 0;
                    }
                };
            }
            case STATUS: {
                return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                    @Override
                    public boolean isFilteringPackageNodes() {
                        return false;
                    }

                    @Override
                    public boolean isFilteringChildrenNodes() {
                        return true;
                    }

                    @Override
                    public synchronized boolean isFiltered(DownloadLink link) {
                        PluginProgress prog = link.getPluginProgress();
                        if (prog != null) {
                            String txt = prog.getMessage((Object)DownloadsTableModel.getInstance().getTaskColumn());
                            for (Pattern filterPattern : pattern) {
                                if (!filterPattern.matcher(txt).find()) continue;
                                return false;
                            }
                            return true;
                        }
                        ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
                        if (conditionalSkipReason != null && !conditionalSkipReason.isConditionReached()) {
                            String txt = conditionalSkipReason.getMessage((Object)DownloadsTableModel.getInstance().getTaskColumn(), null);
                            for (Pattern filterPattern : pattern) {
                                if (!filterPattern.matcher(txt).find()) continue;
                                return false;
                            }
                            return true;
                        }
                        SkipReason skipReason = link.getSkipReason();
                        if (skipReason != null) {
                            String txt = skipReason.getExplanation((Object)DownloadsTableModel.getInstance().getTaskColumn(), link);
                            for (Pattern filterPattern : pattern) {
                                if (!filterPattern.matcher(txt).find()) continue;
                                return false;
                            }
                            return true;
                        }
                        FinalLinkState finalLinkState = link.getFinalLinkState();
                        if (finalLinkState != null) {
                            if (FinalLinkState.CheckFailed(finalLinkState)) {
                                String txt = finalLinkState.getExplanation((Object)DownloadsTableModel.getInstance().getTaskColumn(), link);
                                for (Pattern filterPattern : pattern) {
                                    if (!filterPattern.matcher(txt).find()) continue;
                                    return false;
                                }
                                return true;
                            }
                            ExtractionStatus extractionStatus = link.getExtractionStatus();
                            if (extractionStatus != null) {
                                switch (extractionStatus) {
                                    case ERROR: 
                                    case ERROR_PW: 
                                    case ERROR_CRC: 
                                    case ERROR_NOT_ENOUGH_SPACE: 
                                    case ERRROR_FILE_NOT_FOUND: {
                                        String txt = extractionStatus.getExplanation();
                                        for (Pattern filterPattern : pattern) {
                                            if (!filterPattern.matcher(txt).find()) continue;
                                            return false;
                                        }
                                        return true;
                                    }
                                    case SUCCESSFUL: {
                                        String txt = extractionStatus.getExplanation();
                                        for (Pattern filterPattern : pattern) {
                                            if (!filterPattern.matcher(txt).find()) continue;
                                            return false;
                                        }
                                        return true;
                                    }
                                    case RUNNING: {
                                        String txt = extractionStatus.getExplanation();
                                        for (Pattern filterPattern : pattern) {
                                            if (!filterPattern.matcher(txt).find()) continue;
                                            return false;
                                        }
                                        return true;
                                    }
                                }
                            }
                            String txt = finalLinkState.getExplanation(this, link);
                            for (Pattern filterPattern : pattern) {
                                if (!filterPattern.matcher(txt).find()) continue;
                                return false;
                            }
                            return true;
                        }
                        if (link.getDownloadLinkController() != null) {
                            String txt = _GUI.T.TaskColumn_fillColumnHelper_starting();
                            for (Pattern filterPattern : pattern) {
                                if (!filterPattern.matcher(txt).find()) continue;
                                return false;
                            }
                            return true;
                        }
                        return true;
                    }

                    @Override
                    public boolean isFiltered(FilePackage e) {
                        return false;
                    }

                    @Override
                    public int getComplexity() {
                        return 0;
                    }
                };
            }
        }
        return null;
    }

    public static DownloadsTableSearchField getInstance() {
        return (DownloadsTableSearchField)new EDTHelper<DownloadsTableSearchField>(){

            public DownloadsTableSearchField edtRun() {
                if (INSTANCE != null) {
                    return INSTANCE;
                }
                INSTANCE = new DownloadsTableSearchField(DownloadsTableModel.getInstance().getTable(), LinktablesSearchCategory.FILENAME);
                return INSTANCE;
            }
        }.getReturnValue();
    }
}

