/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.bottombar;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.PseudoCombo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelFilter;
import org.jdownloader.gui.views.downloads.View;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class QuickFilterMenuItem
extends MenuItemData
implements MenuLink {
    @Override
    public JComponent createSettingsPanel() {
        return null;
    }

    @Override
    public List<AppAction> createActionsToLink() {
        return null;
    }

    public QuickFilterMenuItem() {
        this.setName(_GUI.T.QuickFilterMenuItem_QuickFilterMenuItem());
        this.setIconKey("filter");
        this.setVisible(true);
    }

    @Override
    public JComponent createItem(MenuBuilder menuBuilder) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException, ExtensionNotLoadedException {
        return FilterCombo.getInstance();
    }

    public static final class FilterCombo
    extends PseudoCombo<View> {
        private final DownloadsTable table;
        protected static FilterCombo INSTANCE;
        private NullsafeAtomicReference<PackageControllerTableModelFilter<FilePackage, DownloadLink>> appliedFilter = new NullsafeAtomicReference(null);

        public static FilterCombo getInstance() {
            return (FilterCombo)new EDTHelper<FilterCombo>(){

                public FilterCombo edtRun() {
                    if (INSTANCE != null) {
                        return INSTANCE;
                    }
                    INSTANCE = new FilterCombo();
                    return INSTANCE;
                }
            }.getReturnValue();
        }

        @Override
        protected boolean isHideSelf() {
            return false;
        }

        @Override
        protected Icon getIcon(View v, boolean closed) {
            return v.getIcon();
        }

        @Override
        protected String getLabel(View v, boolean closed) {
            return v.getLabel();
        }

        private FilterCombo() {
            super(new View[]{View.ALL, View.RUNNING, View.FAILED, View.EXISTS, View.OFFLINE, View.SKIPPED, View.SUCCESSFUL, View.TODO});
            this.setToolTipText(_GUI.T.PseudoCombo_PseudoCombo_tt_());
            this.table = (DownloadsTable)DownloadsTableModel.getInstance().getTable();
            View view = (View)((Object)CFG_GUI.DOWNLOAD_VIEW.getValue());
            if (view == null || !((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isSaveDownloadViewCrossSessionEnabled()) {
                view = View.ALL;
            }
            this.setSelectedItem(view);
        }

        @Override
        public void onChanged(View value) {
            PackageControllerTableModelFilter<FilePackage, DownloadLink> newFilter = this.getFilter(value);
            PackageControllerTableModelFilter oldFilter = (PackageControllerTableModelFilter)this.appliedFilter.getAndSet(newFilter);
            if (oldFilter != null) {
                this.table.getModel().removeFilter(oldFilter);
            }
            if (newFilter != null) {
                this.table.getModel().addFilter(newFilter);
            }
            this.table.getModel().recreateModel(true);
            CFG_GUI.DOWNLOAD_VIEW.setValue((Object)value);
        }

        private PackageControllerTableModelFilter<FilePackage, DownloadLink> getFilter(View value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case ALL: {
                    return null;
                }
                case SKIPPED: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return v.getSkipReason() == null;
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case FAILED: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return !FinalLinkState.CheckFailed(v.getFinalLinkState());
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case EXISTS: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return !FinalLinkState.FAILED_EXISTS.equals((Object)v.getFinalLinkState()) && !SkipReason.FILE_EXISTS.equals((Object)v.getSkipReason());
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case OFFLINE: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return FinalLinkState.OFFLINE != v.getFinalLinkState();
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case RUNNING: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return !v.isEnabled() || v.getDownloadLinkController() == null;
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case SUCCESSFUL: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return !FinalLinkState.CheckFinished(v.getFinalLinkState());
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
                case TODO: {
                    return new PackageControllerTableModelFilter<FilePackage, DownloadLink>(){

                        @Override
                        public boolean isFilteringPackageNodes() {
                            return false;
                        }

                        @Override
                        public boolean isFilteringChildrenNodes() {
                            return true;
                        }

                        @Override
                        public boolean isFiltered(DownloadLink v) {
                            return v.getFinalLinkState() != null || v.getDownloadLinkController() != null;
                        }

                        @Override
                        public boolean isFiltered(FilePackage e) {
                            return false;
                        }

                        @Override
                        public int getComplexity() {
                            return 0;
                        }
                    };
                }
            }
            return null;
        }
    }
}

