/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.ChildrenView;
import jd.plugins.DownloadLink;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class AvailabilityColumn
extends ExtTextColumn<AbstractNode>
implements GenericConfigEventListener<Boolean> {
    private static final long serialVersionUID = 1L;
    private final String nothing = "";
    private final Icon unknown;
    private final Icon online;
    private final Icon offline;
    private final Icon mixed;
    private ColumnHelper columnHelper = new ColumnHelper();
    private boolean textVisible;

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public AvailabilityColumn() {
        super(_GUI.T.AvailabilityColumn_AvailabilityColumn());
        this.unknown = NewTheme.I().getIcon("help", 16);
        this.online = NewTheme.I().getIcon("true", 16);
        this.mixed = NewTheme.I().getIcon("true-orange", 16);
        this.offline = NewTheme.I().getIcon("error", 16);
        CFG_GUI.AVAILABLE_COLUMN_TEXT_VISIBLE.getEventSender().addListener((EventListener)((Object)this), true);
        this.textVisible = CFG_GUI.CFG.isAvailableColumnTextVisible();
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                String o1s = AvailabilityColumn.this.getTooltipText(o1);
                String o2s = AvailabilityColumn.this.getTooltipText(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (o1s.matches("[0-9]*\\/[0-9]* .*") && o2s.matches("[0-9]*\\/[0-9]* .*")) {
                    int o1i = Integer.parseInt(o1s.split("/")[0]);
                    int o2i = Integer.parseInt(o2s.split("/")[0]);
                    if (this.getSortOrderIdentifier() != "ASC") {
                        return o1i < o2i ? -1 : 1;
                    }
                    return o1i > o2i ? -1 : 1;
                }
                return o1s.compareTo(o2s);
            }
        });
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    protected void prepareColumn(AbstractNode value) {
        if (value instanceof DownloadLink) {
            this.columnHelper.string = null;
            DownloadLink.AvailableStatus status = ((DownloadLink)value).getAvailableStatus();
            if (status == null) {
                status = DownloadLink.AvailableStatus.UNCHECKED;
            }
            if (this.textVisible) {
                this.columnHelper.string = status.getExplanation();
            }
            switch (status) {
                case TRUE: {
                    this.columnHelper.icon = this.online;
                    return;
                }
                case FALSE: {
                    this.columnHelper.icon = this.offline;
                    return;
                }
            }
            this.columnHelper.icon = this.unknown;
            return;
        }
        if (value instanceof AbstractPackageNode) {
            ChildrenView view = ((AbstractPackageNode)value).getView();
            this.columnHelper.string = view.getMessage((Object)this);
            switch (view.getAvailability()) {
                case MIXED: {
                    this.columnHelper.icon = this.mixed;
                    return;
                }
                case OFFLINE: {
                    this.columnHelper.icon = this.offline;
                    return;
                }
                case ONLINE: {
                    this.columnHelper.icon = this.online;
                    return;
                }
                case UNKNOWN: {
                    this.columnHelper.icon = this.unknown;
                    return;
                }
            }
        } else if (value instanceof CrawledLink) {
            this.columnHelper.string = null;
            DownloadLink dl = ((CrawledLink)value).getDownloadLink();
            if (dl != null) {
                DownloadLink.AvailableStatus status = dl.getAvailableStatus();
                if (status == null) {
                    status = DownloadLink.AvailableStatus.UNCHECKED;
                }
                if (this.textVisible) {
                    this.columnHelper.string = status.getExplanation();
                }
                switch (status) {
                    case TRUE: {
                        this.columnHelper.icon = this.online;
                        return;
                    }
                    case FALSE: {
                        this.columnHelper.icon = this.offline;
                        return;
                    }
                }
                this.columnHelper.icon = this.unknown;
                return;
            }
            this.columnHelper.icon = this.unknown;
            return;
        }
    }

    protected Icon getIcon(AbstractNode value) {
        return this.columnHelper.icon;
    }

    protected String getTooltipText(AbstractNode value) {
        if (value instanceof DownloadLink) {
            DownloadLink.AvailableStatus status = ((DownloadLink)value).getAvailableStatus();
            if (status != null) {
                return status.getExplanation();
            }
            return DownloadLink.AvailableStatus.UNCHECKED.getExplanation();
        }
        if (value instanceof CrawledLink) {
            CrawledLink cl = (CrawledLink)value;
            DownloadLink dl = cl.getDownloadLink();
            if (dl != null) {
                DownloadLink.AvailableStatus status = dl.getAvailableStatus();
                if (status != null) {
                    return status.getExplanation();
                }
                return DownloadLink.AvailableStatus.UNCHECKED.getExplanation();
            }
        } else if (value instanceof AbstractPackageNode) {
            ChildrenView view = ((AbstractPackageNode)value).getView();
            return view.getMessage((Object)this);
        }
        return null;
    }

    public int getDefaultWidth() {
        return 100;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    public int getMinWidth() {
        return -1;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public String getStringValue(AbstractNode value) {
        return this.columnHelper.string;
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        this.textVisible = CFG_GUI.CFG.isAvailableColumnTextVisible();
    }

    private class ColumnHelper {
        private Icon icon = null;
        private String string = null;

        private ColumnHelper() {
        }
    }
}

