/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.GUIUtils;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltip;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;

public class CandidateAccountColumn
extends ExtTextColumn<AbstractNode> {
    private final Icon iconDownload = NewTheme.I().getIcon("download", 20);

    public CandidateAccountColumn() {
        super(_GUI.T.CandidateAccountColumn());
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public int getDefaultWidth() {
        return 200;
    }

    public ExtTooltip createToolTip(Point position, AbstractNode obj) {
        return CandidateTooltip.create(position, obj);
    }

    public boolean onDoubleClick(final MouseEvent e, final AbstractNode obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<HistoryEntry> his;
                if (obj instanceof DownloadLink && (his = ((DownloadLink)obj).getHistory()) != null) {
                    ToolTipController.getInstance().show((ExtTooltip)CandidateTooltip.create(e.getPoint(), obj));
                }
            }
        });
        return true;
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        DownloadLink dl;
        HistoryEntry history;
        if (value instanceof DownloadLink && (history = (dl = (DownloadLink)value).getLatestHistoryEntry()) != null) {
            Object icon = history.getAccountIcon(18);
            String str = history.getAccountStatus();
            Account account = history.getAccount();
            if (account != null) {
                icon = icon == null ? account.getDomainInfo() : new BadgeIcon(account.getDomainInfo(), IconIO.getScaledInstance((Icon)icon, (int)12, (int)12), 4, 2);
                String accountType = null;
                switch (history.getAccountType()) {
                    case MULTI: {
                        accountType = _GUI.T.CandidateAccountColumn_account_multi(account.getType().getLabel());
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case ORIGINAL: {
                        accountType = _GUI.T.CandidateAccountColumn_account_original(account.getType().getLabel());
                    }
                }
                str = !StringUtils.isEmpty(accountType) ? _GUI.T.CandidateAccountColumn_getStringValue_account_type(GUIUtils.getAccountName((String)account.getUser()), account.getHosterByPlugin(), accountType) : _GUI.T.CandidateAccountColumn_getStringValue_account(GUIUtils.getAccountName((String)account.getUser()), account.getHosterByPlugin());
            } else {
                icon = icon == null ? dl.getDomainInfo().getFavIcon() : new BadgeIcon(dl.getDomainInfo(), IconIO.getScaledInstance((Icon)icon, (int)12, (int)12), 4, 2);
            }
            if (str == null) {
                str = "";
            }
            this.rendererIcon.setIcon((Icon)icon);
            if (this.getTableColumn() != null) {
                try {
                    this.rendererField.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this.rendererField, (FontMetrics)this.rendererField.getFontMetrics(this.rendererField.getFont()), (String)str, (int)(this.getTableColumn().getWidth() - this.rendererIcon.getPreferredSize().width - 5)));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.rendererField.setText(str);
                }
            } else {
                this.rendererField.setText(str);
            }
            return;
        }
        super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
    }

    public String getStringValue(AbstractNode value) {
        return null;
    }
}

