/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SelectedProxy;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.gui.swing.jdgui.GUIUtils;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadInterface;
import net.miginfocom.swing.MigLayout;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.SkipReason;

public class ConnectionColumn
extends ExtColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private MigPanel panel = new RendererMigPanel("ins 0 0 0 0", "[]", "[grow,fill]");
    private RenderLabel[] labels = new RenderLabel[7];
    private final Icon resumeIndicator;
    private final Icon directConnection;
    private final Icon proxyConnection;
    private final Icon connections;
    private final int labelsSize = 6;
    private final Icon skipped;
    private final Icon forced;
    private final Icon tls;
    private DownloadWatchDog dlWatchdog;
    private final Icon url;
    private static final AtomicLong TASK = new AtomicLong(0L);
    private static final ScheduledExecutorService SCHEDULER = DelayedRunnable.getNewScheduledExecutorService();

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup(this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public ConnectionColumn() {
        super(_GUI.T.ConnectionColumn_ConnectionColumn(), null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new RenderLabel();
            this.labels[i].setOpaque(false);
            this.labels[i].setBackground(null);
            if (sb.length() > 0) {
                sb.append("1");
            }
            sb.append("[18!]");
            this.panel.add((Component)this.labels[i]);
        }
        this.dlWatchdog = DownloadWatchDog.getInstance();
        this.skipped = NewTheme.I().getIcon("skipped", 16);
        this.forced = NewTheme.I().getIcon("media-playback-start_forced", 16);
        this.resumeIndicator = NewTheme.I().getIcon("refresh", 16);
        this.directConnection = NewTheme.I().getIcon("modem", 16);
        this.proxyConnection = NewTheme.I().getIcon("proxy_rotate", 16);
        this.connections = NewTheme.I().getIcon("chunks", 16);
        this.tls = NewTheme.I().getIcon("info", 16);
        this.url = NewTheme.I().getIcon("url", 16);
        this.panel.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0", sb.toString(), "[grow,fill]"));
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                long l2;
                long l1 = ConnectionColumn.this.getDownloads(o1);
                if (l1 == (l2 = (long)ConnectionColumn.this.getDownloads(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return l1 > l2 ? -1 : 1;
                }
                return l1 < l2 ? -1 : 1;
            }
        });
        this.resetRenderer();
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        return super.onSingleClick(e, (Object)obj);
    }

    public boolean onDoubleClick(MouseEvent e, AbstractNode obj) {
        if (obj instanceof DownloadLink) {
            ConnectionTooltip tt = new ConnectionTooltip((DownloadLink)obj){

                public boolean isLastHiddenEnabled() {
                    return false;
                }
            };
            ToolTipController.getInstance().show((ExtTooltip)tt);
            return true;
        }
        return false;
    }

    private int getDownloads(AbstractNode value) {
        if (value instanceof DownloadLink) {
            DownloadInterface dli;
            SingleDownloadController dlc = ((DownloadLink)value).getDownloadLinkController();
            if (dlc != null && (dli = dlc.getDownloadInstance()) != null) {
                return 1;
            }
        } else if (value instanceof FilePackage) {
            return DownloadWatchDog.getInstance().getDownloadsbyFilePackage((FilePackage)value);
        }
        return 0;
    }

    public Object getCellEditorValue() {
        return null;
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof DownloadLink) {
            return ((DownloadLink)obj).isEnabled();
        }
        return false;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public void setValue(Object value, AbstractNode object) {
    }

    public int getDefaultWidth() {
        return 128;
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof DownloadLink) {
            DownloadLink dlLink = (DownloadLink)value;
            SingleDownloadController sdc = dlLink.getDownloadLinkController();
            DownloadInterface dli = sdc != null ? sdc.getDownloadInstance() : null;
            int labelIndex = 0;
            if (dlLink.isSkipped()) {
                this.labels[labelIndex].setIcon(this.skipped);
                this.labels[labelIndex].setVisible(true);
                ++labelIndex;
            }
            if (this.dlWatchdog.isLinkForced(dlLink) && dlLink.getFinalLinkState() == null && dlLink.isEnabled()) {
                this.labels[labelIndex].setIcon(this.forced);
                this.labels[labelIndex].setVisible(true);
                ++labelIndex;
            }
            if (dlLink.isResumeable() && dlLink.getFinalLinkState() == null) {
                this.labels[labelIndex].setIcon(this.resumeIndicator);
                this.labels[labelIndex].setVisible(true);
                ++labelIndex;
            }
            if (dli != null && sdc != null) {
                HTTPProxy proxy = sdc.getUsedProxy();
                if (proxy != null && proxy.isRemote()) {
                    this.labels[labelIndex].setIcon(this.proxyConnection);
                    this.labels[labelIndex].setVisible(true);
                } else {
                    this.labels[labelIndex].setIcon(this.directConnection);
                    this.labels[labelIndex].setVisible(true);
                }
                ++labelIndex;
                if (sdc.getAccount() != null && sdc.getAccount().getPlugin() != null) {
                    PluginForHost plugin = sdc.getAccount().getPlugin();
                    DomainInfo domainInfo = DomainInfo.getInstance(plugin.getHost(dlLink, sdc.getAccount(), false));
                    if (domainInfo != null) {
                        Icon icon = domainInfo.getFavIcon();
                        this.labels[labelIndex].setIcon(icon);
                        this.labels[labelIndex].setVisible(true);
                        ++labelIndex;
                    }
                } else {
                    PluginForHost plugin = sdc.getProcessingPlugin();
                    DomainInfo domainInfo = plugin != null ? DomainInfo.getInstance(sdc.getProcessingPlugin().getHost(dlLink, sdc.getAccount(), false)) : null;
                    Icon icon = domainInfo != null ? domainInfo.getFavIcon() : this.url;
                    this.labels[labelIndex].setIcon(icon);
                    this.labels[labelIndex].setVisible(true);
                    ++labelIndex;
                }
                this.labels[labelIndex].setText("" + dli.getManagedConnetionHandler().size());
                this.labels[labelIndex].setIcon(this.connections);
                this.labels[labelIndex].setVisible(true);
            }
        }
    }

    public JComponent getEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        return null;
    }

    public JComponent getRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.panel;
    }

    public void resetEditor() {
    }

    public ExtTooltip createToolTip(Point position, AbstractNode obj) {
        ConnectionTooltip ret;
        if (obj instanceof DownloadLink && (ret = new ConnectionTooltip((DownloadLink)obj)).getComponentCount() > 0) {
            return ret;
        }
        return null;
    }

    public void resetRenderer() {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setVisible(false);
            this.labels[i].setText(null);
        }
        this.panel.setOpaque(false);
        this.panel.setBackground(null);
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
    }

    private class ConnectionTooltip
    extends ExtTooltip {
        private static final long serialVersionUID = -6581783135666367021L;

        public ConnectionTooltip(DownloadLink link) {
            Icon icon;
            PluginForHost plugin;
            DomainInfo domainInfo;
            SkipReason skipReason;
            this.panel = new TooltipPanel("ins 3,wrap 1", "[grow,fill]", "[grow,fill]");
            SingleDownloadController sdc = link.getDownloadLinkController();
            DownloadInterface dli = sdc != null ? sdc.getDownloadInstance() : null;
            if (ConnectionColumn.this.dlWatchdog.isLinkForced(link) && link.getFinalLinkState() == null && link.isEnabled()) {
                if (dli == null) {
                    this.add(new JLabel(_GUI.T.ConnectionColumn_DownloadIsForcedWaiting(), ConnectionColumn.this.forced, 10));
                } else {
                    this.add(new JLabel(_GUI.T.ConnectionColumn_DownloadIsForced(), ConnectionColumn.this.forced, 10));
                }
            }
            if ((skipReason = link.getSkipReason()) != null) {
                this.add(new JLabel(skipReason.getExplanation((Object)ConnectionColumn.this, link), ConnectionColumn.this.skipped, 10));
            }
            if (link.isResumeable() && link.getFinalLinkState() == null) {
                this.add(new JLabel(_GUI.T.ConnectionColumn_DownloadIsResumeable(), ConnectionColumn.this.resumeIndicator, 10));
            }
            if (sdc != null) {
                HTTPProxy proxy = sdc.getUsedProxy() == null ? HTTPProxy.NONE : sdc.getUsedProxy();
                SelectedProxy selectedProxy = ProxyController.getSelectedProxy(proxy);
                final String proxyString = selectedProxy != null && selectedProxy.getSelector() != null ? (selectedProxy.getSelector() instanceof PacProxySelectorImpl ? selectedProxy.getSelector().toDetailsString() + "@" + proxy.toString() : selectedProxy.getSelector().toDetailsString()) : proxy.toString();
                final HTTPProxy finalProxy = proxy;
                final JLabel finalLbl = new JLabel(_GUI.T.ConnectionColumn_getStringValue_connection(proxyString + " (000.000.000.000)"), proxy.isRemote() ? ConnectionColumn.this.proxyConnection : ConnectionColumn.this.directConnection, 10);
                this.add(finalLbl);
                final long taskID = TASK.incrementAndGet();
                SCHEDULER.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (taskID == TASK.get()) {
                            final ArrayList<HTTPProxy> proxies = new ArrayList<HTTPProxy>();
                            proxies.add(finalProxy);
                            BalancedWebIPCheck ipCheck = new BalancedWebIPCheck(new ProxySelectorInterface(){

                                public boolean updateProxy(Request request, int retryCounter) {
                                    return false;
                                }

                                public boolean reportConnectException(Request request, int retryCounter, IOException e) {
                                    return false;
                                }

                                public List<HTTPProxy> getProxiesByURL(URL uri) {
                                    return proxies;
                                }
                            });
                            try {
                                final IP ip = ipCheck.getExternalIP();
                                new EDTRunner(){

                                    protected void runInEDT() {
                                        finalLbl.setText(_GUI.T.ConnectionColumn_getStringValue_connection(proxyString + " (" + ip.getIP() + ")"));
                                    }
                                };
                            }
                            catch (IPCheckException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                if (sdc.getAccount() != null && sdc.getAccount().getPlugin() != null && (domainInfo = DomainInfo.getInstance((plugin = sdc.getAccount().getPlugin()).getHost(link, sdc.getAccount(), false))) != null) {
                    icon = domainInfo.getFavIcon();
                    this.add(new JLabel(_GUI.T.ConnectionColumn_DownloadUsesAccount(GUIUtils.getAccountName((String)sdc.getAccount().getUser())), icon, 10));
                }
            }
            if (dli != null) {
                plugin = sdc.getProcessingPlugin();
                domainInfo = plugin != null ? DomainInfo.getInstance(sdc.getProcessingPlugin().getHost(link, sdc.getAccount(), false)) : null;
                icon = domainInfo != null ? domainInfo.getFavIcon() : ConnectionColumn.this.url;
                URLConnectionAdapter con = dli.getConnection();
                if (con != null) {
                    this.add(new JLabel(_GUI.T.ConnectionColumn_getStringValue_from(con.getURL().getProtocol() + "@" + dli.getDownloadable().getHost()), icon, 10));
                    String cipher = con.getCipherSuite();
                    if (cipher != null) {
                        this.add(new JLabel(cipher, ConnectionColumn.this.tls, 10));
                    }
                } else {
                    this.add(new JLabel(_GUI.T.ConnectionColumn_getStringValue_from(dli.getDownloadable().getHost()), icon, 10));
                }
                this.add(new JLabel(_GUI.T.ConnectionColumn_getStringValue_chunks(dli.getManagedConnetionHandler().size()), ConnectionColumn.this.connections, 10));
            }
            this.panel.setOpaque(false);
            if (this.panel.getComponentCount() > 0) {
                this.add((Component)this.panel);
            }
        }

        private JLabel add(JLabel lbl) {
            SwingUtils.setOpaque((JComponent)lbl, (boolean)false);
            Color color = UIManager.getColor("Appwork.Tooltip.Foreground");
            if (color != null) {
                lbl.setForeground(color);
            }
            this.panel.add((Component)lbl);
            return lbl;
        }

        public TooltipPanel createContent() {
            return null;
        }

        public String toText() {
            return null;
        }
    }
}

