/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jd.controlling.packagecontroller.AbstractNode;
import jd.nutils.Formatter;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginProgress;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columnmenu.LockColumnWidthAction;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModelData;
import org.jdownloader.gui.views.downloads.columns.TaskColumn;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class ETAColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private final Icon wait;
    private ColumnHelper columnHelper = new ColumnHelper();

    public int getDefaultWidth() {
        return 80;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public ETAColumn() {
        super(_GUI.T.ETAColumn_ETAColumn());
        this.rendererField.setHorizontalAlignment(4);
        this.wait = NewTheme.I().getIcon("wait", 16);
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){
            private ColumnHelper helper1;
            private ColumnHelper helper2;
            {
                this.helper1 = new ColumnHelper();
                this.helper2 = new ColumnHelper();
            }

            public int compare(AbstractNode o1, AbstractNode o2) {
                if (o1 == o2) {
                    return 0;
                }
                ETAColumn.this.fillColumnHelper(o1, this.helper1);
                ETAColumn.this.fillColumnHelper(o2, this.helper2);
                long l1 = this.helper1.eta;
                long l2 = this.helper2.eta;
                if (l1 == l2) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return l1 > l2 ? -1 : 1;
                }
                return l1 < l2 ? -1 : 1;
            }
        });
    }

    private void fillColumnHelper(AbstractNode value, ColumnHelper columnHelper) {
        if (value instanceof DownloadLink) {
            DownloadLink link = (DownloadLink)value;
            PluginProgress progress = link.getPluginProgress();
            if (progress != null) {
                columnHelper.icon = progress.getIcon((Object)this);
                columnHelper.string = progress.getMessage((Object)this);
                long eta = progress.getETA();
                if (eta >= 0L) {
                    columnHelper.eta = eta;
                } else {
                    columnHelper.eta = -1L;
                }
                return;
            }
            ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
            if (conditionalSkipReason != null && !conditionalSkipReason.isConditionReached()) {
                if (conditionalSkipReason instanceof TimeOutCondition) {
                    long time = ((TimeOutCondition)((Object)conditionalSkipReason)).getTimeOutLeft();
                    columnHelper.icon = conditionalSkipReason.getIcon((Object)this, value);
                    columnHelper.eta = time;
                    columnHelper.string = conditionalSkipReason.getMessage((Object)this, value);
                    return;
                }
                columnHelper.icon = conditionalSkipReason.getIcon((Object)this, value);
                columnHelper.eta = -1L;
                columnHelper.string = conditionalSkipReason.getMessage((Object)this, value);
                return;
            }
            columnHelper.icon = null;
            columnHelper.string = null;
            columnHelper.eta = -1L;
        } else {
            List visibleChildren;
            FilePackage fp = (FilePackage)value;
            PackageControllerTableModelData.PackageControllerTableModelDataPackage view = fp.getView().getTableModelDataPackage();
            List list = visibleChildren = view.getVisibleChildrenSize() == 1 ? view.getVisibleChildren() : null;
            if (visibleChildren != null && visibleChildren.size() == 1) {
                this.fillColumnHelper((AbstractNode)visibleChildren.get(0), columnHelper);
            } else {
                columnHelper.icon = null;
                long eta = fp.getView().getETA();
                if (eta > 0L) {
                    columnHelper.eta = eta;
                    columnHelper.string = Formatter.formatSeconds((long)eta);
                } else if (eta == Integer.MIN_VALUE) {
                    columnHelper.eta = Long.MAX_VALUE;
                    columnHelper.string = "\u221e";
                } else {
                    columnHelper.eta = 0L;
                    columnHelper.string = null;
                }
            }
        }
    }

    protected void prepareColumn(AbstractNode value) {
        this.fillColumnHelper(value, this.columnHelper);
    }

    protected Icon getIcon(AbstractNode value) {
        return this.columnHelper.icon;
    }

    public JPopupMenu createHeaderPopup() {
        JPopupMenu ret = new JPopupMenu();
        LockColumnWidthAction action = new LockColumnWidthAction((ExtColumn)this);
        ret.add(new JCheckBoxMenuItem((Action)action));
        ret.add(new JCheckBoxMenuItem((Action)((Object)new AppAction(){
            {
                this.setName(_GUI.T.literall_premium_alert());
                this.setSmallIcon(ETAColumn.this.wait);
                this.setSelected(((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isPremiumAlertETAColumnEnabled());
            }

            public void actionPerformed(ActionEvent e) {
                ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setPremiumAlertETAColumnEnabled(!((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isPremiumAlertETAColumnEnabled());
            }
        })));
        ret.add(new JSeparator());
        return ret;
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode value) {
        return TaskColumn.handleIPBlockCondition(e, value);
    }

    public String getStringValue(AbstractNode value) {
        return this.columnHelper.string;
    }

    private class ColumnHelper {
        private Icon icon = null;
        private long eta = -1L;
        private String string = null;

        private ColumnHelper() {
        }
    }
}

