/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.columns.ExtIconColumn;
import org.appwork.utils.ModifyLock;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;

public class EnabledDisabledColumn
extends ExtIconColumn<AbstractNode> {
    private final Icon iconNo;
    private final Icon iconYes = CheckBoxIcon.TRUE;

    public EnabledDisabledColumn() {
        super(_GUI.T.EnabledDisabledColumn_EnabledDisabledColumn());
        this.iconNo = CheckBoxIcon.FALSE;
        super.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                if (o1 instanceof AbstractPackageNode && o2 instanceof AbstractPackageNode) {
                    return this.sortPackages((AbstractPackageNode)o1, (AbstractPackageNode)o2);
                }
                return this.sortLinks(o1, o2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int sortPackages(AbstractPackageNode o1, AbstractPackageNode o2) {
                int o1Enabled = 0;
                int o2Enabled = 0;
                ModifyLock lock = o1.getModifyLock();
                boolean readL = lock.readLock();
                try {
                    for (Object link : o1.getChildren()) {
                        if (!((AbstractNode)link).isEnabled()) continue;
                        o1Enabled = 1;
                        break;
                    }
                }
                finally {
                    lock.readUnlock(readL);
                }
                lock = o2.getModifyLock();
                readL = lock.readLock();
                try {
                    for (Object link : o2.getChildren()) {
                        if (!((AbstractNode)link).isEnabled()) continue;
                        o2Enabled = 1;
                        break;
                    }
                }
                finally {
                    lock.readUnlock(readL);
                }
                return this.finalDecision(o1Enabled, o2Enabled);
            }

            private final int sortLinks(AbstractNode o1, AbstractNode o2) {
                return this.finalDecision(o1.isEnabled() ? 1 : 0, o2.isEnabled() ? 1 : 0);
            }

            private final int finalDecision(int h1, int h2) {
                if (h1 == h2) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return h1 > h2 ? -1 : 1;
                }
                return h2 > h1 ? -1 : 1;
            }
        });
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        if (obj.isEnabled()) {
            obj.setEnabled(false);
        } else {
            obj.setEnabled(true);
        }
        return false;
    }

    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(CheckBoxIcon.TRUE);
                this.setHorizontalAlignment(0);
                this.setText(null);
                this.setToolTipText(_GUI.T.StatusColumn_StatusColumn2());
                return this;
            }
        };
        return ret;
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public boolean isDefaultVisible() {
        return false;
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return false;
    }

    public int getMaxWidth() {
        return 100;
    }

    public int getMinWidth() {
        return 12;
    }

    public int getDefaultWidth() {
        return 22;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return true;
    }

    protected Icon getIcon(AbstractNode value) {
        if (value != null) {
            return this.getIconToDisplay(value.isEnabled());
        }
        return null;
    }

    private Icon getIconToDisplay(boolean isEnabled) {
        if (isEnabled) {
            return this.iconYes;
        }
        return this.iconNo;
    }
}

