/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Comparator;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.JDGui;
import jd.nutils.NaturalOrderComparator;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columnmenu.LockColumnWidthAction;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.extensions.ExtensionController;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.components.packagetable.actions.SortPackagesDownloadOrdnerOnColumn;
import org.jdownloader.gui.views.components.packagetable.context.rename.RenameDialog;
import org.jdownloader.gui.views.downloads.action.OpenFileAction;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class FileColumn
extends ExtTextColumn<AbstractNode>
implements GenericConfigEventListener<Boolean> {
    private static final long serialVersionUID = -2963955407564917958L;
    protected Border leftGapBorder = BorderFactory.createEmptyBorder(0, 32, 0, 0);
    private final Icon iconPackageOpen;
    private final Icon iconPackageClosed;
    private final Icon iconArchive;
    private final Icon iconArchiveOpen;
    protected Border normalBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
    private boolean selectAll = false;
    private boolean hideSinglePackage = true;
    public static final int EXPAND_COLLAPSE_AREA = 39;
    boolean hadFocusBefore = false;

    public FileColumn() {
        super(_GUI.T.filecolumn_title());
        Icon open = NewTheme.I().getIcon("tree_minus", -1);
        Icon closed = NewTheme.I().getIcon("tree_plus", -1);
        this.iconPackageOpen = new ExtMergedIcon(open, 0, 0).add(NewTheme.I().getIcon("package_open", 16), 16, 0);
        this.iconArchiveOpen = new ExtMergedIcon(open, 0, 0).add(NewTheme.I().getIcon("rar", 16), 16, 0);
        this.iconArchive = new ExtMergedIcon(closed, 0, 0).add(NewTheme.I().getIcon("rar", 16), 16, 0);
        this.iconPackageClosed = new ExtMergedIcon(closed, 0, 0).add(NewTheme.I().getIcon("package_closed", 16), 16, 0);
        this.setClickcount(0);
        this.hideSinglePackage = CFG_GUI.HIDE_SINGLE_CHILD_PACKAGES.isEnabled();
        CFG_GUI.HIDE_SINGLE_CHILD_PACKAGES.getEventSender().addListener((EventListener)((Object)this), true);
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){
            private Comparator<String> comp = new NaturalOrderComparator();

            public int compare(AbstractNode o1, AbstractNode o2) {
                String o1s = FileColumn.this.getStringValue(o1);
                String o2s = FileColumn.this.getStringValue(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return this.comp.compare(o1s, o2s);
                }
                return this.comp.compare(o2s, o1s);
            }
        });
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public static JPopupMenu createColumnPopup(ExtColumn<AbstractNode> fileColumn, boolean isLocked) {
        JPopupMenu ret = new JPopupMenu();
        boolean sepRequired = false;
        if (!isLocked && fileColumn.getModel().getTable().isColumnLockingFeatureEnabled()) {
            sepRequired = true;
            LockColumnWidthAction action = new LockColumnWidthAction(fileColumn);
            ret.add(new JCheckBoxMenuItem((Action)action));
        }
        if (fileColumn.isSortable(null)) {
            sepRequired = true;
            ret.add((Action)((Object)new SortPackagesDownloadOrdnerOnColumn(fileColumn)));
        }
        if (sepRequired) {
            ret.add(new JSeparator());
        }
        return ret;
    }

    public boolean onDoubleClick(MouseEvent e, AbstractNode contextObject) {
        if (this.isExpandCollapseArea(e, contextObject)) {
            return false;
        }
        if (contextObject instanceof DownloadLink) {
            switch (CFG_GUI.CFG.getLinkDoubleClickAction()) {
                case NOTHING: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case OPEN_FILE: {
                    if (!CrossSystem.isOpenFileSupported()) break;
                    new OpenFileAction(new File(((DownloadLink)contextObject).getFileOutput())).actionPerformed(null);
                    break;
                }
                case OPEN_FOLDER: {
                    if (!CrossSystem.isOpenFileSupported()) break;
                    new OpenFileAction(LinkTreeUtils.getDownloadDirectory(((DownloadLink)contextObject).getParentNode())).actionPerformed(null);
                    break;
                }
                case OPEN_PROPERTIES_PANEL: {
                    CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)(!CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() ? 1 : 0));
                    break;
                }
                case RENAME: {
                    this.startEditing(contextObject);
                }
            }
        } else if (contextObject instanceof CrawledLink) {
            switch (CFG_GUI.CFG.getLinkDoubleClickAction()) {
                case NOTHING: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case OPEN_FILE: {
                    if (!CrossSystem.isOpenFileSupported()) break;
                    new OpenFileAction(LinkTreeUtils.getDownloadDirectory(contextObject)).actionPerformed(null);
                    break;
                }
                case OPEN_FOLDER: {
                    if (!CrossSystem.isOpenFileSupported()) break;
                    new OpenFileAction(LinkTreeUtils.getDownloadDirectory(((CrawledLink)contextObject).getParentNode())).actionPerformed(null);
                    break;
                }
                case OPEN_PROPERTIES_PANEL: {
                    CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)(!CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() ? 1 : 0));
                    break;
                }
                case RENAME: {
                    this.startEditing(contextObject);
                }
            }
        } else if (contextObject instanceof AbstractPackageNode) {
            switch (CFG_GUI.CFG.getPackageDoubleClickAction()) {
                case EXPAND_COLLAPSE_TOGGLE: {
                    if (e.isControlDown() && !e.isShiftDown()) {
                        ((PackageControllerTableModel)this.getModel()).toggleFilePackageExpand((AbstractPackageNode)contextObject, PackageControllerTableModel.TOGGLEMODE.BOTTOM);
                        break;
                    }
                    if (e.isControlDown() && e.isShiftDown()) {
                        ((PackageControllerTableModel)this.getModel()).toggleFilePackageExpand((AbstractPackageNode)contextObject, PackageControllerTableModel.TOGGLEMODE.TOP);
                        break;
                    }
                    ((PackageControllerTableModel)this.getModel()).toggleFilePackageExpand((AbstractPackageNode)contextObject, PackageControllerTableModel.TOGGLEMODE.CURRENT);
                    break;
                }
                case NOTHING: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case OPEN_FOLDER: {
                    if (!CrossSystem.isOpenFileSupported()) break;
                    new OpenFileAction(LinkTreeUtils.getDownloadDirectory(contextObject)).actionPerformed(null);
                    break;
                }
                case OPEN_PROPERTIES_PANEL: {
                    if (((AbstractPackageNode)contextObject).getControlledBy().equals(DownloadController.getInstance())) {
                        CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)(!CFG_GUI.DOWNLOADS_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() ? 1 : 0));
                        break;
                    }
                    if (!((AbstractPackageNode)contextObject).getControlledBy().equals(LinkCollector.getInstance())) break;
                    CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.setValue((Object)(!CFG_GUI.LINKGRABBER_TAB_PROPERTIES_PANEL_VISIBLE.isEnabled() ? 1 : 0));
                    break;
                }
                case RENAME: {
                    this.startEditing(contextObject);
                }
            }
        }
        return true;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public int getDefaultWidth() {
        return 350;
    }

    public boolean isEditable(AbstractNode obj) {
        return true;
    }

    public boolean isExpandCollapseArea(MouseEvent e, AbstractNode obj) {
        return obj instanceof AbstractPackageNode && e.getPoint().x - this.getBounds().x < 39;
    }

    public boolean onRenameClick(MouseEvent e, AbstractNode obj) {
        if (this.isExpandCollapseArea(e, obj)) {
            return false;
        }
        this.startEditing(obj);
        return true;
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return this.isEditable(obj);
    }

    protected void setStringValue(String value, AbstractNode object) {
        if (object instanceof FilePackage) {
            ((FilePackage)object).setName(value);
        } else if (object instanceof CrawledPackage) {
            ((CrawledPackage)object).setName(value);
        } else if (object instanceof CrawledLink) {
            boolean isMultiArchive = false;
            try {
                ExtractionExtension archiver = (ExtractionExtension)ExtensionController.getInstance().getExtension(ExtractionExtension.class)._getExtension();
                if (archiver != null) {
                    CrawledLinkFactory archiveFactory = new CrawledLinkFactory((CrawledLink)object);
                    Archive archive = archiver.buildArchive((ArchiveFactory)archiveFactory);
                    isMultiArchive = archive != null && archive.getArchiveFiles().size() > 1;
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            ((CrawledLink)object).setName(value);
            if (isMultiArchive) {
                String title = _GUI.T.FileColumn_setStringValue_title_();
                String msg = _GUI.T.FileColumn_setStringValue_msg_();
                Icon icon = NewTheme.I().getIcon("warning", 32);
                JDGui.help((String)title, (String)msg, (Icon)icon);
            }
        } else if (object instanceof DownloadLink) {
            boolean isMultiArchive = false;
            try {
                ExtractionExtension archiver = (ExtractionExtension)ExtensionController.getInstance().getExtension(ExtractionExtension.class)._getExtension();
                if (archiver != null) {
                    DownloadLinkArchiveFactory archiveFactory = new DownloadLinkArchiveFactory((DownloadLink)object);
                    Archive archive = archiver.buildArchive((ArchiveFactory)archiveFactory);
                    isMultiArchive = archive != null && archive.getArchiveFiles().size() > 1;
                }
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
            DownloadWatchDog.getInstance().renameLink((DownloadLink)object, value);
            if (isMultiArchive) {
                String title = _GUI.T.FileColumn_setStringValue_title_();
                String msg = _GUI.T.FileColumn_setStringValue_msg_();
                Icon icon = NewTheme.I().getIcon("warning", 32);
                JDGui.help((String)title, (String)msg, (Icon)icon);
            }
        }
    }

    protected Icon getIcon(AbstractNode value) {
        if (value instanceof AbstractPackageNode) {
            return ((AbstractPackageNode)value).isExpanded() ? this.iconPackageOpen : this.iconPackageClosed;
        }
        if (value instanceof DownloadLink) {
            return ((DownloadLink)value).getLinkInfo().getIcon();
        }
        if (value instanceof CrawledLink) {
            return ((CrawledLink)value).getLinkInfo().getIcon();
        }
        return null;
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.rendererIcon.setIcon(this.getIcon(value));
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        if (this.getTableColumn() != null) {
            this.rendererField.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this.rendererField, (FontMetrics)this.rendererField.getFontMetrics(this.rendererField.getFont()), (String)str, (int)(this.getTableColumn().getWidth() - this.rendererIcon.getPreferredSize().width - 32)));
        } else {
            this.rendererField.setText(str);
        }
        if (value instanceof AbstractPackageNode) {
            this.renderer.setBorder(this.normalBorder);
        } else if (value instanceof AbstractPackageChildrenNode) {
            AbstractPackageNode parent = (AbstractPackageNode)((AbstractPackageChildrenNode)value).getParentNode();
            if (parent != null && parent.getChildren().size() == 1 && this.hideSinglePackage) {
                this.renderer.setBorder(this.normalBorder);
            } else {
                this.renderer.setBorder(this.leftGapBorder);
            }
        }
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        super.configureEditorComponent((Object)value, isSelected, row, column);
        if (value instanceof AbstractPackageNode) {
            this.selectAll = true;
            this.editor.setBorder(this.normalBorder);
        } else {
            this.selectAll = false;
            this.editor.setBorder(this.leftGapBorder);
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (!e.isTemporary() || e.getOppositeComponent() == null) {
            this.hadFocusBefore = false;
        }
    }

    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    public void focusGained(FocusEvent e) {
        if (this.hadFocusBefore) {
            return;
        }
        this.hadFocusBefore = true;
        String txt = this.editorField.getText();
        String withoutArchiveExtension = RenameDialog.removeArchiveExtension(null, txt);
        int point = -1;
        if (withoutArchiveExtension != null && !txt.equals(withoutArchiveExtension)) {
            point = withoutArchiveExtension.length();
        } else {
            point = txt.lastIndexOf(".");
            int pointPart = txt.lastIndexOf(".part");
            if (pointPart > 0) {
                point = pointPart;
            }
        }
        if (point > 0 && !this.selectAll) {
            this.editorField.select(0, point);
        } else {
            this.editorField.selectAll();
        }
    }

    public boolean isHidable() {
        return true;
    }

    public final String getStringValue(AbstractNode value) {
        if (value instanceof DownloadLink) {
            return ((DownloadLink)value).getView().getDisplayName();
        }
        return value.getName();
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        this.hideSinglePackage = newValue;
    }
}

