/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.text.NumberFormat;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class FileSizeColumn
extends ExtColumn<AbstractNode> {
    private final RenderLabel sizeRenderer = new RenderLabel();
    private NumberFormat formatter;
    private final String zeroString;
    private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup(this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public FileSizeColumn() {
        super(_GUI.T.FileSizeColumn_FileSizeColumn(), null);
        this.sizeRenderer.setHorizontalAlignment(4);
        this.zeroString = _GUI.T.SizeColumn_getSizeString_zero();
        this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                long s2;
                long s1 = FileSizeColumn.this.getBytes(o1);
                if (s1 == (s2 = FileSizeColumn.this.getBytes(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }
        });
        this.formatter = this.updateNumberFormat();
    }

    protected NumberFormat updateNumberFormat() {
        this.formatter = super.updateNumberFormat();
        return this.formatter;
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.sizeRenderer.setText(this.getSizeString(this.getBytes(value)));
    }

    public Object getCellEditorValue() {
        return null;
    }

    public JComponent getEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        return null;
    }

    public JComponent getRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.sizeRenderer;
    }

    private final String getSizeString(long fileSize) {
        if (fileSize < 0L) {
            return this.zeroString;
        }
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, fileSize);
    }

    protected String getTooltipText(AbstractNode value) {
        long sizeValue = this.getBytes(value);
        if (sizeValue < 0L) {
            return _GUI.T.SizeColumn_getSizeString_zero_tt();
        }
        return this.getSizeString(sizeValue);
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public void resetEditor() {
    }

    public void resetRenderer() {
        this.sizeRenderer.setEnabled(true);
        this.sizeRenderer.setOpaque(false);
        this.sizeRenderer.setBorder(ExtColumn.DEFAULT_BORDER);
    }

    public void setValue(Object value, AbstractNode object) {
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public int getDefaultWidth() {
        return 70;
    }

    public int getMinWidth() {
        return this.getDefaultWidth();
    }

    protected long getBytes(AbstractNode o2) {
        if (o2 instanceof CrawledPackage) {
            return ((CrawledPackage)o2).getView().getFileSize();
        }
        if (o2 instanceof CrawledLink) {
            return ((CrawledLink)o2).getSize();
        }
        if (o2 instanceof DownloadLink) {
            return ((DownloadLink)o2).getView().getBytesTotal();
        }
        if (o2 instanceof FilePackage) {
            return ((FilePackage)o2).getView().getSize();
        }
        return -1L;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }
}

