/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.components.premiumbar.ServiceCollection;
import jd.gui.swing.jdgui.components.premiumbar.ServicePanel;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.IconLabelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.HosterToolTip;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class HosterColumn
extends ExtColumn<AbstractNode> {
    private static boolean COLORED_ICONS = CFG_GUI.COLORED_ICONS_FOR_DISABLED_HOSTER_COLUMN_ENABLED.isEnabled();
    private static boolean FULL_HOSTNAME = CFG_GUI.SHOW_FULL_HOSTNAME.isEnabled();
    private static final long serialVersionUID = 1L;
    private int maxIcons = 10;
    private MigPanel panel = new RendererMigPanel("ins 0 0 0 0", "[]", "[grow,fill]");
    private RenderLabel[] labels = new RenderLabel[this.maxIcons + 1];
    private final Icon moreIcon;
    private static int DEFAULT_ICON_COUNT;

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup(this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public HosterColumn() {
        super(_GUI.T.HosterColumn_HosterColumn(), null);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.maxIcons; ++i) {
            this.labels[i] = new RenderLabel();
            this.labels[i].setOpaque(false);
            this.labels[i].setBackground(null);
            if (sb.length() > 0) {
                sb.append("1");
            }
            sb.append("[18!]");
            this.panel.add((Component)this.labels[i]);
        }
        this.moreIcon = NewTheme.I().getIcon("more", -1);
        this.panel.setLayout((LayoutManager)new MigLayout("ins 0 0 0 0", sb.toString(), "[fill,grow]"));
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                if (o1 instanceof AbstractPackageNode && o2 instanceof AbstractPackageNode) {
                    DomainInfo[] dis2;
                    DomainInfo[] dis1 = ((AbstractPackageNode)o1).getView().getDomainInfos();
                    if (dis1 == null) {
                        dis1 = new DomainInfo[]{};
                    }
                    if ((dis2 = ((AbstractPackageNode)o2).getView().getDomainInfos()) == null) {
                        dis2 = new DomainInfo[]{};
                    }
                    for (int i = 0; i < Math.max(dis1.length, dis2.length); ++i) {
                        int ret;
                        String d2;
                        String d1 = i < dis1.length ? dis1[i].getTld() : "";
                        String string = d2 = i < dis2.length ? dis2[i].getTld() : "";
                        if (!(this.getSortOrderIdentifier() == "ASC" ? (ret = d1.compareTo(d2)) != 0 : (ret = d2.compareTo(d1)) != 0)) continue;
                        return ret;
                    }
                    return 0;
                }
                if (o1 instanceof AbstractPackageChildrenNode && o2 instanceof AbstractPackageChildrenNode) {
                    DomainInfo di1 = ((AbstractPackageChildrenNode)o1).getDomainInfo();
                    DomainInfo di2 = ((AbstractPackageChildrenNode)o2).getDomainInfo();
                    String l1 = di1 != null ? di1.getTld() : "";
                    String l2 = di2 != null ? di2.getTld() : "";
                    if (this.getSortOrderIdentifier() == "ASC") {
                        return l1.compareTo(l2);
                    }
                    return l2.compareTo(l1);
                }
                return 0;
            }
        });
        this.resetRenderer();
    }

    public Object getCellEditorValue() {
        return null;
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (COLORED_ICONS) {
            return true;
        }
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    public void setValue(Object value, AbstractNode object) {
    }

    public int getDefaultWidth() {
        return DEFAULT_ICON_COUNT * 19 + 7;
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        DomainInfo dl;
        int width = this.getTableColumn().getWidth();
        int count = (width - 6) / 19;
        if (value instanceof AbstractPackageNode) {
            DomainInfo[] domainInfos = ((AbstractPackageNode)value).getView().getDomainInfos();
            if (domainInfos != null) {
                int i = 0;
                for (DomainInfo domainInfo : domainInfos) {
                    if (i == this.maxIcons || i == count) {
                        this.labels[i].setIcon(this.moreIcon);
                        this.labels[i].setVisible(true);
                        break;
                    }
                    Icon icon = domainInfo.getFavIcon();
                    if (icon == null) continue;
                    this.labels[i].setVisible(true);
                    this.labels[i].setIcon(icon);
                    if (FULL_HOSTNAME && domainInfos.length == 1) {
                        this.labels[0].setText(domainInfo.getDomain());
                    }
                    ++i;
                }
            }
        } else if (value instanceof AbstractPackageChildrenNode && (dl = ((AbstractPackageChildrenNode)value).getDomainInfo()) != null && dl.getFavIcon() != null) {
            this.labels[0].setVisible(true);
            this.labels[0].setIcon(dl.getFavIcon());
            if (FULL_HOSTNAME) {
                this.labels[0].setText(dl.getDomain());
            } else {
                this.labels[0].setText(null);
            }
        }
    }

    public boolean onDoubleClick(final MouseEvent e, final AbstractNode obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (obj instanceof AbstractPackageChildrenNode) {
                    DomainInfo di = ((AbstractPackageChildrenNode)obj).getDomainInfo();
                    if (di != null) {
                        List services = ServicePanel.getInstance().groupServices(GraphicalUserInterfaceSettings.PremiumStatusBarDisplay.GROUP_BY_SUPPORTED_ACCOUNTS, false, di.getTld(), null);
                        if (services.size() > 0) {
                            ToolTipController.getInstance().show(((ServiceCollection)services.get(0)).createTooltip(null));
                        } else {
                            ToolTipController.getInstance().show(HosterColumn.this.createToolTip(e.getPoint(), obj));
                        }
                    }
                } else if (obj instanceof AbstractPackageNode) {
                    // empty if block
                }
            }
        });
        return true;
    }

    public ExtTooltip createToolTip(Point position, AbstractNode obj) {
        DomainInfo[] di;
        if (obj instanceof AbstractPackageChildrenNode) {
            DomainInfo di2 = ((AbstractPackageChildrenNode)obj).getDomainInfo();
            if (di2 != null) {
                return new IconLabelToolTip(di2.getDomain(), di2.getFavIcon());
            }
        } else if (obj instanceof AbstractPackageNode && (di = ((AbstractPackageNode)obj).getView().getDomainInfos()) != null) {
            return new HosterToolTip(di);
        }
        return null;
    }

    public JComponent getEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
        return null;
    }

    public JComponent getRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.panel;
    }

    public void resetEditor() {
    }

    public void resetRenderer() {
        for (int i = 0; i <= this.maxIcons; ++i) {
            this.labels[i].setVisible(false);
            this.labels[i].setText(null);
        }
        this.panel.setOpaque(false);
        this.panel.setBackground(null);
    }

    public void configureEditorComponent(AbstractNode value, boolean isSelected, int row, int column) {
    }

    static {
        CFG_GUI.SHOW_FULL_HOSTNAME.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                FULL_HOSTNAME = CFG_GUI.SHOW_FULL_HOSTNAME.isEnabled();
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        CFG_GUI.COLORED_ICONS_FOR_DISABLED_HOSTER_COLUMN_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                COLORED_ICONS = CFG_GUI.COLORED_ICONS_FOR_DISABLED_HOSTER_COLUMN_ENABLED.isEnabled();
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        DEFAULT_ICON_COUNT = 4;
    }
}

