/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.columns.ExtComboColumn;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.images.IconIO;
import org.jdownloader.controlling.Priority;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.images.NewTheme;

public class PriorityColumn
extends ExtComboColumn<AbstractNode, Priority> {
    private static final long serialVersionUID = 1L;
    private final Icon imgPriority_3 = NewTheme.I().getIcon("prio_-3", 16);
    private final Icon imgPriority_2 = NewTheme.I().getIcon("prio_-2", 16);
    private final Icon imgPriority_1 = NewTheme.I().getIcon("prio_-1", 16);
    private final Icon imgPriority0 = NewTheme.I().getIcon("prio_0", 16);
    private final Icon imgPriority1 = NewTheme.I().getIcon("prio_1", 16);
    private final Icon imgPriority2 = NewTheme.I().getIcon("prio_2", 16);
    private final Icon imgPriority3 = NewTheme.I().getIcon("prio_3", 16);
    private final Icon imgPriority0__3 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority_3, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0__2 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority_2, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0__1 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority_1, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0_0 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority0, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0_1 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority1, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0_2 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority2, (int)12, (int)12), 4, 2);
    private final Icon imgPriority0_3 = new BadgeIcon(this.imgPriority0, IconIO.getScaledInstance((Icon)this.imgPriority3, (int)12, (int)12), 4, 2);

    public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
        ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
            private static final long serialVersionUID = 2051980596953422289L;

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setIcon(new AbstractIcon("prio_3", 14));
                this.setHorizontalAlignment(0);
                this.setText(null);
                return this;
            }
        };
        return ret;
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    protected String modelItemToString(Priority selectedItem, AbstractNode value) {
        if (selectedItem != null) {
            return selectedItem.T();
        }
        return super.modelItemToString((Object)selectedItem, (Object)value);
    }

    public PriorityColumn() {
        super(_GUI.T.PriorityColumn_PriorityColumn(), new DefaultComboBoxModel<Priority>(Priority.values()));
        this.rendererField.setHorizontalTextPosition(4);
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                int p2;
                int p1 = PriorityColumn.this.getPriority(o1).ordinal();
                if (p1 == (p2 = PriorityColumn.this.getPriority(o2).ordinal())) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return p1 > p2 ? -1 : 1;
                }
                return p1 < p2 ? -1 : 1;
            }
        });
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public int getMinWidth() {
        return 35;
    }

    protected AbstractButton getPopupElement(final Priority o, final boolean selected, final AbstractNode value) {
        return new JMenuItem((Action)new BasicAction(o.toString()){
            {
                super(x0);
                this.setName(PriorityColumn.this.modelItemToString(o, value));
                Icon ico = PriorityColumn.this.getIconByPriority(o);
                if (selected) {
                    this.setSmallIcon((Icon)new ExtMergedIcon(ico).add((Icon)new CheckBoxIcon(8, true, true), 0, 8));
                } else {
                    this.setSmallIcon(ico);
                }
            }

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
        this.rendererField.setText("");
        this.rendererField.setIcon(this.getIconByPriority(value));
    }

    public boolean onRenameClick(MouseEvent e, AbstractNode obj) {
        return super.onRenameClick(e, (Object)obj);
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode value) {
        return false;
    }

    public int getDefaultWidth() {
        return 35;
    }

    public boolean isEditable(AbstractNode obj) {
        return true;
    }

    protected Icon getIconByPriority(Priority p) {
        switch (p) {
            default: {
                return this.imgPriority0;
            }
            case LOWEST: {
                return this.imgPriority_3;
            }
            case LOWER: {
                return this.imgPriority_2;
            }
            case LOW: {
                return this.imgPriority_1;
            }
            case HIGH: {
                return this.imgPriority1;
            }
            case HIGHER: {
                return this.imgPriority2;
            }
            case HIGHEST: 
        }
        return this.imgPriority3;
    }

    protected Icon getInheritedIconByPriority(Priority p) {
        switch (p) {
            default: {
                return this.imgPriority0;
            }
            case LOWEST: {
                return this.imgPriority0__3;
            }
            case LOWER: {
                return this.imgPriority0__2;
            }
            case LOW: {
                return this.imgPriority0__1;
            }
            case HIGH: {
                return this.imgPriority0_1;
            }
            case HIGHER: {
                return this.imgPriority0_2;
            }
            case HIGHEST: 
        }
        return this.imgPriority0_3;
    }

    protected Icon getIconByPriority(AbstractNode value) {
        if (value instanceof DownloadLink) {
            FilePackage parent;
            DownloadLink link = (DownloadLink)value;
            Priority ret = link.getPriorityEnum();
            if (Priority.DEFAULT.equals((Object)ret) && (parent = link.getFilePackage()) != null) {
                return this.getInheritedIconByPriority(parent.getPriorityEnum());
            }
            return this.getIconByPriority(ret);
        }
        if (value instanceof CrawledLink) {
            CrawledPackage parent;
            CrawledLink link = (CrawledLink)value;
            Priority ret = link.getPriority();
            if (Priority.DEFAULT.equals((Object)ret) && (parent = link.getParentNode()) != null) {
                return this.getInheritedIconByPriority(parent.getPriorityEnum());
            }
            return this.getIconByPriority(ret);
        }
        if (value instanceof FilePackage) {
            return this.getIconByPriority(((FilePackage)value).getPriorityEnum());
        }
        if (value instanceof CrawledPackage) {
            return this.getIconByPriority(((CrawledPackage)value).getPriorityEnum());
        }
        return this.imgPriority0;
    }

    private Priority getPriority(AbstractNode value) {
        if (value instanceof DownloadLink) {
            FilePackage parent;
            DownloadLink link = (DownloadLink)value;
            Priority ret = link.getPriorityEnum();
            if (Priority.DEFAULT.equals((Object)ret) && (parent = link.getFilePackage()) != null) {
                return parent.getPriorityEnum();
            }
            return ret;
        }
        if (value instanceof CrawledLink) {
            CrawledPackage parent;
            CrawledLink link = (CrawledLink)value;
            Priority ret = link.getPriority();
            if (Priority.DEFAULT.equals((Object)ret) && (parent = link.getParentNode()) != null) {
                return parent.getPriorityEnum();
            }
            return ret;
        }
        if (value instanceof FilePackage) {
            return ((FilePackage)value).getPriorityEnum();
        }
        if (value instanceof CrawledPackage) {
            return ((CrawledPackage)value).getPriorityEnum();
        }
        return Priority.DEFAULT;
    }

    protected String getTooltipText(AbstractNode value) {
        Priority priority = this.getPriority(value);
        if (priority != null && priority != Priority.DEFAULT) {
            return priority.T();
        }
        return null;
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        if (obj instanceof FilePackage) {
            return ((FilePackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    protected Priority getSelectedItem(AbstractNode value) {
        return this.getPriority(value);
    }

    protected void setSelectedItem(final AbstractNode object, final Priority value) {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                if (object instanceof DownloadLink) {
                    ((DownloadLink)object).setPriorityEnum(value);
                } else if (object instanceof CrawledLink) {
                    ((CrawledLink)object).setPriority(value);
                } else if (object instanceof FilePackage) {
                    ((FilePackage)object).setPriorityEnum(value);
                } else if (object instanceof CrawledPackage) {
                    ((CrawledPackage)object).setPriorityEnum(value);
                }
                return null;
            }
        });
    }
}

