/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.raf.FileBytesMap;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.multiprogressbar.MultiProgressBar;
import org.appwork.swing.components.multiprogressbar.Range;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.PanelToolTip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.swing.exttable.renderercomponents.RendererProgressBar;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.updatev2.gui.HorizontalPostion;
import org.jdownloader.updatev2.gui.LAFOptions;

public class ProgressColumn
extends ExtProgressColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private int big;
    private int medium;
    private RenderLabel lblDeterminded;
    private HorizontalPostion textPosition;
    private NumberFormat df;
    private RenderLabel lblIndeterminded;
    private RenderLabel lbl;
    private boolean percentEnabled;

    protected void chooseDeterminated() {
        super.chooseDeterminated();
        this.lbl = this.lblDeterminded;
    }

    protected void chooseIndeterminated() {
        super.chooseIndeterminated();
        this.lbl = this.lblIndeterminded;
    }

    public ProgressColumn() {
        super(_GUI.T.ProgressColumn_ProgressColumn());
        FontMetrics fm = this.determinatedRenderer.getFontMetrics(this.determinatedRenderer.getFont());
        this.big = fm.stringWidth(this.df.format(100.123456789) + this.getPercentLetter());
        this.medium = fm.stringWidth(this.df.format(100.123456789));
    }

    protected void preInit() {
        this.textPosition = LAFOptions.getInstance().getCfg().getProgressColumnTextPosition();
        this.percentEnabled = LAFOptions.getInstance().getCfg().isProgressColumnFormatAddPercentEnabled();
        this.df = this.updateNumberFormat();
    }

    protected NumberFormat updateNumberFormat() {
        this.df = super.updateNumberFormat();
        this.df.setMaximumFractionDigits(LAFOptions.getInstance().getCfg().getProgressColumnFractionDigits());
        this.df.setMinimumFractionDigits(LAFOptions.getInstance().getCfg().getProgressColumnFractionDigits());
        this.df.setMaximumIntegerDigits(3);
        this.df.setMinimumIntegerDigits(1);
        return this.df;
    }

    protected void setStringValue(AbstractNode value, long m, long v) {
        switch (this.textPosition) {
            case HIDDEN: {
                return;
            }
            case LEFT: 
            case RIGHT: {
                String sv = this.getString(value, v, m);
                this.lbl.setText(sv);
                return;
            }
        }
        super.setStringValue((Object)value, m, v);
    }

    public void resetRenderer() {
        super.resetRenderer();
        switch (this.textPosition) {
            case HIDDEN: 
            case LEFT: 
            case RIGHT: {
                this.rendererBar.setStringPainted(false);
                return;
            }
        }
    }

    protected MigPanel wrapDeterminedRenderer(RendererProgressBar renderer) {
        switch (this.textPosition) {
            case LEFT: {
                this.lblDeterminded = new RenderLabel();
                return this.layoutLeft(renderer, this.lblDeterminded);
            }
            case RIGHT: {
                this.lblDeterminded = new RenderLabel();
                return this.layoutRight(renderer, this.lblDeterminded);
            }
        }
        return super.wrapDeterminedRenderer(renderer);
    }

    private String getPercentLetter() {
        if (!this.percentEnabled) {
            return "";
        }
        return "%";
    }

    protected MigPanel wrapIndeterminedRenderer(RendererProgressBar renderer) {
        switch (this.textPosition) {
            case LEFT: {
                this.lblIndeterminded = new RenderLabel();
                return this.layoutLeft(renderer, this.lblIndeterminded);
            }
            case RIGHT: {
                this.lblIndeterminded = new RenderLabel();
                return this.layoutRight(renderer, this.lblIndeterminded);
            }
        }
        return super.wrapIndeterminedRenderer(renderer);
    }

    private RendererMigPanel layoutRight(RendererProgressBar renderer, RenderLabel lbl) {
        FontMetrics fm = lbl.getFontMetrics(lbl.getFont());
        int width = fm.stringWidth(this.df.format(100.123456789) + this.getPercentLetter()) + 2;
        RendererMigPanel ret = new RendererMigPanel("ins 0 0 0 0", "2[grow,fill]2[" + width + "!]", "[grow,fill]");
        ret.add((Component)renderer);
        ret.add((Component)lbl, (Object)"alignx right");
        return ret;
    }

    private RendererMigPanel layoutLeft(RendererProgressBar renderer, RenderLabel lbl) {
        FontMetrics fm = lbl.getFontMetrics(lbl.getFont());
        int width = fm.stringWidth(this.df.format(100.123456789) + this.getPercentLetter()) + 2;
        RendererMigPanel ret = new RendererMigPanel("ins 0 0 0 0", "[" + width + "!]2[grow,fill]2", "[grow,fill]");
        ret.add((Component)lbl, (Object)"alignx right");
        ret.add((Component)renderer);
        return ret;
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    protected boolean isIndeterminated(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getValue(value) < 0L;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    public boolean onDoubleClick(MouseEvent e, AbstractNode obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolTipController.getInstance().show(ProgressColumn.this.getModel().getTable().createExtTooltip(null));
            }
        });
        return false;
    }

    public ExtTooltip createToolTip(Point position, final AbstractNode obj) {
        TooltipPanel panel = new TooltipPanel("ins 0,wrap 1", "[grow,fill]", "[][grow,fill]");
        final MultiProgressBar mpb = new MultiProgressBar(1000L);
        mpb.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        this.updateRanges(obj, mpb);
        JLabel lbl = new JLabel(_GUI.T.ProgressColumn_createToolTip_object_());
        lbl.setForeground(LAFOptions.getInstance().getColorForTooltipForeground());
        SwingUtils.toBold((JLabel)lbl);
        panel.add((Component)lbl);
        mpb.setBorder((Border)BorderFactory.createMatteBorder(1, 1, 1, 1, LAFOptions.getInstance().getColorForTooltipForeground()));
        panel.add((Component)mpb, (Object)"width 300!,height 24!");
        return new PanelToolTip(panel){
            private static final long serialVersionUID = 1036923322222455495L;
            private Timer timer;

            public void onShow() {
                this.timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgressColumn.this.updateRanges(obj, mpb);
                        this.repaint();
                    }
                });
                this.timer.start();
            }

            public void onHide() {
                this.timer.stop();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRanges(AbstractNode obj, MultiProgressBar mpb) {
        if (obj instanceof DownloadLink) {
            SingleDownloadController controller = ((DownloadLink)obj).getDownloadLinkController();
            DownloadInterface downloadInterface = null;
            FileBytesMap.FileBytesMapView mapInfo = null;
            if (controller != null && (downloadInterface = controller.getDownloadInstance()) != null && (mapInfo = downloadInterface.getCacheMapView()) != null) {
                mpb.getModel().setMaximum(mapInfo.getSize());
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int i = 0; i < mapInfo.getMarkedAreas().length; ++i) {
                    ranges.add(new Range(mapInfo.getMarkedAreas()[i][0], mapInfo.getMarkedAreas()[i][0] + mapInfo.getMarkedAreas()[i][1]));
                }
                mpb.getModel().setRanges(ranges.toArray(new Range[0]));
            } else {
                mpb.getModel().setMaximum(((DownloadLink)obj).getView().getBytesTotal());
                ArrayList<Range> ranges = new ArrayList<Range>();
                long[] chunks = ((DownloadLink)obj).getView().getChunksProgress();
                if (chunks != null) {
                    long part = ((DownloadLink)obj).getView().getBytesTotal() / (long)chunks.length;
                    for (int i = 0; i < chunks.length; ++i) {
                        ranges.add(new Range((long)i * part, chunks[i]));
                    }
                    mpb.getModel().setRanges(ranges.toArray(new Range[0]));
                }
            }
        } else if (obj instanceof FilePackage) {
            long size = ((FilePackage)obj).getView().getSize();
            mpb.getModel().setMaximum(size);
            ArrayList<Range> ranges = new ArrayList<Range>();
            boolean readL = ((FilePackage)obj).getModifyLock().readLock();
            try {
                List<DownloadLink> children = ((FilePackage)obj).getChildren();
                long all = 0L;
                for (int i = 0; i < children.size(); ++i) {
                    ranges.add(new Range(all, all + children.get(i).getView().getBytesLoaded()));
                    all += children.get(i).getView().getBytesTotalEstimated();
                }
                mpb.getModel().setRanges(ranges.toArray(new Range[0]));
            }
            finally {
                ((FilePackage)obj).getModifyLock().readUnlock(readL);
            }
        }
    }

    public int getMinWidth() {
        return 16;
    }

    public int getDefaultWidth() {
        return 100;
    }

    protected String getString(AbstractNode value, long current, long total) {
        if (value instanceof FilePackage) {
            return this.format(ProgressColumn.getPercentString((long)current, (long)total));
        }
        DownloadLink dLink = (DownloadLink)value;
        if (dLink.getDefaultPlugin() == null) {
            return _GUI.T.gui_treetable_error_plugin();
        }
        PluginProgress progress = dLink.getPluginProgress();
        if (progress != null && !(progress.getProgressSource() instanceof PluginForHost)) {
            double prgs = progress.getPercent();
            if (prgs < 0.0) {
                return "";
            }
            return this.format(prgs);
        }
        if (total < 0L) {
            if (dLink.getView().getBytesLoaded() <= 0L) {
                return this.format(0.0);
            }
            return "~";
        }
        if (total < 0L) {
            return "~";
        }
        return this.format(ProgressColumn.getPercentString((long)current, (long)total));
    }

    private String format(double percentString) {
        if (this.textPosition == HorizontalPostion.CENTER) {
            int w = this.getWidth();
            if (w < this.big) {
                if (w < this.medium) {
                    return "";
                }
                return this.formatDoubleToString(percentString);
            }
            return this.formatDoubleToString(percentString) + this.getPercentLetter();
        }
        return this.formatDoubleToString(percentString) + this.getPercentLetter();
    }

    private String formatDoubleToString(double percentString) {
        if (percentString == 100.0 && this.textPosition == HorizontalPostion.CENTER) {
            return "100";
        }
        return this.df.format(percentString);
    }

    protected long getMax(AbstractNode value) {
        if (value instanceof FilePackage) {
            PluginProgress progress;
            FilePackage fp = (FilePackage)value;
            FilePackageView view = fp.getView();
            if (!view.isRunning() && (progress = view.getSinglePluginProgress()) != null && progress.isDisplayInProgressColumnEnabled()) {
                return progress.getTotal();
            }
            if (view.isFinished()) {
                return 100L;
            }
            if (view.getUnknownFileSizes() > 0) {
                return view.size();
            }
            return Math.max(0L, view.getSize());
        }
        DownloadLink dLink = (DownloadLink)value;
        PluginProgress progress = null;
        long size = -1L;
        if (dLink.getDefaultPlugin() == null) {
            return 100L;
        }
        progress = dLink.getPluginProgress();
        if (progress != null && progress.isDisplayInProgressColumnEnabled()) {
            return progress.getTotal();
        }
        if (FinalLinkState.CheckFinished(dLink.getFinalLinkState())) {
            return 100L;
        }
        size = dLink.getView().getBytesTotal();
        if (size > 0L) {
            return size;
        }
        return -1L;
    }

    protected void prepareGetter(AbstractNode value) {
    }

    protected int getFps() {
        return 5;
    }

    protected long getValue(AbstractNode value) {
        if (value instanceof FilePackage) {
            PluginProgress progress;
            FilePackage fp = (FilePackage)value;
            FilePackageView view = fp.getView();
            if (!view.isRunning() && (progress = view.getSinglePluginProgress()) != null && progress.isDisplayInProgressColumnEnabled()) {
                return progress.getCurrent();
            }
            if (view.isFinished()) {
                return 100L;
            }
            if (view.getUnknownFileSizes() > 0) {
                return view.getFinalCount();
            }
            return Math.max(0L, view.getDone());
        }
        DownloadLink dLink = (DownloadLink)value;
        PluginProgress progress = null;
        if (dLink.getDefaultPlugin() == null) {
            return -1L;
        }
        progress = dLink.getPluginProgress();
        if (progress != null && progress.isDisplayInProgressColumnEnabled()) {
            return progress.getCurrent();
        }
        if (FinalLinkState.CheckFinished(dLink.getFinalLinkState())) {
            return 100L;
        }
        if (dLink.getView().getBytesTotal() > 0L) {
            return dLink.getView().getBytesLoaded();
        }
        return 0L;
    }
}

