/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import javax.swing.JPopupMenu;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtFileSizeColumn;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class RemainingColumn
extends ExtFileSizeColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public RemainingColumn() {
        super(_GUI.T.RemainingColumn_RemainingColumn());
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public int getDefaultWidth() {
        return 90;
    }

    protected String getInvalidValue() {
        return "~";
    }

    protected long getBytes(AbstractNode o2) {
        if (o2 instanceof DownloadLink) {
            DownloadLink link = (DownloadLink)o2;
            long size = link.getView().getBytesTotal();
            if (size >= 0L) {
                return Math.max(0L, size - link.getView().getBytesLoaded());
            }
            return -1L;
        }
        if (o2 instanceof FilePackage) {
            FilePackageView view = ((FilePackage)o2).getView();
            if (view.getUnknownFileSizes() > 0) {
                return Math.max(-1L, view.getSize() - view.getDone());
            }
            return Math.max(0L, view.getSize() - view.getDone());
        }
        return -1L;
    }

    protected String getSizeString(long fileSize) {
        return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, fileSize);
    }

    protected String getTooltipText(AbstractNode value) {
        long sizeValue = this.getBytes(value);
        if (sizeValue < 0L) {
            return _GUI.T.SizeColumn_getSizeString_zero_tt();
        }
        return this.getSizeString(sizeValue);
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }
}

