/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.download.DownloadInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columnmenu.LockColumnWidthAction;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.DomainInfo;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.premium.PremiumInfoDialog;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class SpeedColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private final AtomicBoolean warningEnabled = new AtomicBoolean(false);
    private final Icon warningIcon;
    private final AtomicBoolean speedLimiterEnabled = new AtomicBoolean(false);
    private final DecimalFormat formatter;
    private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;

    public SpeedColumn() {
        super(_GUI.T.SpeedColumn_SpeedColumn());
        this.rendererField.setHorizontalAlignment(4);
        this.warningEnabled.set(CFG_GUI.PREMIUM_ALERT_SPEED_COLUMN_ENABLED.isEnabled());
        CFG_GUI.PREMIUM_ALERT_SPEED_COLUMN_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                SpeedColumn.this.warningEnabled.set(Boolean.TRUE.equals(newValue));
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
        this.warningIcon = NewTheme.I().getIcon("warning", 16);
        this.speedLimiterEnabled.set(CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.isEnabled());
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                SpeedColumn.this.speedLimiterEnabled.set(Boolean.TRUE.equals(newValue));
            }
        }, false);
        this.formatter = new DecimalFormat("0.00");
        this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit().isIECPrefix() ? GraphicalUserInterfaceSettings.SIZEUNIT.MiB : GraphicalUserInterfaceSettings.SIZEUNIT.MB;
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                long s2;
                long s1 = SpeedColumn.this.getSpeed(o1);
                if (s1 == (s2 = SpeedColumn.this.getSpeed(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return s1 > s2 ? -1 : 1;
                }
                return s1 < s2 ? -1 : 1;
            }
        });
    }

    public JPopupMenu createHeaderPopup() {
        JPopupMenu ret = new JPopupMenu();
        LockColumnWidthAction action = new LockColumnWidthAction((ExtColumn)this);
        ret.add(new JCheckBoxMenuItem((Action)action));
        ret.add(new JCheckBoxMenuItem((Action)((Object)new AppAction(){
            {
                this.setName(_GUI.T.literall_premium_alert());
                this.setSmallIcon(new AbstractIcon("warning", 16));
                this.setSelected(((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isPremiumAlertSpeedColumnEnabled());
            }

            public void actionPerformed(ActionEvent e) {
                ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setPremiumAlertSpeedColumnEnabled(!((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isPremiumAlertSpeedColumnEnabled());
            }
        })));
        ret.add(new JSeparator());
        return ret;
    }

    public void configureRendererComponent(AbstractNode value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
        if (this.speedLimiterEnabled.get()) {
            this.rendererField.setForeground(Color.RED);
        } else {
            this.rendererField.setForeground(null);
        }
    }

    protected boolean isDefaultResizable() {
        return false;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    public int getDefaultWidth() {
        return 130;
    }

    protected Icon getIcon(AbstractNode value) {
        if (this.isSpeedWarning(value)) {
            return this.warningIcon;
        }
        return null;
    }

    private boolean isSpeedWarning(AbstractNode value) {
        if (this.warningEnabled.get() && value instanceof DownloadLink) {
            Account acc;
            DownloadLink dl = (DownloadLink)value;
            SingleDownloadController dlc = dl.getDownloadLinkController();
            if (dlc == null || (acc = dlc.getAccount()) != null) {
                return false;
            }
            PluginForHost plugin = dl.getLivePlugin();
            if (plugin == null || !plugin.isSpeedLimited(dl, acc) | !plugin.isPremiumEnabled()) {
                return false;
            }
            long limit = dlc.getConnectionHandler().getLimit();
            if (limit > 0L && limit < 51200L) {
                return false;
            }
            DownloadInterface dli = dlc.getDownloadInstance();
            if (dli != null && ((DownloadLink)value).getView().getBytesLoaded() > 102400L && ((DownloadLink)value).getView().getSpeedBps() < 51200L) {
                return true;
            }
        }
        return false;
    }

    protected String getTooltipText(AbstractNode obj) {
        String ret = super.getTooltipText((Object)obj);
        if (this.speedLimiterEnabled.get()) {
            String limit = _GUI.T.SpeedMeterPanel_getString_limited(SizeFormatter.formatBytes((long)((Integer)CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getValue()).intValue()));
            return limit + "\r\n" + ret;
        }
        return ret;
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        if (this.isSpeedWarning(obj)) {
            try {
                Dialog.getInstance().showDialog((AbstractDialog)new PremiumInfoDialog(((DownloadLink)obj).getDomainInfo(), _GUI.T.SpeedColumn_onSingleClick_object_(((DownloadLink)obj).getHost()), "SpeedColumn"){

                    @Override
                    protected String getDescription(DomainInfo info2) {
                        return _GUI.T.SpeedColumn_getDescription_object_(info2.getTld());
                    }
                });
            }
            catch (DialogClosedException e1) {
                e1.printStackTrace();
            }
            catch (DialogCanceledException e1) {
                e1.printStackTrace();
            }
        }
        return false;
    }

    protected long getSpeed(AbstractNode value) {
        if (value instanceof DownloadLink) {
            PluginProgress pluginProgress = ((DownloadLink)value).getPluginProgress();
            if (pluginProgress instanceof DownloadPluginProgress) {
                return ((DownloadPluginProgress)pluginProgress).getSpeed();
            }
        } else if (value instanceof FilePackage) {
            return DownloadWatchDog.getInstance().getDownloadSpeedbyFilePackage((FilePackage)value);
        }
        return -1L;
    }

    public String getStringValue(AbstractNode value) {
        long speed;
        if (value instanceof DownloadLink) {
            long speed2;
            PluginProgress pluginProgress = ((DownloadLink)value).getPluginProgress();
            if (pluginProgress instanceof DownloadPluginProgress && (speed2 = ((DownloadPluginProgress)pluginProgress).getSpeed()) >= 0L) {
                return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, speed2) + "/s";
            }
        } else if (value instanceof FilePackage && (speed = DownloadWatchDog.getInstance().getDownloadSpeedbyFilePackage((FilePackage)value)) >= 0L) {
            return GraphicalUserInterfaceSettings.SIZEUNIT.formatValue(this.maxSizeUnit, this.formatter, speed) + "/s";
        }
        return null;
    }
}

