/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import jd.plugins.PluginForHost;
import jd.plugins.PluginProgress;
import jd.plugins.PluginStateCollection;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.MultiLineLabelTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.jdownloader.DomainInfo;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.gui.views.downloads.columns.candidatetooltip.CandidateTooltip;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.WaitWhileWaitingSkipReasonIsSet;
import org.jdownloader.plugins.WaitingSkipReason;
import org.jdownloader.premium.PremiumInfoDialog;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class TaskColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private final Icon trueIcon;
    private final Icon trueIconExtracted;
    private final Icon extracting;
    private final ColumnHelper columnHelper = new ColumnHelper();
    private final String finishedText = _GUI.T.TaskColumn_getStringValue_finished_();
    private final String runningText = _GUI.T.TaskColumn_getStringValue_running_();
    private final String startingString;
    private final String finalizingString;
    private final Icon startingIcon;
    private final Icon finalizingIcon;
    private final Icon okIconExtracted;
    private final Icon trueOrangaIconExtracted;
    private final Icon falseIconExtracted;
    private final Icon trueIconExtractedFailed;
    private final Icon okIconExtractedFailed;
    private final Icon trueOrangaIconExtractedFailed;
    private final Icon falseIconExtractedFailed;

    public int getDefaultWidth() {
        return 180;
    }

    public boolean isEnabled(AbstractNode obj) {
        return obj.isEnabled();
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public TaskColumn() {
        super(_GUI.T.StatusColumn_StatusColumn2());
        this.trueIcon = NewTheme.I().getIcon("true", 16);
        this.extracting = NewTheme.I().getIcon("extract", 16);
        this.startingIcon = NewTheme.I().getIcon("run", 16);
        this.finalizingIcon = NewTheme.I().getIcon("wait", 16);
        this.trueIconExtracted = new ExtMergedIcon((Icon)new AbstractIcon("true", 16)).add((Icon)new AbstractIcon("extract_ok", 16), 16, 0);
        this.falseIconExtracted = new ExtMergedIcon((Icon)new AbstractIcon("false", 16)).add((Icon)new AbstractIcon("extract_ok", 16), 16, 0);
        this.okIconExtracted = new ExtMergedIcon((Icon)new AbstractIcon("ok", 16)).add((Icon)new AbstractIcon("extract_ok", 16), 16, 0);
        this.trueOrangaIconExtracted = new ExtMergedIcon((Icon)new AbstractIcon("true-orange", 16)).add((Icon)new AbstractIcon("extract_ok", 16), 16, 0);
        this.trueIconExtractedFailed = new ExtMergedIcon((Icon)new AbstractIcon("true", 16)).add((Icon)new AbstractIcon("extract_error", 16), 16, 0);
        this.falseIconExtractedFailed = new ExtMergedIcon((Icon)new AbstractIcon("false", 16)).add((Icon)new AbstractIcon("extract_error", 16), 16, 0);
        this.okIconExtractedFailed = new ExtMergedIcon((Icon)new AbstractIcon("ok", 16)).add((Icon)new AbstractIcon("extract_error", 16), 16, 0);
        this.trueOrangaIconExtractedFailed = new ExtMergedIcon((Icon)new AbstractIcon("true-orange", 16)).add((Icon)new AbstractIcon("extract_error", 16), 16, 0);
        this.startingString = _GUI.T.TaskColumn_fillColumnHelper_starting();
        this.finalizingString = _GUI.T.TaskColumn_fillColumnHelper_finalizing();
        this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AbstractNode>(){

            public int compare(AbstractNode o1, AbstractNode o2) {
                TaskColumn.this.fillColumnHelper(TaskColumn.this.columnHelper, o1);
                String o1s = TaskColumn.this.getStringValue(o1);
                TaskColumn.this.fillColumnHelper(TaskColumn.this.columnHelper, o2);
                String o2s = TaskColumn.this.getStringValue(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return o1s.compareToIgnoreCase(o2s);
                }
                return o2s.compareToIgnoreCase(o1s);
            }
        });
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode value) {
        return TaskColumn.handleIPBlockCondition(e, value);
    }

    public boolean onDoubleClick(final MouseEvent e, final AbstractNode obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<HistoryEntry> his;
                if (obj instanceof DownloadLink && (his = ((DownloadLink)obj).getHistory()) != null) {
                    ToolTipController.getInstance().show((ExtTooltip)CandidateTooltip.create(e.getPoint(), obj));
                }
            }
        });
        return true;
    }

    public static boolean handleIPBlockCondition(MouseEvent e, final AbstractNode value) {
        if (value instanceof DownloadLink) {
            ConditionalSkipReason conditionalSkipReason;
            DownloadLink dl = (DownloadLink)value;
            if (((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).isPremiumAlertTaskColumnEnabled() && dl.getDownloadLinkController() == null && dl.isEnabled() && dl.getLivePlugin() == null && (conditionalSkipReason = dl.getConditionalSkipReason()) != null && !dl.isSkipped() && !FinalLinkState.CheckFinished(dl.getFinalLinkState())) {
                WaitWhileWaitingSkipReasonIsSet waitCondition;
                PluginForHost plugin = dl.getDefaultPlugin();
                if (plugin == null || !plugin.isPremiumEnabled()) {
                    return false;
                }
                if (conditionalSkipReason instanceof WaitWhileWaitingSkipReasonIsSet && (waitCondition = (WaitWhileWaitingSkipReasonIsSet)conditionalSkipReason).getCause() == WaitingSkipReason.CAUSE.IP_BLOCKED && !waitCondition.getConditionalSkipReason().isConditionReached()) {
                    new Thread(){

                        @Override
                        public void run() {
                            PremiumInfoDialog dialog = new PremiumInfoDialog(((DownloadLink)value).getDomainInfo(), _GUI.T.TaskColumn_onSingleClick_object_(((DownloadLink)value).getHost()), "TaskColumnReconnect"){

                                @Override
                                protected String getDescription(DomainInfo info2) {
                                    return _GUI.T.TaskColumn_getDescription_object_(info2.getTld());
                                }

                                public String getDontShowAgainKey() {
                                    return null;
                                }

                                public Dialog.ModalityType getModalityType() {
                                    return Dialog.ModalityType.MODELESS;
                                }
                            };
                            UIOManager.I().show(null, (UserIODefinition)dialog);
                            if (dialog.isDontShowAgainSelected()) {
                                ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setPremiumAlertTaskColumnEnabled(false);
                            }
                        }
                    }.start();
                    return true;
                }
            }
        }
        return false;
    }

    protected void prepareColumn(AbstractNode value) {
        this.fillColumnHelper(this.columnHelper, value);
    }

    public ExtTooltip createToolTip(Point position, AbstractNode value) {
        ArrayList ps = null;
        if (value instanceof FilePackage) {
            FilePackage fp = (FilePackage)value;
            FilePackageView view = fp.getView();
            ps = view.getPluginStates();
        }
        if (ps != null && ps.size() > 0) {
            ArrayList<MultiLineLabelTooltip.LabelInfo> lbls = new ArrayList<MultiLineLabelTooltip.LabelInfo>(ps.size());
            for (FilePackageView.PluginState p : ps) {
                lbls.add(new MultiLineLabelTooltip.LabelInfo(p.getDescription(), p.getIcon()));
            }
            return new MultiLineLabelTooltip(lbls);
        }
        return super.createToolTip(position, (Object)value);
    }

    public void fillColumnHelper(ColumnHelper columnHelper, AbstractNode value) {
        if (value instanceof DownloadLink) {
            DownloadLink link = (DownloadLink)value;
            PluginProgress prog = link.getPluginProgress();
            if (prog != null) {
                columnHelper.icon = prog.getIcon((Object)this);
                columnHelper.string = prog.getMessage((Object)this);
                columnHelper.tooltip = null;
                return;
            }
            ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
            if (conditionalSkipReason != null && !conditionalSkipReason.isConditionReached()) {
                columnHelper.icon = conditionalSkipReason.getIcon((Object)this, null);
                columnHelper.string = conditionalSkipReason.getMessage((Object)this, null);
                columnHelper.tooltip = null;
                return;
            }
            SkipReason skipReason = link.getSkipReason();
            if (skipReason != null) {
                columnHelper.icon = skipReason.getIcon((Object)this, 18);
                columnHelper.string = skipReason.getExplanation((Object)this, link);
                columnHelper.tooltip = null;
                return;
            }
            FinalLinkState finalLinkState = link.getFinalLinkState();
            if (finalLinkState != null) {
                if (FinalLinkState.CheckFailed(finalLinkState)) {
                    columnHelper.icon = finalLinkState.getIcon(16);
                    columnHelper.string = finalLinkState.getExplanation((Object)this, link);
                    columnHelper.tooltip = null;
                    return;
                }
                ExtractionStatus extractionStatus = link.getExtractionStatus();
                if (extractionStatus != null) {
                    String iconKey = finalLinkState.getIconKey();
                    switch (extractionStatus) {
                        case ERROR: 
                        case ERROR_PW: 
                        case ERROR_CRC: 
                        case ERROR_NOT_ENOUGH_SPACE: 
                        case ERRROR_FILE_NOT_FOUND: {
                            if ("false".equals(iconKey)) {
                                columnHelper.icon = this.falseIconExtractedFailed;
                            } else if ("true".equals(iconKey)) {
                                columnHelper.icon = this.trueIconExtractedFailed;
                            } else if ("ok".equals(iconKey)) {
                                columnHelper.icon = this.okIconExtractedFailed;
                            } else if ("true-orange".equals(iconKey)) {
                                columnHelper.icon = this.trueOrangaIconExtractedFailed;
                            } else {
                                columnHelper.icon = this.trueIconExtractedFailed;
                            }
                            columnHelper.string = extractionStatus.getExplanation() + ": " + finalLinkState.getExplanation((Object)this, link);
                            columnHelper.tooltip = null;
                            return;
                        }
                        case SUCCESSFUL: {
                            if ("false".equals(iconKey)) {
                                columnHelper.icon = this.falseIconExtracted;
                            } else if ("true".equals(iconKey)) {
                                columnHelper.icon = this.trueIconExtracted;
                            } else if ("ok".equals(iconKey)) {
                                columnHelper.icon = this.okIconExtracted;
                            } else if ("true-orange".equals(iconKey)) {
                                columnHelper.icon = this.trueOrangaIconExtracted;
                            } else {
                                columnHelper.icon = this.trueIconExtracted;
                            }
                            columnHelper.string = extractionStatus.getExplanation() + ": " + finalLinkState.getExplanation((Object)this, link);
                            columnHelper.tooltip = null;
                            return;
                        }
                        case RUNNING: {
                            columnHelper.icon = this.extracting;
                            columnHelper.string = extractionStatus.getExplanation();
                            columnHelper.tooltip = null;
                            return;
                        }
                    }
                }
                columnHelper.icon = finalLinkState.getIcon(16);
                columnHelper.string = finalLinkState.getExplanation((Object)this, link);
                columnHelper.tooltip = null;
                return;
            }
            SingleDownloadController controller = link.getDownloadLinkController();
            if (controller == null) {
                columnHelper.icon = null;
                columnHelper.tooltip = null;
                columnHelper.string = "";
            } else if (!controller.isAlive() && controller.getState() != Thread.State.NEW) {
                columnHelper.icon = this.finalizingIcon;
                columnHelper.string = this.finalizingString;
                columnHelper.tooltip = null;
            } else if (controller.getStartTimestamp() != -1L) {
                columnHelper.icon = this.startingIcon;
                columnHelper.string = this.runningText;
                columnHelper.tooltip = null;
            } else {
                columnHelper.icon = this.startingIcon;
                columnHelper.string = this.startingString;
                columnHelper.tooltip = null;
            }
        } else {
            PluginProgress prog;
            FilePackage fp = (FilePackage)value;
            FilePackageView view = fp.getView();
            if (!view.isRunning() && (prog = view.getSinglePluginProgress()) != null && prog.isDisplayInProgressColumnEnabled()) {
                columnHelper.icon = prog.getIcon((Object)this);
                columnHelper.string = prog.getMessage((Object)this);
                columnHelper.tooltip = null;
                return;
            }
            PluginStateCollection ps = view.getPluginStates();
            if (ps != null && ps.size() > 0) {
                columnHelper.icon = (Icon)((Object)ps.getMergedIcon());
                columnHelper.string = ps.isMultiline() ? "" : ps.getText();
                columnHelper.tooltip = ps.getText();
                return;
            }
            if (view.isFinished()) {
                columnHelper.icon = this.trueIcon;
                columnHelper.string = this.finishedText;
                columnHelper.tooltip = null;
                return;
            }
            if (view.getETA() != -1L) {
                columnHelper.icon = null;
                columnHelper.string = this.runningText;
                columnHelper.tooltip = null;
                return;
            }
            columnHelper.tooltip = null;
            columnHelper.icon = null;
            columnHelper.string = "";
        }
    }

    protected String getTooltipText(AbstractNode obj) {
        this.fillColumnHelper(this.columnHelper, obj);
        String ret = this.columnHelper.tooltip;
        if (ret == null) {
            ret = this.columnHelper.string;
        }
        return ret;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    protected Icon getIcon(AbstractNode value) {
        return this.columnHelper.icon;
    }

    public String getStringValue(AbstractNode value) {
        return this.columnHelper.string;
    }

    public static class ColumnHelper {
        private Icon icon = null;
        private String string = null;
        public String tooltip;

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }
    }
}

