/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.columns.candidatetooltip;

import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import jd.controlling.downloadcontroller.HistoryEntry;
import jd.gui.swing.jdgui.GUIUtils;
import jd.plugins.Account;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtDateColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.columns.CandidateAccountColumn;
import org.jdownloader.images.BadgeIcon;

public class CandidateTooltipTableModel
extends ExtTableModel<HistoryEntry> {
    private static final long serialVersionUID = 3120481189794897020L;

    public CandidateTooltipTableModel(List<HistoryEntry> history) {
        super("CandidateTooltipTableModel");
        this._fireTableStructureChanged(history, true);
    }

    protected void initColumns() {
        DateColumn sorton = new DateColumn(_GUI.T.CandidateTooltipTableModel_time());
        this.addColumn((ExtColumn)sorton);
        this.addColumn((ExtColumn)new AccountColumn(_GUI.T.CandidateTooltipTableModel_account()));
        this.addColumn((ExtColumn)new GatewayColumn(_GUI.T.CandidateTooltipTableModel_gateway()));
        this.addColumn((ExtColumn)new ResultColumn(_GUI.T.CandidateTooltipTableModel_result()));
        this.sortColumn = sorton;
    }

    public static final class DateColumn
    extends ExtDateColumn<HistoryEntry>
    implements MaxWidthProvider {
        private int maxWidth;

        protected String getDateFormatString() {
            return _GUI.T.CandidateTooltipTableModel_getDateFormatString_timeformat();
        }

        public String getSortOrderIdentifier() {
            return "ASC";
        }

        public DateColumn(String string) {
            super(string);
        }

        @Override
        public int getMaxPreferredWitdh() {
            return this.maxWidth;
        }

        public int getMinWidth() {
            return 100;
        }

        public boolean isSortable(HistoryEntry obj) {
            return false;
        }

        protected MigPanel createRendererPanel() {
            this.rendererField = new JLabel();
            this.rendererIcon = new JLabel();
            return new RendererMigPanel("ins 0", "[]0[grow,fill]", "[grow,fill]");
        }

        public void configureRendererComponent(HistoryEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.prepareColumn(value);
            this.rendererIcon.setIcon(this.getIcon(value));
            String str = this.getStringValue(value);
            if (str == null) {
                str = "";
            }
            this.rendererField.setText(str);
            this.maxWidth = Math.max(this.renderer.getPreferredSize().width, this.maxWidth);
        }

        protected Date getDate(HistoryEntry o2, Date date) {
            return new Date(o2.getCreateTime());
        }
    }

    public static final class AccountColumn
    extends ExtTextColumn<HistoryEntry>
    implements MaxWidthProvider {
        private CandidateAccountColumn delegate = new CandidateAccountColumn();
        private int maxWidth;

        public boolean isSortable(HistoryEntry obj) {
            return false;
        }

        public int getMinWidth() {
            return 100;
        }

        @Override
        public int getMaxPreferredWitdh() {
            return this.maxWidth;
        }

        public AccountColumn(String name) {
            super(name);
        }

        protected MigPanel createRendererPanel() {
            this.rendererField = new JLabel();
            this.rendererIcon = new JLabel();
            return new RendererMigPanel("ins 0", "[]0[grow,fill]", "[grow,fill]");
        }

        public void configureRendererComponent(HistoryEntry history, boolean isSelected, boolean hasFocus, int row, int column) {
            this.prepareColumn(history);
            Object icon = history.getAccountIcon(18);
            String str = history.getAccountStatus();
            Account account = history.getAccount();
            if (account != null) {
                icon = icon == null ? account.getDomainInfo().getFavIcon() : new BadgeIcon(account.getDomainInfo(), IconIO.getScaledInstance((Icon)icon, (int)12, (int)12), 4, 2);
                String accountType = null;
                switch (history.getAccountType()) {
                    case MULTI: {
                        accountType = _GUI.T.CandidateAccountColumn_account_multi(account.getType().getLabel());
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    case ORIGINAL: {
                        accountType = _GUI.T.CandidateAccountColumn_account_original(account.getType().getLabel());
                    }
                }
                str = !StringUtils.isEmpty(accountType) ? _GUI.T.CandidateAccountColumn_getStringValue_account_type(GUIUtils.getAccountName((String)account.getUser()), account.getHosterByPlugin(), accountType) : _GUI.T.CandidateAccountColumn_getStringValue_account(GUIUtils.getAccountName((String)account.getUser()), account.getHosterByPlugin());
            } else {
                icon = icon == null ? history.getLink().getDomainInfo().getFavIcon() : new BadgeIcon(history.getLink().getDomainInfo(), IconIO.getScaledInstance((Icon)icon, (int)12, (int)12), 4, 2);
            }
            if (str == null) {
                str = "";
            }
            this.rendererField.setText(str);
            this.rendererIcon.setIcon((Icon)icon);
            this.maxWidth = Math.max(this.renderer.getPreferredSize().width, this.maxWidth);
        }

        public String getStringValue(HistoryEntry value) {
            return null;
        }
    }

    public static final class ResultColumn
    extends ExtTextColumn<HistoryEntry>
    implements MaxWidthProvider {
        private int maxWidth;

        public boolean isSortable(HistoryEntry obj) {
            return false;
        }

        public ResultColumn(String name) {
            super(name);
        }

        public int getMinWidth() {
            return 100;
        }

        @Override
        public int getMaxPreferredWitdh() {
            return this.maxWidth;
        }

        protected MigPanel createRendererPanel() {
            this.rendererField = new JLabel();
            this.rendererIcon = new JLabel();
            return new RendererMigPanel("ins 0", "[]0[grow,fill]", "[grow,fill]");
        }

        public void configureRendererComponent(HistoryEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.prepareColumn(value);
            this.rendererIcon.setIcon(value.getResultIcon(18));
            String str = value.getResultStatus();
            if (str == null) {
                str = "";
            }
            this.rendererField.setText(str);
            this.maxWidth = Math.max(this.renderer.getPreferredSize().width, this.maxWidth);
        }

        public String getStringValue(HistoryEntry value) {
            return null;
        }
    }

    public static final class GatewayColumn
    extends ExtTextColumn<HistoryEntry>
    implements MaxWidthProvider {
        private int maxWidth;

        public boolean isSortable(HistoryEntry obj) {
            return false;
        }

        public GatewayColumn(String name) {
            super(name);
        }

        public int getMinWidth() {
            return 100;
        }

        @Override
        public int getMaxPreferredWitdh() {
            return this.maxWidth;
        }

        protected MigPanel createRendererPanel() {
            this.rendererField = new JLabel();
            this.rendererIcon = new JLabel();
            return new RendererMigPanel("ins 0", "[]0[grow,fill]", "[grow,fill]");
        }

        public void configureRendererComponent(HistoryEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.prepareColumn(value);
            this.rendererIcon.setIcon(value.getGatewayIcon(18));
            String str = value.getGatewayStatus();
            if (str == null) {
                str = "";
            }
            this.rendererField.setText(str);
            this.maxWidth = Math.max(this.renderer.getPreferredSize().width, this.maxWidth);
        }

        public String getStringValue(HistoryEntry value) {
            return null;
        }
    }

    public static interface MaxWidthProvider {
        public int getMaxPreferredWitdh();
    }
}

