/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.contextmenumanager;

import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.gui.mainmenu.container.OptionalContainer;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.context.CheckStatusAction;
import org.jdownloader.gui.views.components.packagetable.context.EnabledAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityDefaultAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityHighAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityHigherAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityHighestAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityLowAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityLowerAction;
import org.jdownloader.gui.views.components.packagetable.context.PriorityLowestAction;
import org.jdownloader.gui.views.components.packagetable.context.RenameAction;
import org.jdownloader.gui.views.components.packagetable.context.SetCommentAction;
import org.jdownloader.gui.views.components.packagetable.context.SetDownloadPassword;
import org.jdownloader.gui.views.components.packagetable.context.URLEditorAction;
import org.jdownloader.gui.views.downloads.action.CollapseExpandContextAction;
import org.jdownloader.gui.views.downloads.action.ConfirmHashValuesDownloadAction;
import org.jdownloader.gui.views.downloads.action.CopyGenericContextAction;
import org.jdownloader.gui.views.downloads.action.CreateDLCAction;
import org.jdownloader.gui.views.downloads.action.ForceDownloadAction;
import org.jdownloader.gui.views.downloads.action.GenericChunksAction;
import org.jdownloader.gui.views.downloads.action.GenericDeleteFromDownloadlistContextAction;
import org.jdownloader.gui.views.downloads.action.MarkDownloadFinishedAction;
import org.jdownloader.gui.views.downloads.action.MenuManagerAction;
import org.jdownloader.gui.views.downloads.action.MergeSameNamedPackagesAction;
import org.jdownloader.gui.views.downloads.action.MergeToPackageAction;
import org.jdownloader.gui.views.downloads.action.OpenDirectoryAction;
import org.jdownloader.gui.views.downloads.action.OpenFileAction;
import org.jdownloader.gui.views.downloads.action.OpenInBrowserAction;
import org.jdownloader.gui.views.downloads.action.PackageNameAction;
import org.jdownloader.gui.views.downloads.action.PropertiesAction;
import org.jdownloader.gui.views.downloads.action.ResetAction;
import org.jdownloader.gui.views.downloads.action.ResumeAction;
import org.jdownloader.gui.views.downloads.action.RunCheckSumAction;
import org.jdownloader.gui.views.downloads.action.SetDownloadFolderInDownloadTableAction;
import org.jdownloader.gui.views.downloads.action.SkipAction;
import org.jdownloader.gui.views.downloads.action.SplitPackagesByHost;
import org.jdownloader.gui.views.downloads.action.StopsignAction;
import org.jdownloader.gui.views.downloads.context.submenu.DeleteMenuContainer;
import org.jdownloader.gui.views.downloads.context.submenu.DevChunksMenuContainer;
import org.jdownloader.gui.views.downloads.context.submenu.MoreMenuContainer;
import org.jdownloader.gui.views.downloads.context.submenu.PriorityMenuContainer;
import org.jdownloader.gui.views.downloads.context.submenu.SettingsMenuContainer;
import org.jdownloader.gui.views.downloads.contextmenumanager.DownloadsTablePluginLink;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.gui.views.linkgrabber.contextmenu.AddContainerContextMenuAction;
import org.jdownloader.gui.views.linkgrabber.contextmenu.AddLinksContextMenuAction;
import org.jdownloader.gui.views.linkgrabber.contextmenu.SortAction;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class MenuManagerDownloadTableContext
extends ContextMenuManager<FilePackage, DownloadLink> {
    private static final MenuManagerDownloadTableContext INSTANCE = new MenuManagerDownloadTableContext();

    public static MenuManagerDownloadTableContext getInstance() {
        return INSTANCE;
    }

    private MenuManagerDownloadTableContext() {
    }

    @Override
    public boolean isAcceleratorsEnabled() {
        return true;
    }

    @Override
    public MenuContainerRoot createDefaultStructure() {
        MenuContainerRoot mr = new MenuContainerRoot();
        mr.add(AddLinksContextMenuAction.class);
        mr.add(AddContainerContextMenuAction.class);
        mr.add(new SeparatorData());
        mr.add(this.createSettingsMenu());
        mr.add(new SeparatorData());
        mr.add(new DownloadsTablePluginLink());
        mr.add(new SeparatorData());
        mr.add(new MenuItemData(new ActionData(OpenFileAction.class)));
        mr.add(new MenuItemData(new ActionData(OpenDirectoryAction.class)));
        mr.add(new MenuItemData(new ActionData(SortAction.class)));
        mr.add(new MenuItemData(new ActionData(EnabledAction.class)));
        mr.add(new MenuItemData(new ActionData(SkipAction.class)));
        mr.add(new SeparatorData());
        mr.add(new MenuItemData(new ActionData(ForceDownloadAction.class)));
        mr.add(new MenuItemData(new ActionData(StopsignAction.class)));
        mr.add(new SeparatorData());
        mr.add(this.createMoreMenu());
        mr.add(new SeparatorData());
        mr.add(MenuManagerDownloadTableContext.setAccelerator(new MenuItemData(MenuManagerDownloadTableContext.setName(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteAll", true), "delete"), _GUI.T.DeleteQuickAction_DeleteQuickAction_object_())), CrossSystem.getDeleteShortcut()));
        mr.add(this.createDeleteMenu());
        mr.add(new SeparatorData());
        mr.add(PropertiesAction.class);
        mr.add(new SeparatorData());
        mr.add(new MenuItemData(new ActionData(MenuManagerAction.class)));
        OptionalContainer opt = new OptionalContainer(false);
        mr.add(opt);
        opt.add(CollapseExpandContextAction.class);
        opt.add(CopyGenericContextAction.class);
        opt.add(MarkDownloadFinishedAction.class);
        return mr;
    }

    private MenuItemData createDeleteMenu() {
        DeleteMenuContainer delete = new DeleteMenuContainer();
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteDisabled", true), "remove_disabled"));
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteFailed", true), "remove_failed"));
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteFinished", true), "remove_ok"));
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteOffline", true), "remove_offline"));
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteAll", true).putSetup("includeUnselectedLinks", true).putSetup("includeSelectedLinks", false), "ok"));
        delete.add(MenuManagerDownloadTableContext.setIconKey(new ActionData(GenericDeleteFromDownloadlistContextAction.class).putSetup("deleteAll", true).putSetup("deleteMode", GraphicalUserInterfaceSettings.DeleteFileOptions.REMOVE_LINKS_AND_RECYCLE_FILES.name()), "delete"));
        return delete;
    }

    private MenuItemData createMoreMenu() {
        MoreMenuContainer more = new MoreMenuContainer();
        more.add(new MenuItemData(new ActionData(ResumeAction.class)));
        more.add(new MenuItemData(new ActionData(ResetAction.class)));
        more.add(new SeparatorData());
        more.add(new MenuItemData(new ActionData(MergeToPackageAction.class)));
        more.add(new MenuItemData(new ActionData(SplitPackagesByHost.class)));
        more.add(new MenuItemData(new ActionData(MergeSameNamedPackagesAction.class)));
        more.add(new MenuItemData(new ActionData(RunCheckSumAction.class)));
        more.add(new MenuItemData(new ActionData(ConfirmHashValuesDownloadAction.class)));
        more.add(new MenuItemData(new ActionData(CreateDLCAction.class)));
        return more;
    }

    private MenuItemData createSettingsMenu() {
        SettingsMenuContainer settings = new SettingsMenuContainer();
        settings.add(new MenuItemData(new ActionData(CheckStatusAction.class)));
        settings.add(RenameAction.class);
        settings.add(new MenuItemData(new ActionData(OpenInBrowserAction.class)));
        settings.add(URLEditorAction.class);
        settings.add(new SeparatorData());
        settings.add(new MenuItemData(new ActionData(PackageNameAction.class)));
        settings.add(new MenuItemData(new ActionData(SetDownloadFolderInDownloadTableAction.class)));
        settings.add(new MenuItemData(new ActionData(SetDownloadPassword.class)));
        settings.add(new MenuItemData(new ActionData(SetCommentAction.class)));
        settings.add(this.createPriorityMenu());
        settings.add(this.createChunksMenu());
        return settings;
    }

    private MenuItemData createPriorityMenu() {
        PriorityMenuContainer priority = new PriorityMenuContainer();
        priority.add(new MenuItemData(new ActionData(PriorityLowestAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityLowerAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityLowAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityDefaultAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityHighAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityHigherAction.class)));
        priority.add(new MenuItemData(new ActionData(PriorityHighestAction.class)));
        return priority;
    }

    private MenuItemData createChunksMenu() {
        DevChunksMenuContainer chunksMenu = new DevChunksMenuContainer();
        for (int chunks = 20; chunks >= 0; --chunks) {
            chunksMenu.add(new MenuItemData(new ActionData(GenericChunksAction.class).putSetup("CHUNKS", chunks)));
        }
        return chunksMenu;
    }

    @Override
    public String getFileExtension() {
        return ".jdDLMenu";
    }

    @Override
    public String getName() {
        return _GUI.T.DownloadListContextMenuManager_getName();
    }

    @Override
    protected void updateGui() {
        new EDTRunner(){

            protected void runInEDT() {
                ((DownloadsTable)DownloadsTableModel.getInstance().getTable()).updateContextShortcuts();
            }
        };
    }

    @Override
    protected String getStorageKey() {
        return "DownloadTableContext";
    }
}

