/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.overviewpanel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.Timer;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.event.GUIListener;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTableModel;
import org.jdownloader.gui.views.downloads.overviewpanel.DataEntry;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public abstract class AbstractOverviewPanel<T, ParentType extends AbstractPackageNode<ChildrenType, ParentType>, ChildrenType extends AbstractPackageChildrenNode<ParentType>>
extends MigPanel
implements GUIListener,
GenericConfigEventListener<Boolean>,
HierarchyListener {
    private List<DataEntry<T>> dataEntries;
    protected final AtomicBoolean visible = new AtomicBoolean(false);
    protected final NullsafeAtomicReference<Timer> updateTimer = new NullsafeAtomicReference(null);
    protected final AtomicBoolean hasSelection = new AtomicBoolean(false);
    protected final DelayedRunnable slowDelayer;
    protected final DelayedRunnable fastDelayer;
    private final GenericConfigEventListener<Boolean> relayoutListener;
    protected final PackageControllerTableModel<ParentType, ChildrenType> tableModel;
    private static final ScheduledExecutorService SERVICE = DelayedRunnable.getNewScheduledExecutorService();

    public AbstractOverviewPanel(PackageControllerTableModel<ParentType, ChildrenType> tableModel) {
        super("ins " + LAFOptions.getInstance().getExtension().customizeOverviewPanelInsets(), "[][grow,fill][]", "[grow,fill]");
        this.tableModel = tableModel;
        LAFOptions.getInstance().applyPanelBackground((JComponent)((Object)this));
        GUIEventSender.getInstance().addListener(this, true);
        final MigPanel info = new MigPanel("ins 2 0 0 0", "[grow]10[grow]", "[grow,fill]2[grow,fill]");
        info.setOpaque(false);
        this.relayoutListener = new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                new EDTRunner(){

                    protected void runInEDT() {
                        AbstractOverviewPanel.this.layoutInfoPanel(info);
                        AbstractOverviewPanel.this.update();
                        AbstractOverviewPanel.this.revalidate();
                    }
                };
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        };
        this.layoutInfoPanel(info);
        this.add((Component)info, "pushy,growy");
        this.slowDelayer = new DelayedRunnable(SERVICE, 500L, 5000L){

            public void delayedrun() {
                AbstractOverviewPanel.this.update();
            }
        };
        this.fastDelayer = new DelayedRunnable(SERVICE, 50L, 200L){

            public void delayedrun() {
                AbstractOverviewPanel.this.update();
            }
        };
        CFG_GUI.OVERVIEW_PANEL_TOTAL_INFO_VISIBLE.getEventSender().addListener((EventListener)this, true);
        CFG_GUI.OVERVIEW_PANEL_SELECTED_INFO_VISIBLE.getEventSender().addListener((EventListener)this, true);
        CFG_GUI.OVERVIEW_PANEL_VISIBLE_ONLY_INFO_VISIBLE.getEventSender().addListener((EventListener)this, true);
        CFG_GUI.OVERVIEW_PANEL_SMART_INFO_VISIBLE.getEventSender().addListener((EventListener)this, true);
        this.addHierarchyListener(this);
        this.onConfigValueModified(null, null);
        SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                AbstractOverviewPanel.this.visible.set(AbstractOverviewPanel.this.isViewActive());
                AbstractOverviewPanel.this.fastDelayer.run();
            }
        });
        this.onConfigValueModified(null, null);
    }

    protected boolean isViewActive() {
        return (Boolean)new EDTHelper<Boolean>(){

            public Boolean edtRun() {
                return AbstractOverviewPanel.this.isActiveView(JDGui.getInstance().getMainTabbedPane().getSelectedView());
            }
        }.getReturnValue();
    }

    /*
     * WARNING - void declaration
     */
    protected void layoutInfoPanel(MigPanel info) {
        info.removeAll();
        HashMap<String, GraphicalUserInterfaceSettings.Position> map = CFG_GUI.CFG.getOverviewPositions();
        boolean save = false;
        if (map == null) {
            map = new HashMap();
            save = true;
        }
        HashMap<String, DataEntry<T>> idMap = new HashMap<String, DataEntry<T>>();
        this.dataEntries = new ArrayList<DataEntry<T>>();
        for (DataEntry<T> s : this.createDataEntries()) {
            Object ret = map.get(s.getId());
            if (ret == null) {
                ret = new GraphicalUserInterfaceSettings.Position();
                map.put(s.getId(), (GraphicalUserInterfaceSettings.Position)ret);
                save = true;
            }
            idMap.put(s.getId(), s);
            if (s.getVisibleKeyHandler() == null || s.getVisibleKeyHandler().isEnabled()) {
                this.dataEntries.add(s);
            }
            if (s.getVisibleKeyHandler() == null) continue;
            s.getVisibleKeyHandler().getEventSender().addListener(this.relayoutListener);
        }
        ArrayList<DataEntry<T>> row1 = new ArrayList<DataEntry<T>>();
        ArrayList<DataEntry<T>> row2 = new ArrayList<DataEntry<T>>();
        block1: for (Map.Entry entry : map.entrySet()) {
            DataEntry dataEntry = (DataEntry)idMap.get(entry.getKey());
            if (dataEntry == null) continue;
            int y = ((GraphicalUserInterfaceSettings.Position)entry.getValue()).getY();
            ArrayList<DataEntry<T>> row = y == 0 ? row1 : row2;
            for (int x = ((GraphicalUserInterfaceSettings.Position)entry.getValue()).getX(); x >= 0 && y >= 0; ++x) {
                while (x >= row.size()) {
                    row.add(null);
                }
                if (row.get(x) != null) {
                    continue;
                }
                row.set(x, dataEntry);
                idMap.remove(dataEntry.getId());
                continue block1;
            }
        }
        block4: for (int i = 0; i < this.dataEntries.size(); ++i) {
            boolean bl;
            DataEntry<T> dataEntry = this.dataEntries.get(i);
            if (!idMap.containsKey(dataEntry.getId())) continue;
            if (i % 2 == 0) {
                bl = false;
                while (true) {
                    void var9_19;
                    if (var9_19 >= row1.size()) {
                        row1.add(null);
                        continue;
                    }
                    if (row1.get((int)var9_19) == null) {
                        row1.set((int)var9_19, dataEntry);
                        continue block4;
                    }
                    ++var9_19;
                }
            }
            bl = false;
            while (true) {
                void var9_20;
                if (var9_20 >= row2.size()) {
                    row2.add(null);
                    continue;
                }
                if (row2.get((int)var9_20) == null) {
                    row2.set((int)var9_20, dataEntry);
                    continue block4;
                }
                ++var9_20;
            }
        }
        if (save) {
            CFG_GUI.CFG.setOverviewPositions(map);
        }
        for (DataEntry dataEntry : row1) {
            if (dataEntry == null) continue;
            dataEntry.addTo(info);
        }
        boolean first = true;
        for (DataEntry dataEntry : row2) {
            if (dataEntry == null) continue;
            if (first) {
                dataEntry.addTo(info, ",newline");
            } else {
                dataEntry.addTo(info);
            }
            first = false;
        }
    }

    public List<DataEntry<T>> getDataEntries() {
        return this.dataEntries;
    }

    protected abstract List<DataEntry<T>> createDataEntries();

    public void removeListeners() {
        new EDTRunner(){

            protected void runInEDT() {
                AbstractOverviewPanel.this.stopUpdateTimer();
                GUIEventSender.getInstance().removeListener(AbstractOverviewPanel.this);
                CFG_GUI.OVERVIEW_PANEL_TOTAL_INFO_VISIBLE.getEventSender().removeListener((EventListener)AbstractOverviewPanel.this);
                CFG_GUI.OVERVIEW_PANEL_SELECTED_INFO_VISIBLE.getEventSender().removeListener((EventListener)AbstractOverviewPanel.this);
                CFG_GUI.OVERVIEW_PANEL_VISIBLE_ONLY_INFO_VISIBLE.getEventSender().removeListener((EventListener)AbstractOverviewPanel.this);
                CFG_GUI.OVERVIEW_PANEL_SMART_INFO_VISIBLE.getEventSender().removeListener((EventListener)AbstractOverviewPanel.this);
                AbstractOverviewPanel.this.removeHierarchyListener(AbstractOverviewPanel.this);
            }
        };
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (!this.isDisplayable()) {
            this.stopUpdateTimer();
        } else {
            this.startUpdateTimer();
            this.fastDelayer.run();
        }
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        this.tableModel.getTable().getSelectionInfo(new PackageControllerTable.EDTSelectionInfoCallback<ParentType, ChildrenType>(){

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public void onSelectionInfo(SelectionInfo<ParentType, ChildrenType> selectionInfo) {
                boolean containsSelection = !selectionInfo.isEmpty();
                AbstractOverviewPanel.this.hasSelection.set(containsSelection);
                AbstractOverviewPanel.this.fastDelayer.run();
            }
        }, PackageControllerTable.SelectionType.SELECTED);
    }

    @Override
    public void onGuiMainTabSwitch(View oldView, final View newView) {
        new EDTRunner(){

            protected void runInEDT() {
                if (AbstractOverviewPanel.this.isActiveView(newView)) {
                    AbstractOverviewPanel.this.visible.set(true);
                    AbstractOverviewPanel.this.startUpdateTimer();
                    AbstractOverviewPanel.this.fastDelayer.run();
                } else {
                    AbstractOverviewPanel.this.visible.set(false);
                    AbstractOverviewPanel.this.stopUpdateTimer();
                }
            }
        };
    }

    protected abstract boolean isActiveView(View var1);

    protected void startUpdateTimer() {
        Timer currentTimer = (Timer)this.updateTimer.get();
        if (currentTimer != null && currentTimer.isRunning()) {
            return;
        }
        if (!DownloadWatchDog.getInstance().isRunning()) {
            return;
        }
        currentTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(e.getSource() instanceof Timer)) {
                    return;
                }
                if (e.getSource() != AbstractOverviewPanel.this.updateTimer.get() || !AbstractOverviewPanel.this.isDisplayable()) {
                    Timer timer = (Timer)e.getSource();
                    AbstractOverviewPanel.this.updateTimer.compareAndSet((Object)timer, null);
                    timer.stop();
                    return;
                }
                AbstractOverviewPanel.this.fastDelayer.run();
            }
        });
        currentTimer.setRepeats(true);
        this.updateTimer.set((Object)currentTimer);
        currentTimer.start();
    }

    protected void stopUpdateTimer() {
        Timer old = (Timer)this.updateTimer.getAndSet(null);
        if (old != null) {
            old.stop();
        }
    }

    public void update() {
        Object selected;
        Object total;
        Object filtered;
        if (!this.visible.get()) {
            return;
        }
        boolean smart = CFG_GUI.OVERVIEW_PANEL_SMART_INFO_VISIBLE.isEnabled();
        boolean visibleOnly = CFG_GUI.OVERVIEW_PANEL_VISIBLE_ONLY_INFO_VISIBLE.isEnabled();
        boolean selectedOnly = CFG_GUI.OVERVIEW_PANEL_SELECTED_INFO_VISIBLE.isEnabled();
        boolean totalVisible = CFG_GUI.OVERVIEW_PANEL_TOTAL_INFO_VISIBLE.isEnabled();
        final boolean containsSelection = this.hasSelection.get();
        if (smart || !visibleOnly && !totalVisible && !selectedOnly) {
            if (containsSelection) {
                filtered = null;
                total = null;
                selected = this.createSelected();
            } else {
                filtered = this.createFiltered();
                total = null;
                selected = null;
            }
        } else {
            total = totalVisible ? this.createTotal() : null;
            filtered = visibleOnly ? this.createFiltered() : null;
            selected = selectedOnly ? this.createSelected() : null;
        }
        new EDTRunner(){

            protected void runInEDT() {
                if (!AbstractOverviewPanel.this.isDisplayable() || !AbstractOverviewPanel.this.visible.get()) {
                    return;
                }
                for (DataEntry entry : AbstractOverviewPanel.this.dataEntries) {
                    entry.updateVisibility(containsSelection);
                    this.set(entry);
                }
            }

            private void set(DataEntry<T> dataEntry) {
                if (dataEntry != null) {
                    dataEntry.setData(total, filtered, selected);
                }
            }
        }.waitForEDT();
    }

    protected abstract T createSelected();

    protected abstract T createFiltered();

    protected abstract T createTotal();
}

