/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.properties;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.MigPanel;
import org.jdownloader.gui.views.downloads.properties.DownloadLinkPropertiesPanel;
import org.jdownloader.gui.views.downloads.properties.FilePackagePropertiesPanel;
import org.jdownloader.gui.views.downloads.table.DownloadsTable;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class DownloadPropertiesBasePanel
extends MigPanel {
    private static final long serialVersionUID = -195024600818162517L;
    private final FilePackagePropertiesPanel pkgPanel;
    private final DownloadLinkPropertiesPanel linkPanel;

    public DownloadPropertiesBasePanel(DownloadsTable table2) {
        super(LAFOptions.getInstance().getExtension().customizeLinkPropertiesPanelLayout(), "[grow,fill]", "[grow,fill]");
        LAFOptions.getInstance().applyPanelBackground((JComponent)((Object)this));
        this.pkgPanel = new FilePackagePropertiesPanel();
        this.linkPanel = new DownloadLinkPropertiesPanel();
        this.add((Component)((Object)this.pkgPanel), "hidemode 3");
        this.add((Component)((Object)this.linkPanel), "hidemode 3");
        this.pkgPanel.setVisible(false);
        this.linkPanel.setVisible(false);
        LAFOptions.getInstance().getExtension().customizeLinkPropertiesPanel((JPanel)((Object)this));
    }

    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        if (CFG_GUI.CFG.isPropertiesPanelHeightNormalized()) {
            ret.height = Math.max(this.pkgPanel.getPreferredSize().height, this.linkPanel.getPreferredSize().height);
        }
        return ret;
    }

    public void update(AbstractNode objectbyRow) {
        if (objectbyRow instanceof FilePackage) {
            FilePackage pkg = (FilePackage)objectbyRow;
            this.linkPanel.setVisible(false);
            this.pkgPanel.setVisible(true);
            this.linkPanel.setSelectedItem(null);
            this.pkgPanel.setSelectedItem(pkg);
        } else if (objectbyRow instanceof DownloadLink) {
            DownloadLink link = (DownloadLink)objectbyRow;
            this.linkPanel.setVisible(true);
            this.pkgPanel.setVisible(false);
            this.pkgPanel.setSelectedItem(null);
            this.linkPanel.setSelectedItem(link);
        } else {
            this.linkPanel.setVisible(false);
            this.pkgPanel.setVisible(false);
            this.linkPanel.setSelectedItem(null);
            this.pkgPanel.setSelectedItem(null);
        }
    }

    public void fillPopup(JPopupMenu pu) {
        if (this.linkPanel.isVisible()) {
            this.linkPanel.fillPopup(pu);
        } else if (this.pkgPanel.isVisible()) {
            this.pkgPanel.fillPopup(pu);
        }
    }

    public void refreshAfterTabSwitch() {
        this.pkgPanel.refresh();
        this.linkPanel.refresh();
    }

    public void save() {
        if (this.linkPanel.isVisible()) {
            this.linkPanel.save();
        } else {
            this.linkPanel.removeAbstractNodeProperties();
        }
        if (this.pkgPanel.isVisible()) {
            this.pkgPanel.save();
        } else {
            this.pkgPanel.removeAbstractNodeProperties();
        }
    }
}

