/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.downloads.properties;

import java.awt.Component;
import java.awt.Insets;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.swing.components.ExtButton;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.properties.DownloadPropertiesBasePanel;
import org.jdownloader.gui.views.linkgrabber.properties.AbstractPanelHeader;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.updatev2.gui.LAFOptions;

public class DownloadPropertiesHeader
extends AbstractPanelHeader
implements DownloadControllerListener {
    private final DownloadPropertiesBasePanel card;
    private final Icon packageIcon = new AbstractIcon("package_open", 16);
    private volatile WeakReference<AbstractNode> nodeReference = null;

    public DownloadPropertiesHeader(DownloadPropertiesBasePanel loverView) {
        super("", NewTheme.I().getIcon("download", 16));
        this.card = loverView;
    }

    @Override
    protected void onCloseAction() {
    }

    public void update(AbstractNode objectbyRow) {
        if (objectbyRow != null) {
            this.nodeReference = new WeakReference<AbstractNode>(objectbyRow);
            DownloadController.getInstance().getEventSender().addListener((EventListener)this, true);
        } else {
            this.nodeReference = null;
            DownloadController.getInstance().getEventSender().removeListener((EventListener)this);
        }
        this.setTitle(objectbyRow);
    }

    protected void setTitle(final AbstractNode objectbyRow) {
        new EDTRunner(){

            protected void runInEDT() {
                String str;
                if (objectbyRow instanceof FilePackage) {
                    FilePackage pkg = (FilePackage)objectbyRow;
                    DownloadPropertiesHeader.this.setIcon(DownloadPropertiesHeader.this.packageIcon);
                    str = _GUI.T.LinkgrabberPropertiesHeader_update_package(pkg.getName());
                } else if (objectbyRow instanceof DownloadLink) {
                    DownloadLink link = (DownloadLink)objectbyRow;
                    DownloadPropertiesHeader.this.setIcon(link.getLinkInfo().getIcon());
                    str = _GUI.T.LinkgrabberPropertiesHeader_update_link(link.getView().getDisplayName());
                } else {
                    str = "";
                }
                DownloadPropertiesHeader.this.setText(str);
            }
        };
    }

    @Override
    protected void onSettings(ExtButton options) {
        JPopupMenu pu = new JPopupMenu();
        this.card.fillPopup(pu);
        Insets insets = LAFOptions.getInstance().getExtension().customizePopupBorderInsets();
        pu.show((Component)options, -insets.left, -pu.getPreferredSize().height + insets.bottom);
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
    }

    @Override
    public void onDownloadControllerRemovedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
        WeakReference<AbstractNode> nodeReference = this.nodeReference;
        AbstractNode node = null;
        if (property != null && DownloadLinkProperty.Property.NAME.equals((Object)property.getProperty())) {
            node = (AbstractNode)nodeReference.get();
            if (property.getDownloadLink() == node) {
                this.setTitle(node);
            }
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
        WeakReference<AbstractNode> nodeReference = this.nodeReference;
        AbstractNode node = null;
        if (property != null && FilePackageProperty.Property.NAME.equals((Object)property.getProperty())) {
            node = (AbstractNode)nodeReference.get();
            if (property.getFilePackage() == node) {
                this.setTitle(node);
            }
        }
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }
}

