/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import jd.controlling.TaskQueue;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.plugins.DownloadLink;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.swing.exttable.DropHighlighter;
import org.appwork.swing.exttable.ExtCheckBoxMenuItem;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtOverlayRowHighlighter;
import org.appwork.swing.exttable.ExtTable;
import org.appwork.uio.UIOManager;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.CustomizableAppAction;
import org.jdownloader.controlling.contextmenu.MenuContainer;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.contextmenu.gui.ExtPopupMenu;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.downloads.table.HorizontalScrollbarAction;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberPanel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableTransferHandler;
import org.jdownloader.gui.views.linkgrabber.bottombar.MenuManagerLinkgrabberTabBottombar;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.translate._JDT;
import org.jdownloader.updatev2.gui.LAFOptions;

public class LinkGrabberTable
extends PackageControllerTable<CrawledPackage, CrawledLink> {
    private static final long serialVersionUID = 8843600834248098174L;
    private HashMap<KeyStroke, Action> shortCutActions;
    private LogSource logger;
    private static LinkGrabberTable INSTANCE;
    private final boolean dupeManagerEnabled = CFG_GENERAL.CFG.isDupeManagerEnabled();

    public LinkGrabberTable(LinkGrabberPanel linkGrabberPanel, final LinkGrabberTableModel tableModel) {
        super(tableModel);
        INSTANCE = this;
        this.addRowHighlighter((ExtOverlayRowHighlighter)new DropHighlighter(null, new Color(27, 164, 191, 75)));
        if (this.dupeManagerEnabled) {
            this.addRowHighlighter(new ExtOverlayRowHighlighter(null, LAFOptions.getInstance().getColorForLinkgrabberDupeHighlighter()){

                public boolean doHighlight(ExtTable<?> extTable, int row) {
                    AbstractNode object = (AbstractNode)tableModel.getObjectbyRow(row);
                    if (object != null && object instanceof CrawledLink) {
                        return DownloadController.getInstance().hasDownloadLinkByID(((CrawledLink)object).getLinkID());
                    }
                    return false;
                }
            });
        }
        this.setTransferHandler(new LinkGrabberTableTransferHandler(this));
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.logger = LogController.getInstance().getLogger(LinkGrabberTable.class.getName());
        final MigPanel loaderPanel = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[grow,fill][]");
        loaderPanel.setOpaque(false);
        loaderPanel.setBackground(null);
        CircledProgressBar loader = new CircledProgressBar(){

            public int getAnimationFPS() {
                return 25;
            }
        };
        loader.setValueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 1.0f));
        loader.setNonvalueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("botty/robot", 256), 0.1f));
        ((ImagePainter)loader.getValueClipPainter()).setBackground(null);
        ((ImagePainter)loader.getValueClipPainter()).setForeground(null);
        loader.setIndeterminate(true);
        loaderPanel.add((Component)loader);
        final JProgressBar ph = new JProgressBar();
        ph.setString(_GUI.T.DownloadsTable_DownloadsTable_init_plugins());
        LinkCollector.CRAWLERLIST_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new EDTRunner(){

                    protected void runInEDT() {
                        ph.setString(_GUI.T.LinkGrabberTable_LinkGrabberTable_object_wait_for_loading_links());
                    }
                };
            }
        });
        ph.setStringPainted(true);
        ph.setIndeterminate(true);
        loaderPanel.add((Component)ph, (Object)"alignx center");
        final LayoutManager orgLayout = this.getLayout();
        final Component rendererPane = this.getComponent(0);
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow]", "[grow]"));
        this.removeAll();
        this.add((Component)loaderPanel, "alignx center,aligny 20%");
        LinkCollector.CRAWLERLIST_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                LinkGrabberTable.this.removeLoaderPanel(loaderPanel, orgLayout, rendererPane);
            }
        });
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            int rowCount;
            if (SwingUtilities.isLeftMouseButton(e) && !this.isExpandToggleEvent(e) && this.getSelectionModel().getValueIsAdjusting() && this.rowAtPoint(e.getPoint()) < 0 && (rowCount = this.getRowCount()) > 0) {
                this.getSelectionModel().setAnchorSelectionIndex(rowCount - 1);
            }
        } else if (e.getID() == 502 && e.getButton() == 2 && (e.getModifiers() & 2) == 0 && (e.getModifiers() & 1) == 0) {
            LinkCollector.ConfirmLinksSettings cls = new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.MANUAL);
            cls.setClearLinkgrabberlistOnConfirm(false);
            cls.setSwitchToDownloadlistOnConfirm(false);
            cls.setForceDownloads(Boolean.FALSE);
            int row = this.rowAtPoint(e.getPoint());
            AbstractNode obj = (AbstractNode)this.getModel().getObjectbyRow(row);
            SelectionInfo si = this.isRowSelected(row) ? this.getSelectionInfo(true, true) : new SelectionInfo(obj);
            ConfirmLinksContextAction.confirmSelection(si, cls);
        }
        super.processMouseEvent(e);
    }

    protected void fireColumnModelUpdate() {
        super.fireColumnModelUpdate();
        new EDTRunner(){

            protected void runInEDT() {
                boolean alllocked = true;
                for (ExtColumn c : LinkGrabberTable.this.getModel().getColumns()) {
                    if (!c.isResizable()) continue;
                    alllocked = false;
                    break;
                }
                if (alllocked) {
                    JScrollPane sp = (JScrollPane)LinkGrabberTable.this.getParent().getParent();
                    CFG_GUI.HORIZONTAL_SCROLLBARS_IN_LINKGRABBER_TABLE_ENABLED.setValue((Object)true);
                    LinkGrabberTable.this.setColumnSaveID("hBAR");
                    LinkGrabberTable.this.setAutoResizeMode(0);
                    sp.setVerticalScrollBarPolicy(22);
                    sp.setHorizontalScrollBarPolicy(30);
                }
            }
        };
    }

    protected void removeLoaderPanel(final MigPanel loaderPanel, final LayoutManager orgLayout, final Component rendererPane) {
        new EDTRunner(){

            protected void runInEDT() {
                LinkGrabberTable.this.remove((Component)loaderPanel);
                LinkGrabberTable.this.setLayout(orgLayout);
                loaderPanel.setVisible(false);
                LinkGrabberTable.this.add(rendererPane);
                LinkGrabberTable.this.revalidate();
                LinkGrabberTable.this.repaint();
            }
        };
    }

    public void sortPackageChildren(ExtDefaultRowSorter<AbstractNode> rowSorter, String nextSortIdentifier) {
    }

    @Override
    protected boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        if (this.dupeManagerEnabled && obj != null && obj instanceof CrawledLink && DownloadController.getInstance().hasDownloadLinkByID(((CrawledLink)obj).getLinkID())) {
            JDGui.help((String)_GUI.T.LinkGrabberTable_onSingleClick_dupe_title(), (String)_GUI.T.LinkGrabberTable_onSingleClick_dupe_msg(), (Icon)new AbstractIcon("copy", 32));
        }
        return super.onSingleClick(e, obj);
    }

    protected boolean onHeaderSortClick(MouseEvent event, ExtColumn<AbstractNode> oldColumn, String oldIdentifier, ExtColumn<AbstractNode> newColumn) {
        if (((LinkGrabberTableModel)this.getModel()).isTristateSorterEnabled()) {
            return false;
        }
        if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
            UIOManager.I().showConfirmDialog(544, _JDT.T.getNextSortIdentifier_sort_warning_rly_title_(), _JDT.T.getNextSortIdentifier_sort_warning_rly_msg(newColumn.getName()), (Icon)new AbstractIcon("help", 32), _JDT.T.basics_yes(), _JDT.T.basics_no(), "org.jdownloader.gui.views.linkgrabber.LinkGrabberTable");
        }
        this.sortPackageChildren((ExtDefaultRowSorter<AbstractNode>)newColumn.getRowSorter(), this.getModel().getNextSortIdentifier(newColumn.getSortOrderIdentifier()));
        return true;
    }

    public boolean isSearchEnabled() {
        return false;
    }

    protected boolean onDoubleClick(MouseEvent e, AbstractNode obj) {
        return false;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, AbstractNode contextObject, List<AbstractNode> selection, ExtColumn<AbstractNode> column, MouseEvent ev) {
        ExtPopupMenu root = new ExtPopupMenu();
        MenuContainerRoot md = MenuManagerLinkgrabberTableContext.getInstance().getMenuData();
        new MenuBuilder(MenuManagerLinkgrabberTableContext.getInstance(), root, md).setHideOnClick(!ev.isShiftDown()).run();
        return root;
    }

    protected JPopupMenu columnControlMenu(ExtColumn<AbstractNode> extColumn) {
        JPopupMenu popup = super.columnControlMenu(extColumn);
        popup.add(new JSeparator());
        popup.add((JMenuItem)new ExtCheckBoxMenuItem((AbstractAction)((Object)new HorizontalScrollbarAction((ExtTable)this, CFG_GUI.HORIZONTAL_SCROLLBARS_IN_LINKGRABBER_TABLE_ENABLED))));
        return popup;
    }

    protected boolean onShortcutDelete(List<AbstractNode> selectedObjects, final KeyEvent evt, boolean direct) {
        this.getSelectionInfo(new PackageControllerTable.QueueSelectionInfoCallback<CrawledPackage, CrawledLink>(){

            @Override
            public void onSelectionInfo(SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
                ArrayList<CrawledLink> nodesToDelete = new ArrayList<CrawledLink>();
                boolean containsOnline = false;
                for (CrawledLink dl : selectionInfo.getChildren()) {
                    CrawledPackage parentNode = dl.getParentNode();
                    if (parentNode == null) continue;
                    nodesToDelete.add(dl);
                    if (CrawledPackage.TYPE.OFFLINE == parentNode.getType() || CrawledPackage.TYPE.POFFLINE == parentNode.getType() || dl.getDownloadLink().getAvailableStatus() == DownloadLink.AvailableStatus.FALSE) continue;
                    containsOnline = true;
                }
                if (nodesToDelete.size() > 0) {
                    LinkCollector.requestDeleteLinks(nodesToDelete, containsOnline, _GUI.T.GenericDeleteSelectedToolbarAction_updateName_object_selected_all(), evt.isControlDown(), false, false, false, false);
                }
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public Queue getQueue() {
                return TaskQueue.getQueue();
            }
        }, PackageControllerTable.SelectionType.SELECTED);
        return true;
    }

    @Override
    protected boolean updateMoveButtonEnabledStatus() {
        return super.updateMoveButtonEnabledStatus();
    }

    protected boolean onShortcutCopy(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getCopyAction().actionPerformed(new ActionEvent((Object)this, 1001, "copy"));
        return true;
    }

    protected boolean onShortcutCut(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getCutAction().actionPerformed(new ActionEvent((Object)this, 1001, "cut"));
        return true;
    }

    protected boolean onShortcutPaste(List<AbstractNode> selectedObjects, KeyEvent evt) {
        if (evt.isAltDown() || evt.isMetaDown() || evt.isAltGraphDown() || evt.isShiftDown()) {
            return false;
        }
        TransferHandler.getPasteAction().actionPerformed(new ActionEvent((Object)this, 1001, "paste"));
        return true;
    }

    @Override
    public ExtColumn<AbstractNode> getExpandCollapseColumn() {
        return LinkGrabberTableModel.getInstance().expandCollapse;
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        return new HashSet<AWTKeyStroke>();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        boolean actionNotified = false;
        try {
            InputMap map = this.getInputMap(condition);
            ActionMap am = this.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(stroke);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    if (action instanceof CustomizableAppAction) {
                        ((CustomizableAppAction)((Object)action)).requestUpdate((Object)this);
                    }
                    if (!action.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        actionNotified = SwingUtilities.notifyAction(action, stroke, evt, (Object)this, evt.getModifiers());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionNotified || super.processKeyBinding(stroke, evt, condition, pressed);
    }

    public void updateContextShortcuts() {
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        if (this.shortCutActions != null) {
            for (Map.Entry<KeyStroke, Action> ks : this.shortCutActions.entrySet()) {
                Object binding = input.get(ks.getKey());
                input.remove(ks.getKey());
                input2.remove(ks.getKey());
                input3.remove(ks.getKey());
                actions.remove(binding);
            }
        }
        this.shortCutActions = new HashMap();
        this.fillActions(MenuManagerLinkgrabberTableContext.getInstance().getMenuData());
        this.fillActions(MenuManagerLinkgrabberTabBottombar.getInstance().getMenuData());
    }

    private void fillActions(MenuContainer menuData) {
        if (!menuData._isValidated()) {
            return;
        }
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        for (MenuItemData mi : menuData.getItems()) {
            if (!mi._isValidated()) continue;
            if (mi instanceof MenuContainer) {
                this.fillActions((MenuContainer)mi);
                continue;
            }
            if (mi instanceof SeparatorData) continue;
            if (mi instanceof MenuLink) {
                List<AppAction> actionsList = ((MenuLink)((Object)mi)).createActionsToLink();
                if (actionsList == null) continue;
                for (AppAction action : actionsList) {
                    KeyStroke keystroke = (KeyStroke)action.getValue("AcceleratorKey");
                    if (keystroke == null) continue;
                    this.linkAction(input, input2, input3, actions, action, keystroke);
                }
                continue;
            }
            try {
                List<KeyStroke> moreShortCuts;
                KeyStroke keystroke;
                if (mi.getActionData() == null || !mi.getActionData()._isValidDataForCreatingAnAction()) continue;
                CustomizableAppAction action = mi.createAction();
                if (StringUtils.isNotEmpty((String)mi.getShortcut())) {
                    keystroke = KeyStroke.getKeyStroke(mi.getShortcut());
                    if (keystroke != null) {
                        action.setAccelerator(keystroke);
                    }
                } else if (MenuItemData.isEmptyValue(mi.getShortcut())) {
                    action.setAccelerator(null);
                }
                keystroke = (KeyStroke)((AppAction)action).getValue("AcceleratorKey");
                this.linkAction(input, input2, input3, actions, action, keystroke);
                if (!(action instanceof CustomizableAppAction) || (moreShortCuts = action.getAdditionalShortcuts(keystroke)) == null) continue;
                for (KeyStroke ks : moreShortCuts) {
                    if (ks == null) continue;
                    this.linkAction(input, input2, input3, actions, action, ks);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void linkAction(InputMap input, InputMap input2, InputMap input3, ActionMap actions, AppAction action, KeyStroke keystroke) {
        if (action != null && keystroke != null) {
            Object old;
            String key = "CONTEXT_ACTION_" + keystroke;
            try {
                old = input.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input2.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            try {
                old = input3.get(keystroke);
                if (old != null && ((Object)((Object)action)).getClass() != actions.get(old).getClass()) {
                    this.logger.warning("Duplicate Shortcuts: " + (Object)((Object)action) + " overwrites " + actions.get(old) + "(" + old + ") for keystroke " + keystroke);
                }
            }
            catch (Exception e) {
                this.logger.log((Throwable)e);
            }
            this.logger.info(keystroke + " -> " + (Object)((Object)action));
            input.put(keystroke, key);
            input2.put(keystroke, key);
            input3.put(keystroke, key);
            actions.put(key, (Action)((Object)action));
            this.shortCutActions.put(keystroke, (Action)((Object)action));
        }
    }

    public static LinkGrabberTable getInstance() {
        return INSTANCE;
    }

    public void linkAction(AppAction focusAction, KeyStroke ks) {
        if (focusAction == null) {
            return;
        }
        InputMap input = this.getInputMap(1);
        InputMap input2 = this.getInputMap(0);
        InputMap input3 = this.getInputMap(2);
        ActionMap actions = this.getActionMap();
        this.linkAction(input, input2, input3, actions, focusAction, ks);
    }
}

