/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtSpinner;
import org.appwork.swing.components.ExtTextField;
import org.appwork.utils.KeyUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.MenuLink;
import org.jdownloader.controlling.contextmenu.gui.MenuBuilder;
import org.jdownloader.extensions.ExtensionNotLoadedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.bottombar.SelfLayoutInterface;
import org.jdownloader.gui.views.linkgrabber.LinkgrabberSearchField;

public class LinkgrabberSearchMenuItem
extends MenuItemData
implements MenuLink,
SelfLayoutInterface {
    private static final String SHORTCUT2 = "shortcut";

    public LinkgrabberSearchMenuItem() {
        this.setName(_GUI.T.FilterMenuItem_FilterMenuItem());
        this.setIconKey("search");
        this.setVisible(true);
    }

    @Override
    public List<AppAction> createActionsToLink() {
        ArrayList<AppAction> ret = new ArrayList<AppAction>();
        LinkgrabberSearchField item = LinkgrabberSearchField.getInstance();
        KeyStroke ks = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        try {
            ActionData ad = this.getActionData();
            Object sc = ad.fetchSetup(SHORTCUT2);
            if (sc != null && sc instanceof String) {
                ks = KeyStroke.getKeyStroke((String)sc);
            }
        }
        catch (Throwable ad) {
            // empty catch block
        }
        AppAction a = item.getFocusAction();
        a.setAccelerator(ks);
        ret.add(a);
        return ret;
    }

    protected int _getMaxWidth() {
        int width = 10000;
        try {
            width = ((Number)this.getActionData().fetchSetup("maxWidth")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return width;
    }

    protected int _getMinWidth() {
        int width = 0;
        try {
            width = ((Number)this.getActionData().fetchSetup("minWidth")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return width;
    }

    @Override
    public JComponent createSettingsPanel() {
        ActionData ad = this.getActionData();
        if (ad == null) {
            ad = new ActionData();
            this.setActionData(ad);
        }
        final ActionData actionData = ad;
        MigPanel p = new MigPanel("ins 0,wrap 2", "[grow,fill][100:n:n,fill]", "[]");
        SwingUtils.setOpaque((JComponent)p, (boolean)false);
        final ExtTextField shortcut = new ExtTextField();
        shortcut.setHelpText(_GUI.T.InfoPanel_InfoPanel_shortcuthelp2());
        shortcut.setEditable(false);
        KeyStroke ks = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        try {
            Object sc = ad.fetchSetup(SHORTCUT2);
            if (sc != null && sc instanceof String) {
                ks = KeyStroke.getKeyStroke((String)sc);
            }
        }
        catch (Throwable sc) {
            // empty catch block
        }
        String msg1 = KeyUtils.getShortcutString((KeyStroke)ks, (boolean)true);
        shortcut.setText(msg1);
        shortcut.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent event) {
                String msg1 = KeyUtils.getShortcutString((KeyEvent)event, (boolean)true);
                KeyStroke currentShortcut = KeyStroke.getKeyStroke(event.getKeyCode(), event.getModifiersEx());
                shortcut.setText(msg1);
                actionData.putSetup(LinkgrabberSearchMenuItem.SHORTCUT2, currentShortcut == null ? null : currentShortcut.toString());
            }
        });
        p.add((Component)new JLabel(_GUI.T.InfoPanel_InfoPanel_shortcuts()));
        p.add((Component)shortcut, (Object)"split 2");
        JButton shortCutReset = new JButton((Action)((Object)new AppAction(){
            {
                this.setIconKey("reset");
            }

            public void actionPerformed(ActionEvent e) {
                new EDTRunner(){

                    protected void runInEDT() {
                        KeyStroke ks = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
                        String msg1 = KeyUtils.getShortcutString((KeyStroke)ks, (boolean)true);
                        shortcut.setText(msg1);
                        actionData.putSetup(LinkgrabberSearchMenuItem.SHORTCUT2, null);
                    }
                };
            }
        }));
        p.add((Component)shortCutReset, (Object)"width 22!,height 22!");
        p.add((Component)new JLabel(_GUI.T.MenuEditors_boxwidth_min()), (Object)"newline");
        int width = this._getMinWidth();
        final ExtSpinner minSpin = new ExtSpinner(new SpinnerNumberModel(width, -1, 10000, 1));
        minSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                actionData.putSetup("minWidth", ((Number)minSpin.getValue()).intValue());
            }
        });
        p.add((Component)minSpin);
        p.add((Component)new JLabel(_GUI.T.MenuEditors_boxwidth_pref()));
        width = this._getPrefWidth();
        final ExtSpinner prefSpin = new ExtSpinner(new SpinnerNumberModel(width, 0, 10000, 1));
        prefSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                actionData.putSetup("prefWidth", ((Number)prefSpin.getValue()).intValue());
            }
        });
        p.add((Component)prefSpin);
        p.add((Component)new JLabel(_GUI.T.MenuEditors_boxwidth_max()));
        width = this._getMaxWidth();
        final ExtSpinner maxSpin = new ExtSpinner(new SpinnerNumberModel(width, 0, 10000, 1));
        maxSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                actionData.putSetup("maxWidth", ((Number)maxSpin.getValue()).intValue());
            }
        });
        p.add((Component)maxSpin);
        return p;
    }

    protected int _getPrefWidth() {
        int width = 300;
        try {
            width = ((Number)this.getActionData().fetchSetup("prefWidth")).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return width;
    }

    @Override
    public String createConstraints() {
        return "height 24!,aligny top,pushx,growx,width " + this._getMinWidth() + ":" + this._getPrefWidth() + ":" + this._getMaxWidth();
    }

    @Override
    public JComponent createItem(MenuBuilder menuBuilder) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException, ExtensionNotLoadedException {
        LinkgrabberSearchField ret = LinkgrabberSearchField.getInstance();
        return ret;
    }
}

