/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.actions;

import java.util.EventListener;
import jd.controlling.TaskQueue;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.exttable.ExtTableEvent;
import org.appwork.swing.exttable.ExtTableListener;
import org.appwork.swing.exttable.ExtTableModelEventWrapper;
import org.appwork.swing.exttable.ExtTableModelListener;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.PackageControllerTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTableModel;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;

public class ConfirmSelectionBarAction
extends ConfirmLinksContextAction
implements ActionContext,
ExtTableListener,
ExtTableModelListener,
GenericConfigEventListener<Boolean> {
    private DelayedRunnable delayer = new DelayedRunnable(TaskQueue.TIMINGQUEUE, 500L, 1000L){

        public void delayedrun() {
            new EDTRunner(){

                protected void runInEDT() {
                    ConfirmSelectionBarAction.this.update();
                }
            };
        }
    };

    @Override
    protected String getTextForForcedAll() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_and_force_all();
    }

    @Override
    protected String getTextForForcedSelectionOnly() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_and_force_selection();
    }

    @Override
    protected String getTextForNoAutoStartAll() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_all();
    }

    @Override
    protected String getTextForNoAutoStartSelectionOnly() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_selection();
    }

    @Override
    protected String getTextForAutoStartAll() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_and_start_all();
    }

    @Override
    protected String getTextForAutoStartSelectionOnly() {
        return _GUI.T.ConfirmSelectionBarAction_main_button_add_and_start_selection();
    }

    @Override
    public void requestUpdate(Object requestor) {
        super.requestUpdate(requestor);
        this.updateListeners();
        this.update();
    }

    @Override
    public void setSelectionOnly(boolean selectionOnly) {
        super.setSelectionOnly(selectionOnly);
        this.updateListeners();
        this.update();
    }

    protected void updateListeners() {
        if (this.isSelectionOnly()) {
            LinkGrabberTableModel.getInstance().getEventSender().removeListener((EventListener)this);
            LinkGrabberTable.getInstance().getEventSender().addListener((EventListener)this, true);
        } else {
            LinkGrabberTable.getInstance().getEventSender().removeListener((EventListener)this);
            LinkGrabberTableModel.getInstance().getEventSender().addListener((EventListener)this, true);
        }
        switch (this.getAutoStart()) {
            case AUTO: {
                CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.getEventSender().addListener((EventListener)this, true);
                break;
            }
            default: {
                CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.getEventSender().removeListener((EventListener)this);
            }
        }
    }

    @Override
    protected void onRequestUpdateSelection(Object requestor, PackageControllerTable.SelectionType selectionType, SelectionInfo<CrawledPackage, CrawledLink> selectionInfo) {
    }

    @Override
    public ConfirmLinksContextAction setAutoStart(ConfirmLinksContextAction.AutoStartOptions autoStart) {
        ConfirmLinksContextAction ret = super.setAutoStart(autoStart);
        this.updateListeners();
        return ret;
    }

    @Override
    protected SelectionInfo<CrawledPackage, CrawledLink> getSelection() {
        if (!this.isSelectionOnly()) {
            return LinkGrabberTable.getInstance().getSelectionInfo(false, true);
        }
        return LinkGrabberTable.getInstance().getSelectionInfo(true, true);
    }

    protected void update() {
        this.setEnabled(this.hasSelection());
    }

    @Override
    public void initContextDefaults() {
        this.setCtrlToggle(false);
    }

    @Override
    protected void initTableContext(boolean empty, boolean selection) {
    }

    public void onExtTableEvent(ExtTableEvent<?> event) {
        if (event.getType() == ExtTableEvent.Types.SELECTION_CHANGED) {
            this.update();
        }
    }

    public void onExtTableModelEvent(ExtTableModelEventWrapper listener) {
        this.delayer.resetAndStart();
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        new EDTRunner(){

            protected void runInEDT() {
                ConfirmSelectionBarAction.this.updateLabelAndIcon();
            }
        };
    }
}

