/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.bottombar;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.Timer;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.autostart.AutoStartManagerListener;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import org.appwork.swing.components.tooltips.BasicExtTooltip;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;

public class AutoConfirmProcessIndicator
extends IconedProcessIndicator
implements AutoStartManagerListener {
    private static final long serialVersionUID = 8825003449642225290L;
    private final Timer timer = new Timer(100, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int max = LinkCollector.getInstance().getAutoStartManager().getMaximum();
            int value = LinkCollector.getInstance().getAutoStartManager().getValue();
            AutoConfirmProcessIndicator.this.setMaximum(max);
            AutoConfirmProcessIndicator.this.setValue(max - value);
        }
    });

    public AutoConfirmProcessIndicator() {
        super(NewTheme.I().getIcon("go-next", 16));
        this.timer.setRepeats(true);
        this.setToolTipText(_GUI.T.AutoConfirmButton_AutoConfirmButton_tooltip_());
    }

    public ExtTooltip createExtTooltip(Point mousePosition) {
        return new BasicExtTooltip((JComponent)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        LinkCollector.getInstance().getAutoStartManager().interrupt();
    }

    @Override
    public void onAutoStartManagerDone() {
        new EDTRunner(){

            protected void runInEDT() {
                AutoConfirmProcessIndicator.this.timer.stop();
                JDGui.getInstance().getStatusBar().removeProcessIndicator((JComponent)((Object)AutoConfirmProcessIndicator.this));
            }
        };
    }

    @Override
    public void onAutoStartManagerReset() {
        new EDTRunner(){

            protected void runInEDT() {
                JDGui.getInstance().getStatusBar().addProcessIndicator((JComponent)((Object)AutoConfirmProcessIndicator.this));
                if (!AutoConfirmProcessIndicator.this.timer.isRunning()) {
                    AutoConfirmProcessIndicator.this.timer.start();
                }
            }
        };
    }

    @Override
    public void onAutoStartManagerRunning() {
    }
}

