/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.columns;

import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.gui.views.linkgrabber.contextmenu.SetDownloadFolderInLinkgrabberAction;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;
import org.jdownloader.translate._JDT;

public class DownloadFolderColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private AbstractNode editing;
    private ExtButton open;

    public DownloadFolderColumn() {
        super(_GUI.T.LinkGrabberTableModel_initColumns_folder());
        this.setClickcount(0);
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public void focusGained(FocusEvent e) {
    }

    protected String getTooltipText(AbstractNode obj) {
        String ret = super.getTooltipText((Object)obj);
        if (StringUtils.isNotEmpty((String)ret)) {
            File raw = LinkTreeUtils.getRawDownloadDirectory(obj);
            String rawString = null;
            if (raw != null && (rawString = raw.getPath()).contains("<jd:")) {
                return "<html><pre>" + ret + "\r\n(" + rawString.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + ")</html>";
            }
        }
        return ret;
    }

    public boolean onRenameClick(MouseEvent e, AbstractNode obj) {
        SetDownloadFolderInLinkgrabberAction r = new SetDownloadFolderInLinkgrabberAction(new SelectionInfo<CrawledPackage, CrawledLink>(obj));
        r.requestUpdate((Object)this);
        r.actionPerformed(null);
        return true;
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    public boolean onDoubleClick(MouseEvent e, AbstractNode value) {
        if (CrossSystem.isOpenFileSupported() && value != null) {
            File ret = LinkTreeUtils.getDownloadDirectory(value);
            if (ret != null && ret.exists() && ret.isDirectory()) {
                CrossSystem.openFile((File)ret);
            }
            return true;
        }
        return false;
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        return false;
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    protected void setStringValue(final String value, final AbstractNode object) {
        File newPath;
        if (StringUtils.isEmpty((String)value) || object == null) {
            return;
        }
        File oldPath = LinkTreeUtils.getDownloadDirectory(object);
        if (oldPath.equals(newPath = LinkTreeUtils.getDownloadDirectory(value, null, object))) {
            return;
        }
        if (object instanceof CrawledPackage) {
            LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(Queue.QueuePriority.HIGH){

                protected Object run() {
                    ((CrawledPackage)object).setDownloadFolder(value);
                    return null;
                }
            });
            return;
        }
        if (object instanceof CrawledLink) {
            final CrawledPackage p = ((CrawledLink)object).getParentNode();
            try {
                Dialog.getInstance().showConfirmDialog(4128, _JDT.T.SetDownloadFolderAction_actionPerformed_(p.getName()), _JDT.T.SetDownloadFolderAction_msg(p.getName(), 1), null, _JDT.T.SetDownloadFolderAction_yes(), _JDT.T.SetDownloadFolderAction_no());
                LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(Queue.QueuePriority.HIGH){

                    protected Object run() {
                        p.setDownloadFolder(value);
                        return null;
                    }
                });
                return;
            }
            catch (DialogClosedException e) {
                return;
            }
            catch (DialogCanceledException e) {
                final CrawledPackage pkg = new CrawledPackage();
                pkg.setExpanded(CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded());
                if (CrawledPackage.TYPE.NORMAL != p.getType()) {
                    String packagename = object instanceof AbstractPackageNode ? object.getName() : LinknameCleaner.derivePackagenameFromFilename(object.getName());
                    pkg.setName(packagename);
                } else {
                    pkg.setName(p.getName());
                }
                pkg.setComment(p.getComment());
                pkg.setDownloadFolder(value);
                final ArrayList<CrawledLink> links = new ArrayList<CrawledLink>();
                links.add((CrawledLink)object);
                LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Object, RuntimeException>(Queue.QueuePriority.HIGH){

                    protected Object run() {
                        LinkCollector.getInstance().moveOrAddAt(pkg, links, -1);
                        return null;
                    }
                });
            }
        }
    }

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof AbstractPackageNode) {
            return ((AbstractPackageNode)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    public String getStringValue(AbstractNode value) {
        File ret = LinkTreeUtils.getDownloadDirectory(value);
        if (ret != null) {
            return ret.toString();
        }
        return null;
    }
}

