/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.columns;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jd.controlling.ClipboardMonitoring;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.gui.swing.jdgui.JDGui;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.DefaultDownloadLinkViewImpl;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.columns.FileColumn;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.UrlDisplayType;

public class UrlColumn
extends ExtTextColumn<AbstractNode> {
    private static final long serialVersionUID = 1L;
    private long lastHide = 0L;
    private AbstractNode editing = null;
    private JPopupMenu popup;

    public boolean isEnabled(AbstractNode obj) {
        if (obj instanceof CrawledPackage) {
            return ((CrawledPackage)obj).getView().isEnabled();
        }
        return obj.isEnabled();
    }

    protected boolean isEditable(AbstractNode obj, boolean enabled) {
        return false;
    }

    public boolean isDefaultVisible() {
        return false;
    }

    public JPopupMenu createHeaderPopup() {
        return FileColumn.createColumnPopup((ExtColumn<AbstractNode>)this, this.getMinWidth() == this.getMaxWidth() && this.getMaxWidth() > 0);
    }

    public boolean onSingleClick(MouseEvent e, AbstractNode obj) {
        return super.onSingleClick(e, (Object)obj);
    }

    public UrlColumn() {
        super(_GUI.T.LinkGrabberTableModel_initColumns_url());
        this.setClickcount(2);
    }

    public void focusGained(FocusEvent e) {
    }

    public boolean isEditable(AbstractNode obj) {
        return false;
    }

    private boolean isOpenURLAllowed(AbstractNode value) {
        DownloadLink dlLink = this.getLink(value);
        return dlLink != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DownloadLink getLink(AbstractNode value) {
        if (value instanceof AbstractPackageNode) {
            AbstractPackageNode pkg = (AbstractPackageNode)value;
            boolean readL = pkg.getModifyLock().readLock();
            try {
                if (pkg.getChildren().size() != 1) return null;
                AbstractNode node = (AbstractNode)pkg.getChildren().get(0);
                if (node instanceof CrawledLink) {
                    DownloadLink downloadLink = ((CrawledLink)node).getDownloadLink();
                    return downloadLink;
                }
                if (!(node instanceof DownloadLink)) return null;
                DownloadLink downloadLink = (DownloadLink)node;
                return downloadLink;
            }
            finally {
                pkg.getModifyLock().readUnlock(readL);
            }
        } else {
            if (value instanceof CrawledLink) {
                return ((CrawledLink)value).getDownloadLink();
            }
            if (!(value instanceof DownloadLink)) return null;
            return (DownloadLink)value;
        }
    }

    public boolean onDoubleClick(MouseEvent e, AbstractNode value) {
        int row = this.getModel().getTable().rowAtPoint(new Point(e.getX(), e.getY()));
        JDGui.help((String)_GUI.T.UrlColumn_onDoubleClick_help_title(), (String)_GUI.T.UrlColumn_onDoubleClick_help_msg(), (Icon)new AbstractIcon("url", 32));
        long timeSinceLastHide = System.currentTimeMillis() - this.lastHide;
        if (timeSinceLastHide < 250L && this.editing == value) {
            this.editing = null;
            this.repaint();
            return true;
        }
        if (!this.isOpenURLAllowed(value)) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        this.editing = value;
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    UrlColumn.this.lastHide = System.currentTimeMillis();
                }
            }
        };
        try {
            DownloadLink dlLink = this.getLink(this.editing);
            if (!Application.isJared(null)) {
                this.popup.add(SwingUtils.toBold((JLabel)new JLabel("Debug View. Jared Version does not show  Identifier, Plugin Pattern & Null Entries|" + (Object)((Object)dlLink.getUrlProtection()))));
            }
            for (UrlDisplayType dt : DefaultDownloadLinkViewImpl.DISPLAY_URL_TYPE) {
                if (dt == null) continue;
                if (dt == UrlDisplayType.CONTENT && !Application.isJared(null)) {
                    String link = LinkTreeUtils.getUrlByType(dt, dlLink);
                    if (StringUtils.equals((String)link, (String)dlLink.getPluginPatternMatcher())) {
                        link = null;
                    }
                    this.add(this.popup, dt, link);
                    continue;
                }
                this.add(this.popup, dt, LinkTreeUtils.getUrlByType(dt, dlLink));
            }
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                this.popup.add(new JSeparator());
                this.add(this.popup, null, dlLink.getPluginPatternMatcher());
                final String linkID = dlLink.getLinkID();
                this.popup.add((Action)((Object)new AppAction(){
                    {
                        this.setName(_GUI.T.UrlColumn_onDoubleClick_object_copy("LINKID: " + linkID));
                        this.setIconKey("copy");
                    }

                    public void actionPerformed(ActionEvent e) {
                        ClipboardMonitoring.getINSTANCE().setCurrentContent(linkID);
                    }
                }));
            }
            Rectangle bounds = this.getModel().getTable().getCellRect(row, this.getIndex(), true);
            Dimension pref = this.popup.getPreferredSize();
            this.popup.setPreferredSize(new Dimension(Math.max(pref.width, bounds.width), pref.height));
            this.popup.show((Component)this.getModel().getTable(), bounds.x, bounds.y + bounds.height);
            return true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return true;
        }
    }

    private void add(JPopupMenu popup, final UrlDisplayType dt, final String string) {
        if (string == null && Application.isJared(null)) {
            return;
        }
        popup.add((Action)((Object)new AppAction(){
            {
                if (Application.isJared(null)) {
                    this.setName(_GUI.T.UrlColumn_onDoubleClick_object_copy(dt.getTranslatedName() + ": " + string));
                } else if (dt == null) {
                    this.setName(_GUI.T.UrlColumn_onDoubleClick_object_copy("PLUGIN_PATTERN: " + string));
                } else {
                    this.setName(_GUI.T.UrlColumn_onDoubleClick_object_copy(dt.getTranslatedName() + ": " + string));
                }
                this.setIconKey("copy");
            }

            public void actionPerformed(ActionEvent e) {
                ClipboardMonitoring.getINSTANCE().setCurrentContent(string);
            }
        }));
    }

    public boolean isSortable(AbstractNode obj) {
        return true;
    }

    protected void setStringValue(String value, AbstractNode object) {
    }

    public String getStringValue(AbstractNode value) {
        if (value instanceof CrawledPackage) {
            return ((CrawledPackage)value).getView().getCommonSourceUrl();
        }
        if (value instanceof FilePackage) {
            return ((FilePackage)value).getView().getCommonSourceUrl();
        }
        if (value instanceof CrawledLink) {
            return ((CrawledLink)value).getDownloadLink().getView().getDisplayUrl();
        }
        if (value instanceof DownloadLink) {
            return ((DownloadLink)value).getView().getDisplayUrl();
        }
        return null;
    }
}

