/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.columns;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.views.settings.ConfigurationView;
import jd.gui.swing.jdgui.views.settings.panels.pluginsettings.PluginSettings;
import jd.plugins.DownloadLink;
import org.appwork.storage.config.JsonConfig;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.JScrollPopupMenu;
import org.appwork.swing.exttable.ExtMenuItem;
import org.appwork.swing.exttable.columns.ExtComboColumn;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.controlling.linkcrawler.LinkVariant;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.linkgrabber.columns.VariantsModel;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.BadgeIcon;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class VariantColumn
extends ExtComboColumn<AbstractNode, LinkVariant> {
    private boolean autoVisible;
    private boolean alwaysVisible;

    public VariantColumn(boolean alwaysVisible) {
        super(_GUI.T.VariantColumn_VariantColumn_name_(), null);
        this.alwaysVisible = alwaysVisible;
    }

    protected Icon createDropDownIcon() {
        return new AbstractIcon("popDownLarge", -1);
    }

    public JPopupMenu createPopupMenu() {
        return new JScrollPopupMenu(){
            {
                this.setMaximumVisibleRows(20);
            }

            public void setVisible(boolean b) {
                super.setVisible(b);
                if (!b) {
                    VariantColumn.this.lastHide = System.currentTimeMillis();
                }
            }
        };
    }

    protected JComponent getPopupElement(LinkVariant object, boolean selected, AbstractNode value) {
        JComponent ret = null;
        if (value instanceof CrawledLink && ((CrawledLink)value).hasVariantSupport()) {
            ret = ((CrawledLink)value).gethPlugin().getVariantPopupComponent(((CrawledLink)value).getDownloadLink());
        }
        if (ret != null) {
            return ret;
        }
        return super.getPopupElement((Object)object, selected, (Object)value);
    }

    protected void fillPopup(JPopupMenu popup, AbstractNode value, LinkVariant selected, ComboBoxModel<LinkVariant> dm) {
        Object ret = null;
        if (value instanceof CrawledLink) {
            CrawledLink link = (CrawledLink)value;
            if (link.hasVariantSupport() && link.gethPlugin().fillVariantsPopup(this, popup, value, selected, dm)) {
                return;
            }
            this.fillPopupWithVariants(popup, value, selected, dm);
            popup.add(new JSeparator());
            JMenu m = new JMenu(_GUI.T.VariantColumn_fillPopup_add());
            m.setIcon(new AbstractIcon("add", 18));
            this.fillPopupWithAddAdditionalSubmenu(popup, m, dm, link);
            this.fillPopupWithPluginSettingsButton(popup, link);
        }
    }

    public void fillPopupWithPluginSettingsButton(final JPopupMenu popup, final CrawledLink link) {
        popup.add(new JMenuItem((Action)new BasicAction(){
            {
                this.setSmallIcon((Icon)new BadgeIcon(new AbstractIcon("settings", 18), link.getDomainInfo().getIcon(10), 0, 0).crop(18, 18));
                this.setName(_GUI.T.VariantColumn_fillPopup_settings(link.getDownloadLink().getDefaultPlugin().getHost()));
            }

            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
                ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).setConfigViewVisible(true);
                JDGui.getInstance().setContent((View)ConfigurationView.getInstance(), true);
                ConfigurationView.getInstance().setSelectedSubPanel(PluginSettings.class);
                ((PluginSettings)ConfigurationView.getInstance().getSubPanel(PluginSettings.class)).setPlugin((LazyPlugin)link.getDownloadLink().getDefaultPlugin().getLazyP());
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPopupWithAddAdditionalSubmenu(JPopupMenu popup, JMenu m, ComboBoxModel<LinkVariant> dm, final CrawledLink link) {
        final HashSet<String> dupeSet = new HashSet<String>();
        CrawledPackage parent = link.getParentNode();
        boolean readL = parent.getModifyLock().readLock();
        try {
            for (CrawledLink cl : parent.getChildren()) {
                dupeSet.add(cl.getLinkID());
            }
        }
        finally {
            parent.getModifyLock().readUnlock(readL);
        }
        for (int i = 0; i < dm.getSize(); ++i) {
            final LinkVariant o = (LinkVariant)dm.getElementAt(i);
            ExtMenuItem mi = new ExtMenuItem((AbstractAction)new BasicAction(){
                private CrawledLink cl;
                {
                    DownloadLink dl = link.getDownloadLink();
                    DownloadLink dllink = new DownloadLink(link.getDownloadLink().getDefaultPlugin(), link.getDownloadLink().getView().getDisplayName(), link.getDownloadLink().getHost(), link.getDownloadLink().getPluginPatternMatcher(), true);
                    dllink.setProperties(link.getDownloadLink().getProperties());
                    dllink.setProperty("DUMMY", true);
                    this.cl = new CrawledLink(dllink);
                    this.setSmallIcon(o._getIcon(link));
                    this.setName(o._getName(link));
                    this.cl.getDownloadLink().getDefaultPlugin().setActiveVariantByLink(this.cl.getDownloadLink(), o);
                    this.setEnabled(!dupeSet.contains(this.cl.getLinkID()));
                }

                public void actionPerformed(ActionEvent e) {
                    if (!this.isEnabled()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    final ArrayList<CrawledLink> list = new ArrayList<CrawledLink>();
                    list.add(this.cl);
                    dupeSet.add(this.cl.getLinkID());
                    LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            LinkCollector.getInstance().moveOrAddAt(link.getParentNode(), list, link.getParentNode().indexOf(link) + 1);
                            ArrayList<CrawledLink> checkableLinks = new ArrayList<CrawledLink>(1);
                            checkableLinks.add(cl);
                            LinkChecker<ArrayList<CrawledLink>> linkChecker = new LinkChecker<ArrayList<CrawledLink>>(true);
                            linkChecker.check(checkableLinks);
                            return null;
                        }
                    });
                    this.setEnabled(false);
                }
            });
            m.add((JMenuItem)mi);
            mi.setHideOnClick(false);
        }
        popup.add(m);
    }

    public void fillPopupWithVariants(JPopupMenu popup, AbstractNode value, LinkVariant selected, ComboBoxModel<LinkVariant> dm) {
        super.fillPopup(popup, (Object)value, (Object)selected, dm);
    }

    protected String modelItemToString(LinkVariant selectedItem, AbstractNode value) {
        if (selectedItem == null) {
            return null;
        }
        return selectedItem._getName(value);
    }

    protected String getTooltipText(AbstractNode obj) {
        LinkVariant variant = this.getSelectedItem(obj);
        if (variant == null) {
            return null;
        }
        return variant._getTooltipDescription(obj);
    }

    protected Icon modelItemToIcon(LinkVariant selectedItem, AbstractNode value) {
        if (selectedItem == null) {
            return null;
        }
        return selectedItem._getIcon(value);
    }

    public boolean isEditable(AbstractNode object) {
        if (object instanceof CrawledLink && ((CrawledLink)object).hasVariantSupport()) {
            return ((CrawledLink)object).gethPlugin().hasVariantToChooseFrom(((CrawledLink)object).getDownloadLink());
        }
        return false;
    }

    protected LinkVariant getSelectedItem(AbstractNode object) {
        if (object instanceof CrawledLink) {
            if (!((CrawledLink)object).hasVariantSupport()) {
                return null;
            }
            return ((CrawledLink)object).gethPlugin().getActiveVariantByLink(((CrawledLink)object).getDownloadLink());
        }
        return null;
    }

    protected void setSelectedItem(AbstractNode object, LinkVariant value) {
        if (object instanceof CrawledLink) {
            LinkCollector.getInstance().setActiveVariantForLink((CrawledLink)object, value);
        } else if (object instanceof DownloadLink) {
            // empty if block
        }
    }

    public ComboBoxModel<LinkVariant> updateModel(ComboBoxModel<LinkVariant> dataModel, AbstractNode object) {
        if (object instanceof CrawledLink) {
            if (!((CrawledLink)object).hasVariantSupport()) {
                return null;
            }
            List<? extends LinkVariant> variants = ((CrawledLink)object).gethPlugin().getVariantsByLink(((CrawledLink)object).getDownloadLink());
            return new VariantsModel(variants);
        }
        if (object instanceof DownloadLink) {
            if (!((DownloadLink)object).hasVariantSupport()) {
                return null;
            }
            List<? extends LinkVariant> variants = ((DownloadLink)object).getDefaultPlugin().getVariantsByLink((DownloadLink)object);
            return new VariantsModel(variants);
        }
        return null;
    }

    public boolean isVisible(boolean savedValue) {
        return (this.autoVisible || this.alwaysVisible) && savedValue;
    }

    public boolean setAutoVisible(boolean b) {
        if (b == this.autoVisible) {
            return false;
        }
        this.autoVisible = b;
        return true;
    }
}

