/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.gui.views.linkgrabber.contextmenu;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.CustomizableTableContextAppAction;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.gui.packagehistorycontroller.DownloadPathHistoryManager;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.components.LocationInList;
import org.jdownloader.gui.views.linkgrabber.contextmenu.NewPackageDialog;
import org.jdownloader.translate._JDT;

public abstract class AbstractMergeToPackageAction<PackageType extends AbstractPackageNode<ChildrenType, PackageType>, ChildrenType extends AbstractPackageChildrenNode<PackageType>>
extends CustomizableTableContextAppAction<PackageType, ChildrenType>
implements ActionContext {
    private static final long serialVersionUID = -4468197802870765463L;
    private boolean expandNewPackage = false;
    private boolean lastPathDefault = false;
    private LocationInList location = LocationInList.END_OF_LIST;

    public AbstractMergeToPackageAction() {
        this.setName(_GUI.T.MergeToPackageAction_MergeToPackageAction_());
        this.setIconKey("package_new");
    }

    public static String getTranslationForExpandNewPackage() {
        return _JDT.T.MergeToPackageAction_getTranslationForExpandNewPackage();
    }

    @Customizer(link="#getTranslationForExpandNewPackage")
    public boolean isExpandNewPackage() {
        return this.expandNewPackage;
    }

    public void setExpandNewPackage(boolean expandNewPackage) {
        this.expandNewPackage = expandNewPackage;
    }

    public static String getTranslationForLastPathDefault() {
        return _JDT.T.MergeToPackageAction_getTranslationForLastPathDefault();
    }

    @Customizer(link="#getTranslationForLastPathDefault")
    public boolean isLastPathDefault() {
        return this.lastPathDefault;
    }

    public void setLastPathDefault(boolean lastPathDefault) {
        this.lastPathDefault = lastPathDefault;
    }

    public static String getTranslationForLocation() {
        return _JDT.T.MergeToPackageAction_getTranslationForLocation();
    }

    @Customizer(link="#getTranslationForLocation")
    public LocationInList getLocation() {
        return this.location;
    }

    public void setLocation(LocationInList location) {
        this.location = location;
    }

    @Override
    public void addContextSetup(ActionContext contextSetup) {
        super.addContextSetup(contextSetup);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        NewPackageDialog d = null;
        final SelectionInfo sel = this.getSelection();
        try {
            List<String> paths;
            d = new NewPackageDialog(sel){

                public String getDontShowAgainKey() {
                    return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + AbstractMergeToPackageAction.this.getClass().getSimpleName();
                }
            };
            if (this.isLastPathDefault() && (paths = DownloadPathHistoryManager.getInstance().listPaths(null)) != null && paths.size() > 0) {
                d.setDownloadFolder(paths.get(0));
            }
            Dialog.getInstance().showDialog((AbstractDialog)d);
        }
        catch (DialogNoAnswerException e1) {
            return;
        }
        final String name = d.getName();
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        final String downloadFolder = d.getDownloadFolder();
        final PackageController controller = sel.getController();
        controller.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                Object newPackage = AbstractMergeToPackageAction.this.createNewPackage(name, downloadFolder);
                newPackage.setExpanded(AbstractMergeToPackageAction.this.isExpandNewPackage());
                String packageComment = AbstractMergeToPackageAction.this.mergePackageViewListComments(sel.getPackageViews());
                if (!StringUtils.isEmpty((String)packageComment)) {
                    newPackage.setComment(packageComment);
                }
                switch (AbstractMergeToPackageAction.this.getLocation()) {
                    case AFTER_SELECTION: {
                        int index = -1;
                        for (SelectionInfo.PackageView pv : sel.getPackageViews()) {
                            index = Math.max(index, controller.indexOf(pv.getPackage()) + 1);
                        }
                        controller.moveOrAddAt(newPackage, sel.getChildren(), 0, index);
                        return null;
                    }
                    case BEFORE_SELECTION: {
                        int index = Integer.MAX_VALUE;
                        for (SelectionInfo.PackageView pv : sel.getPackageViews()) {
                            index = Math.min(index, controller.indexOf(pv.getPackage()));
                        }
                        if (index == Integer.MAX_VALUE) {
                            index = 0;
                        }
                        controller.moveOrAddAt(newPackage, sel.getChildren(), 0, index);
                        return null;
                    }
                    case END_OF_LIST: {
                        controller.moveOrAddAt(newPackage, sel.getChildren(), 0, -1);
                        return null;
                    }
                    case TOP_OF_LIST: {
                        controller.moveOrAddAt(newPackage, sel.getChildren(), 0, 0);
                        return null;
                    }
                }
                return null;
            }
        });
    }

    protected abstract PackageType createNewPackage(String var1, String var2);

    protected String mergePackageViewListComments(List<SelectionInfo.PackageView<PackageType, ChildrenType>> packages) {
        ArrayList<PackageType> crawledpackagelist = new ArrayList<PackageType>();
        for (SelectionInfo.PackageView<PackageType, ChildrenType> pv : packages) {
            crawledpackagelist.add(pv.getPackage());
        }
        return this.mergePackageComments(crawledpackagelist);
    }

    protected String mergePackageComments(List<PackageType> packages) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> commentDups = new HashSet<String>();
        for (AbstractPackageNode cp : packages) {
            String[] commentLines;
            String comment = cp.getComment();
            if (!StringUtils.isNotEmpty((String)comment)) continue;
            for (String commentLine : commentLines = Regex.getLines((String)comment)) {
                if (!StringUtils.isNotEmpty((String)commentLine) || !commentDups.add(commentLine)) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(commentLine);
            }
        }
        return sb.toString();
    }
}

